/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class ContractPersonalTariff
extends BGUPanel {
    private CardLayout cardLayout = new CardLayout();
    private PersonalTariffTableModel tableModel = new PersonalTariffTableModel();
    private TariffTree tariffTree = new TariffTree();
    private JPanel tablePanel = new JPanel(new GridBagLayout());
    private JPanel treePanel = new JPanel(new GridBagLayout());

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.tableModel);
        JButton showTree = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
        showTree.addActionListener(e -> this.openTree());
        this.tablePanel.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tablePanel.add((Component)showTree, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JButton showTable = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0434\u0435\u0440\u0435\u0432\u043e");
        showTable.addActionListener(e -> this.openTable());
        this.treePanel.add(this.tariffTree.getViewable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.treePanel.add((Component)showTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)this.tablePanel, "table");
        this.add((Component)this.treePanel, "tree");
        this.cardLayout.show(this, "table");
        BGSwingUtilites.handleEdit((JTable)table, this, "edit");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.tablePanel.isVisible()) {
                this.tryCall(() -> this.tableModel.setData(((ClientContext)this.getContext()).getWebService(ContractTariffService.class).personalTariffList(((ClientContext)this.getContext()).getContractId())));
            }
        }).setIcon(ClientUtils.getIcon("refresh"));
        new AbstractBGUPanel.BGActionNew(e -> {
            if (this.tablePanel.isVisible()) {
                PersonalTariff personalTariff = new PersonalTariff();
                personalTariff.setContractId(((ClientContext)this.getContext()).getContractId());
                personalTariff.setDate1(new GregorianCalendar());
                new PersonalTariffEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444", personalTariff).open();
            }
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.tablePanel.isVisible()) {
                this.tableModel.optSelectedRow().map(a -> this.getPersonalTariff(a.getId())).ifPresentOrElse(personalTariff -> new PersonalTariffEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430", (PersonalTariff)personalTariff).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            PersonalTariff personalTariff;
            if (this.tablePanel.isVisible() && (personalTariff = (PersonalTariff)this.tableModel.getSelectedRow()) != null && ClientUtils.confirmDelete("\u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 [#" + personalTariff.getId() + "]")) {
                this.tryCall(() -> {
                    ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).personalTariffDelete(((ClientContext)this.getContext()).getContractId(), personalTariff.getId());
                    this.performAction("refresh");
                    EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
                });
            }
        });
    }

    private PersonalTariff getPersonalTariff(int id) {
        PersonalTariff personalTariff = null;
        try {
            personalTariff = ((ClientContext)this.getContext()).getWebService(ContractTariffService.class).personalTariffGet(id);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return personalTariff;
    }

    private void openTree() {
        PersonalTariff personalTariff = (PersonalTariff)this.tableModel.getSelectedRow();
        if (personalTariff != null) {
            this.tariffTree.init(this, personalTariff.getTreeId());
            this.cardLayout.show(this, "tree");
        } else {
            ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        }
    }

    private void openTable() {
        this.tariffTree.close();
        this.cardLayout.show(this, "table");
    }

    class PersonalTariffTableModel
    extends BGTableModel<PersonalTariff> {
        public PersonalTariffTableModel() {
            super(PersonalTariffTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u0437\u0438\u0446\u0438\u044f", 100, 100, 100, "pos", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", true, new PeriodTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, 200, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(PersonalTariff val, int column) throws Exception {
            if ("period".equals(this.getIdentifier(column))) {
                return new Period(TimeUtils.convertCalendarToDate(val.getDate1()), TimeUtils.convertCalendarToDate(val.getDate2()));
            }
            return super.getValue(val, column);
        }
    }

    class PersonalTariffEditorDialog
    extends BGEditorDialog<PersonalTariff> {
        private BGTextField title;
        private BGControlPanelDateNoB date1;
        private BGControlPanelDateNoB date2;
        private BGIntTextField pos;
        private BGTextField titleWeb;
        private BGConfigEditorPane config;

        public PersonalTariffEditorDialog(String title, PersonalTariff data) {
            super(title, data);
            this.title = new BGTextField(10);
            this.date1 = new BGControlPanelDateNoB();
            this.date2 = new BGControlPanelDateNoB();
            this.pos = new BGIntTextField(5);
            this.titleWeb = new BGTextField(10);
            this.config = new BGConfigEditorPane();
        }

        @Override
        public void doDialogPanel() {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.add((Component)this.getBasePanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
            tabbedPane.add((Component)this.getConfigPanel(), "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
            this.panel.add((Component)tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
            this.title.setText(((PersonalTariff)this.data).getTitle());
            this.titleWeb.setText(((PersonalTariff)this.data).getTitleWeb());
            this.date1.setDateCalendar(((PersonalTariff)this.data).getDate1());
            this.date2.setDateCalendar(((PersonalTariff)this.data).getDate2());
            this.pos.setText(String.valueOf(((PersonalTariff)this.data).getPos()));
            this.config.setText(((PersonalTariff)this.data).getConfig());
        }

        private JPanel getBasePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.pos, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043b\u0438\u0447\u043d\u043e\u043c \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.titleWeb, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.getPosPeriodPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 5, 0, 5), 0, 0));
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
            return panel;
        }

        private JPanel getConfigPanel() {
            JScrollPane scrollPane = new JScrollPane(this.config);
            scrollPane.setPreferredSize(new Dimension(600, 200));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        private JPanel getPosPeriodPanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.date1, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel(" \u043f\u043e "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.date2, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            String text = this.title.getText();
            if (Utils.isBlankString(text)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430!");
                return false;
            }
            if (this.date1.getDateString().isEmpty()) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return false;
            }
            return this.tryCallBoolean(() -> {
                ((PersonalTariff)this.data).setTitle(this.title.getText());
                ((PersonalTariff)this.data).setTitleWeb(this.titleWeb.getText());
                ((PersonalTariff)this.data).setConfig(this.config.getText());
                ((PersonalTariff)this.data).setPos(Utils.parseInt(this.pos.getText()));
                ((PersonalTariff)this.data).setDate1(this.date1.getDateCalendar());
                ((PersonalTariff)this.data).setDate2(this.date2.getDateCalendar());
                ((ClientContext)ContractPersonalTariff.this.getContext()).getWebService(ContractTariffService.class).personalTariffUpdate(((ClientContext)ContractPersonalTariff.this.getContext()).getContractId(), (PersonalTariff)this.data);
                ContractPersonalTariff.this.performAction("refresh");
            });
        }
    }
}

