/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.server;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.CachedDirectory;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItemModifiedEvent;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.SystemEventListener;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.common.model.Id;

final class ServerDirectoryInfo<K extends Id>
implements SystemEventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Class<?>, ServerDirectoryInfo<?>> DIRECTORY_INFO_MAP = new ConcurrentHashMap();
    private static final Random RANDOM = new Random();
    final Class<K> clazz;
    final Class<? extends DirectoryItemModifiedEvent<?>> eventClass;
    private final EventFactory eventFactory;
    private final DaoFactory daoFactory;
    private final ConcurrentMap<Integer, ModuleInfo> moduleMap = new ConcurrentHashMap<Integer, ModuleInfo>();

    public static <K extends Id> ServerDirectoryInfo<K> getInstance(Class<K> clazz) throws BGException {
        ServerDirectoryInfo<K> newResult;
        ServerDirectoryInfo<K> result = (ServerDirectoryInfo<K>)DIRECTORY_INFO_MAP.get(clazz);
        if (result == null && (result = DIRECTORY_INFO_MAP.putIfAbsent(clazz, newResult = new ServerDirectoryInfo<K>(clazz))) == null) {
            final ServerDirectoryInfo<K> result_ = result = newResult;
            new Thread("ServerDirectoryInfo-init"){

                @Override
                public void run() {
                    try {
                        EventProcessor.getInstance().addListener(result_, result_.eventClass);
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }.start();
        }
        return result;
    }

    private ServerDirectoryInfo(Class<K> clazz) throws BGException {
        this.clazz = clazz;
        DirectoryItem directoryItem = clazz.getAnnotation(DirectoryItem.class);
        if (directoryItem == null) {
            throw new IllegalArgumentException("Annotation DirectoryItem not found in " + String.valueOf(clazz) + "!");
        }
        this.eventClass = directoryItem.eventClass();
        if (this.eventClass == DirectoryItem.NO_EVENT.class) {
            this.eventFactory = null;
            this.daoFactory = null;
        } else {
            EventFactory eventFactory;
            try {
                Constructor<? extends DirectoryItemModifiedEvent<?>> eventConstructor = this.eventClass.getConstructor(Integer.TYPE, Integer.TYPE, clazz, clazz);
                eventFactory = new EventFactory(this, (Constructor)eventConstructor){

                    @Override
                    public DirectoryItemModifiedEvent<?> newInstance(int moduleId, int userId, K oldItem, K newItem) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
                        return (DirectoryItemModifiedEvent)this.constructor.newInstance(moduleId, userId, oldItem, newItem);
                    }
                };
            }
            catch (Exception ex) {
                try {
                    Constructor<? extends DirectoryItemModifiedEvent<?>> eventConstructor = this.eventClass.getConstructor(Integer.TYPE, clazz, clazz);
                    eventFactory = new EventFactory(this, (Constructor)eventConstructor){

                        @Override
                        public DirectoryItemModifiedEvent<?> newInstance(int moduleId, int userId, K oldItem, K newItem) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
                            assert (moduleId == 0);
                            return (DirectoryItemModifiedEvent)this.constructor.newInstance(userId, oldItem, newItem);
                        }
                    };
                }
                catch (Exception ex2) {
                    throw new BGException("Event constructor not found!", ex);
                }
            }
            this.eventFactory = eventFactory;
            try {
                DaoFactory daoFactory;
                Class<Directory> managerClass;
                Object name = clazz.getName();
                int index = ((String)name).lastIndexOf(".common.");
                name = ((String)name).substring(0, index) + ".server." + ((String)name).substring(index + 8);
                try {
                    managerClass = Class.forName((String)name + "Manager").asSubclass(Directory.class);
                }
                catch (ClassNotFoundException e) {
                    managerClass = Class.forName((String)name + "Dao").asSubclass(Directory.class);
                }
                try {
                    Constructor<Directory> daoConstructor = managerClass.getConstructor(Connection.class, Integer.TYPE);
                    daoFactory = new DaoFactory(this, daoConstructor){

                        @Override
                        public Directory<K> newInstance(Connection con, int moduleId) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
                            return (Directory)this.constructor.newInstance(con, moduleId);
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    Constructor<Directory> daoConstructor = managerClass.getConstructor(Connection.class);
                    daoFactory = new DaoFactory(this, daoConstructor){

                        @Override
                        public Directory<K> newInstance(Connection con, int moduleId) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
                            return (Directory)this.constructor.newInstance(con);
                        }
                    };
                }
                this.daoFactory = daoFactory;
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        }
    }

    public DirectoryItemModifiedEvent<?> newModifiedEvent(int moduleId, int userId, K oldItem, K newItem) throws BGException {
        try {
            return this.eventFactory.newInstance(moduleId, userId, oldItem, newItem);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public Directory<K> newDao(Connection con, int moduleId) throws BGException {
        try {
            return this.daoFactory.newInstance(con, moduleId);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.clearCache(e.getModuleId());
    }

    private ModuleInfo getModuleInfo(Integer moduleId) {
        ModuleInfo newResult;
        ModuleInfo result = (ModuleInfo)this.moduleMap.get(moduleId);
        if (result == null && (result = this.moduleMap.putIfAbsent(moduleId, newResult = new ModuleInfo(this))) == null) {
            result = newResult;
        }
        return result;
    }

    public void clearCache(int moduleId) {
        ModuleInfo result = (ModuleInfo)this.moduleMap.get(moduleId);
        if (result != null) {
            logger.info("Clearing directory cache for " + String.valueOf(this.clazz) + ", moduleId: " + moduleId);
            result.version.incrementAndGet();
            result.cache = null;
        }
    }

    public CachedDirectory<K> getCache(Integer moduleId) {
        CachedDirectory cache;
        ModuleInfo moduleInfo = this.getModuleInfo(moduleId);
        CachedDirectory cachedDirectory = cache = moduleInfo.cache != null ? moduleInfo.cache.get() : null;
        if (cache == null) {
            cache = new CachedDirectory(moduleInfo.version);
            moduleInfo.cache = new SoftReference(cache);
        }
        return cache;
    }

    AtomicLong getVersion(Integer moduleId) {
        ModuleInfo moduleInfo = this.getModuleInfo(moduleId);
        return moduleInfo.version;
    }

    public long getCacheVersion(int moduleId) {
        ModuleInfo moduleInfo = this.getModuleInfo(moduleId);
        return moduleInfo.version.get();
    }

    abstract class EventFactory {
        protected final Constructor<? extends DirectoryItemModifiedEvent<?>> constructor;

        public EventFactory(ServerDirectoryInfo this$0, Constructor<? extends DirectoryItemModifiedEvent<?>> constructor) {
            this.constructor = constructor;
        }

        public abstract DirectoryItemModifiedEvent<?> newInstance(int var1, int var2, K var3, K var4) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException;
    }

    abstract class DaoFactory {
        protected final Constructor<? extends Directory<K>> constructor;

        public DaoFactory(ServerDirectoryInfo this$0, Constructor<? extends Directory<K>> constructor) {
            this.constructor = constructor;
        }

        public abstract Directory<K> newInstance(Connection var1, int var2) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException;
    }

    class ModuleInfo {
        final AtomicLong version = new AtomicLong(RANDOM.nextInt(100000));
        volatile SoftReference<? extends CachedDirectory<K>> cache;

        public ModuleInfo(ServerDirectoryInfo this$0) {
        }
    }
}

