/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.client.list.BGUList;

public class DirectoryEditor
extends BGTabPanel {
    public static final String TAB_ID = "objectDirectoryEditor";
    private CardLayout cardLayout = new CardLayout();
    private JPanel directoryPanel = new JPanel(this.cardLayout);
    private BGUList<BGUListItem> directoryList = new BGUList();

    public DirectoryEditor() {
        super(TAB_ID, "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        this.module = "contract.object";
        this.jbInit();
        ArrayList<BGUListItem> directoryListItems = new ArrayList<BGUListItem>();
        int i = 0;
        while (true) {
            String prefix = "directory." + i + ".";
            try {
                String title = ClientUtils.getValueFromResourceBundle((String)this.rb_name, (String)prefix.concat("title"));
                String className = ClientUtils.getValueFromResourceBundle((String)this.rb_name, (String)prefix.concat("class"));
                Object directoryClass = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.directoryPanel.add(String.valueOf(i), (Component)directoryClass);
                if (directoryClass instanceof BGPanel) {
                    panel = (BGPanel)directoryClass;
                    panel.init(this.module, this.getModuleId());
                    if (i == 0) {
                        panel.trySetData();
                    }
                } else if (directoryClass instanceof BGUPanel) {
                    panel = (BGUPanel)directoryClass;
                    if (i == 0) {
                        panel.performAction("refresh");
                    }
                }
                directoryListItems.add(new BGUListItem(i, title));
            }
            catch (Exception ex) {
                break;
            }
            ++i;
        }
        this.directoryList.setData(directoryListItems);
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder((Border)new BGTitleBorder(" \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 "));
        jPanel.add((Component)new JScrollPane((Component)this.directoryList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.directoryList.addListSelectionListener(e -> this.listValueChanged(e));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)jPanel, (Component)this.directoryPanel, 300L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        Component panel = null;
        for (int i = 0; i < this.directoryPanel.getComponentCount(); ++i) {
            panel = this.directoryPanel.getComponent(i);
            if (!panel.isVisible()) continue;
            if (panel instanceof BGPanel) {
                ((BGPanel)panel).actionPerformed(e);
                break;
            }
            if (!(panel instanceof BGUPanel)) continue;
            String actionCommand = e.getActionCommand();
            if ("newItem".equals(actionCommand)) {
                ((BGUPanel)panel).performAction("new");
                break;
            }
            if ("editItem".equals(actionCommand)) {
                ((BGUPanel)panel).performAction("edit");
                break;
            }
            if ("deleteItem".equals(actionCommand)) {
                ((BGUPanel)panel).performAction("delete");
                break;
            }
            if (!"refresh".equals(actionCommand)) break;
            ((BGUPanel)panel).performAction("refresh");
            break;
        }
    }

    private void listValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting() || this.directoryList.isSelectionEmpty()) {
            return;
        }
        this.directoryList.optSelectedValue().ifPresent(item -> {
            Component component = this.directoryPanel.getComponent(item.getId());
            if (component instanceof BGPanel) {
                BGPanel panel = (BGPanel)component;
                panel.trySetData();
            } else if (component instanceof BGUPanel) {
                BGUPanel panel = (BGUPanel)component;
                panel.performAction("refresh");
            }
            this.cardLayout.show(this.directoryPanel, String.valueOf(item.getId()));
        });
    }
}

