/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class BGHtmlPane
extends JEditorPane {
    private HTMLEditorKit kit = new HTMLEditorKit();
    private HTMLDocument document;

    public BGHtmlPane() {
        this.applyKit();
    }

    private void applyKit() {
        this.setEditorKit(this.kit);
        this.document = (HTMLDocument)this.getDocument();
    }

    public void setStyleSheet(String resourceName, String encoding) throws UnsupportedEncodingException, IOException {
        URL su = BGHtmlPane.class.getResource(resourceName);
        if (su != null) {
            StyleSheet styleSheet = new StyleSheet();
            InputStreamReader r = new InputStreamReader(su.openStream(), encoding);
            styleSheet.loadRules(r, null);
            r.close();
            this.kit.setStyleSheet(styleSheet);
            this.applyKit();
        }
    }

    public void putHhml(String text) throws IOException {
        try {
            this.kit.read(new StringReader(text), (Document)this.document, this.document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clear() throws IOException {
        this.setText("");
        this.putHhml("<div/>");
    }

    public String getElementInnerHtml(String elementId) {
        String ret = null;
        try {
            ret = this.getElementInnerText(this.document.getElement(elementId));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private String getElementInnerText(Element element) throws Exception {
        Object ret = "";
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element el = element.getElement(i);
            if (el.isLeaf()) {
                if (el.getName().equals("content")) {
                    ret = (String)ret + this.document.getText(el.getStartOffset(), el.getEndOffset() - el.getStartOffset());
                    continue;
                }
                ret = (String)ret + "\n";
                continue;
            }
            ret = (String)ret + this.getElementInnerText(el);
        }
        return ret;
    }
}

