/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public class TaskDistrubuter<T extends Callable<Object>, C extends ServerContext>
extends BGLogger {
    private final ExecutorService executorServiceForTasks;
    int count = 0;

    public TaskDistrubuter(int threadCount, Setup setup, ThreadContextFactory<C> threadContextFactory, String threadName) {
        this.executorServiceForTasks = WorkerTask.newBlockingFixedThreadPool(threadName, null, threadContextFactory, threadCount, threadCount);
    }

    public Future<Object> putNextTask(T task) throws InterruptedException {
        Future<Object> result = this.executorServiceForTasks.submit(task);
        ++this.count;
        this.getLogger().trace("new task sumbmited. Task count = {}", (Object)this.count);
        return result;
    }

    public void awaitTermination() throws InterruptedException {
        this.executorServiceForTasks.awaitTermination(40L, TimeUnit.MINUTES);
    }

    public void finish() throws InterruptedException {
        this.executorServiceForTasks.shutdown();
        this.executorServiceForTasks.awaitTermination(40L, TimeUnit.MINUTES);
    }

    public void interrupt() throws InterruptedException {
        this.executorServiceForTasks.shutdownNow();
        this.executorServiceForTasks.awaitTermination(40L, TimeUnit.MINUTES);
    }
}

