/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common.protocol.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class BarcodeUrlConnectionZxing
extends URLConnection {
    private InputStream inputStream;

    public BarcodeUrlConnectionZxing(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        BitMatrix matrix;
        block32: {
            String path = this.url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            Object code = path;
            int width = -1;
            int height = -1;
            matrix = null;
            try {
                HashMap<EncodeHintType, Object> hints;
                int pos = ((String)code).indexOf(47);
                if (pos == -1) {
                    throw new IOException("barcode: no barcode type in path \"" + path + "\"");
                }
                String codeType = ((String)code).substring(0, pos);
                code = ((String)code).substring(pos + 1);
                String _sizes = null;
                pos = ((String)code).indexOf(47);
                if (pos != -1) {
                    _sizes = ((String)code).substring(0, pos);
                    code = ((String)code).substring(pos + 1);
                } else {
                    _sizes = code;
                    code = "";
                }
                try {
                    String[] _wh = _sizes.split("x");
                    width = Integer.valueOf(_wh[0]);
                    height = Integer.valueOf(_wh[1]);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException ignore) {
                    throw new IOException("barcode: no barcode size in path \"" + path + "\"");
                }
                if (((String)code).isEmpty()) {
                    if (this.url.getQuery() != null) {
                        code = this.url.getQuery();
                    } else if (this.url.getRef() != null) {
                        code = this.url.getRef();
                    }
                }
                code = BarcodeUrlConnectionZxing.urldecode((String)code);
                code = ((String)code).replace("<SOH>", "\u0001");
                if (codeType.equalsIgnoreCase("128a") || codeType.equalsIgnoreCase("128")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap<EncodeHintType, Object>();
                    hints.put(EncodeHintType.MARGIN, 5);
                    matrix = new Code128Writer().encode((String)code, BarcodeFormat.CODE_128, width, height, hints);
                    break block32;
                }
                if (codeType.equalsIgnoreCase("EAN-13") || codeType.equalsIgnoreCase("EAN13")) {
                    code = (String)code + String.valueOf(BarcodeUrlConnectionZxing.calcChecksumEAN13((String)code));
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    matrix = new EAN13Writer().encode((String)code, BarcodeFormat.EAN_13, width, height, hints);
                    break block32;
                }
                if (codeType.equalsIgnoreCase("EAN-8") || codeType.equalsIgnoreCase("EAN8")) {
                    code = (String)code + String.valueOf(BarcodeUrlConnectionZxing.calcChecksumEAN8((String)code));
                    if (width == -1) {
                        width = 100;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    matrix = new EAN8Writer().encode((String)code, BarcodeFormat.EAN_8, width, height, hints);
                    break block32;
                }
                if (codeType.equalsIgnoreCase("PDF417")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    hints.put(EncodeHintType.PDF417_COMPACT, false);
                    hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                    matrix = new PDF417Writer().encode((String)code, BarcodeFormat.PDF_417, width, height, hints);
                    break block32;
                }
                if (codeType.equalsIgnoreCase("QR") || codeType.equalsIgnoreCase("QRcode") || codeType.equalsIgnoreCase("QR-code")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 150;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                    hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                    matrix = new QRCodeWriter().encode((String)code, BarcodeFormat.QR_CODE, width, height, hints);
                    break block32;
                }
                if (codeType.equalsIgnoreCase("2of5i") || codeType.equalsIgnoreCase("2of5") || codeType.equalsIgnoreCase("ITF")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    matrix = new ITFWriter().encode((String)code, BarcodeFormat.ITF, width, height, hints);
                    break block32;
                }
                throw new IOException("barcode: unknown type \"" + codeType + "\" in path \"" + path + "\"");
            }
            catch (Exception e) {
                e.printStackTrace();
                matrix = this.generateErrorMatrix();
            }
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(20000);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)bos);
            this.inputStream = new ByteArrayInputStream(bos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BitMatrix generateErrorMatrix() {
        int WIDTH = 50;
        BitMatrix output = new BitMatrix(WIDTH, WIDTH);
        output.setRegion(0, 0, WIDTH, 1);
        output.setRegion(0, WIDTH - 1, WIDTH, 1);
        output.setRegion(0, 0, 1, WIDTH);
        output.setRegion(WIDTH - 1, 0, 1, WIDTH);
        for (int i = 0; i < WIDTH; ++i) {
            output.set(i, i);
            output.set(i, WIDTH - 1 - i);
        }
        return output;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.connect();
        }
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return "image/png";
    }

    private static int calcChecksumEAN13(String first12digits) {
        char[] data = first12digits.toCharArray();
        if (data.length != 12) {
            throw new IllegalArgumentException("FIXME");
        }
        return BarcodeUrlConnectionZxing.calcChecksumUPC(data);
    }

    private static int calcChecksumEAN8(String first7digits) {
        char[] data = first7digits.toCharArray();
        if (data.length != 7) {
            throw new IllegalArgumentException("FIXME");
        }
        return BarcodeUrlConnectionZxing.calcChecksumUPC(data);
    }

    private static int calcChecksumUPC(char[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= '0' && data[i] <= '9') continue;
            throw new IllegalArgumentException("FIXME");
        }
        int sum = 0;
        for (int i = data.length - 1; i >= 0; --i) {
            int digit = data[i] - 48;
            sum += (data.length - i) % 2 == 1 ? digit * 3 : digit;
        }
        int mod = sum % 10;
        return mod == 0 ? 0 : 10 - mod;
    }

    public static String urldecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }
}

