/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.bean;

import bitel.billing.server.call.bean.LoginManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public abstract class ReportUtils {
    protected Connection con;
    protected int mid;
    protected Preferences moduleSetup;
    protected LoginManager loginManager;
    protected int unit = 1;
    protected int unit_scale = 0;

    public static ReportUtils getReportUtils(String module, Connection con, int mid, ModuleSetup moduleSetup) {
        ReportUtils result = null;
        Class clazz = null;
        try {
            if (clazz != null) {
                result = (ReportUtils)clazz.getConstructors()[0].newInstance(new Object[]{con, mid, moduleSetup});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setUnit(int unit) {
        this.unit = unit;
        if (unit != 1) {
            this.unit_scale = 2;
        }
    }

    public ReportUtils(Connection con, int mid, Preferences moduleSetup) {
        this.con = con;
        this.mid = mid;
        this.moduleSetup = moduleSetup;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public PreparedStatement selectSomethingFromSessions(int lid, Period period, String whatSelect, String filter, String group, String order, String limits) {
        PreparedStatement ps = null;
        String tableName = this.getSessionTableName(period.getDateFromCalendar().get(1), period.getDateFromCalendar().get(2) + 1);
        if (whatSelect != null) {
            try {
                if (ServerUtils.tableExists(this.con, tableName)) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ");
                    query.append(whatSelect);
                    query.append(" FROM ");
                    query.append(tableName);
                    query.append(" WHERE lid=? AND DAYOFMONTH( session_start )>=? ");
                    query.append(" AND DAYOFMONTH( session_start )<=? ");
                    if (filter != null) {
                        query.append(filter);
                    }
                    if (group != null) {
                        query.append(group);
                    }
                    if (order != null) {
                        query.append(order);
                    }
                    if (limits != null) {
                        query.append(limits);
                    }
                    ps = this.con.prepareStatement(query.toString());
                    ps.setInt(1, lid);
                    ps.setInt(2, period.getDateFromCalendar().get(5));
                    ps.setInt(3, period.getDateToCalendar().get(5));
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return ps;
    }

    @Deprecated
    public ResultSet selectSomthFromSessions(int lid, Period period, String whatSelect, String filter, String group, String order, String limits) {
        PreparedStatement ps = this.selectSomethingFromSessions(lid, period, whatSelect, filter, group, order, limits);
        ResultSet rs = null;
        if (ps != null) {
            try {
                rs = ps.executeQuery();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rs;
    }

    public PreparedStatement selectSomethingFromSessions(List<Integer> lids, Period period, String whatSelect, String filter, String group, String order, String limits) {
        PreparedStatement ps = null;
        String tableName = this.getSessionTableName(period.getDateFromCalendar().get(1), period.getDateFromCalendar().get(2) + 1);
        if (whatSelect != null && lids.size() > 0) {
            try {
                if (ServerUtils.tableExists(this.con, tableName)) {
                    StringBuilder query = new StringBuilder();
                    query.append("SELECT ");
                    query.append(whatSelect);
                    query.append(" FROM ");
                    query.append(tableName);
                    query.append(" WHERE lid IN (");
                    query.append(Utils.toString(lids));
                    query.append(") AND DAYOFMONTH( session_start )>=? ");
                    query.append(" AND DAYOFMONTH( session_start )<=? ");
                    if (filter != null) {
                        query.append(filter);
                    }
                    if (group != null) {
                        query.append(group);
                    }
                    if (order != null) {
                        query.append(order);
                    }
                    if (limits != null) {
                        query.append(limits);
                    }
                    ps = this.con.prepareStatement(query.toString());
                    ps.setInt(1, period.getDateFromCalendar().get(5));
                    ps.setInt(2, period.getDateToCalendar().get(5));
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return ps;
    }

    @Deprecated
    public ResultSet selectSomthFromSessions(List<Integer> lids, Period period, String whatSelect, String filter, String group, String order, String limits) {
        PreparedStatement ps = this.selectSomethingFromSessions(lids, period, whatSelect, filter, group, order, limits);
        ResultSet rs = null;
        if (ps != null) {
            try {
                rs = ps.executeQuery();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rs;
    }

    protected String getSessionTableName(int year, int month) {
        StringBuffer sb = new StringBuffer("log_session_");
        sb.append(this.mid + "_");
        sb.append(year);
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        return sb.toString();
    }

    public List<Object> getSessionsColSumTimeTinTout(int lid, Period period, String filter) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(0);
        result.add(Float.valueOf(0.0f));
        result.add(0);
        result.add(0L);
        result.add(0L);
        String whatSelect = " COUNT(id), SUM(session_cost), SUM(session_time), SUM(input_octets), SUM(output_octets)";
        PreparedStatement ps = this.selectSomethingFromSessions(lid, period, whatSelect, filter, null, null, null);
        if (ps != null) {
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result.set(0, rs.getInt(1));
                result.set(1, Float.valueOf(rs.getFloat(2)));
                result.add(2, rs.getInt(3));
                result.add(3, rs.getLong(4));
                result.add(4, rs.getLong(5));
            }
            rs.close();
            ps.close();
        }
        return result;
    }

    public List<Object> getSessionsColSumTimeTinTout(List<Integer> lids, Period period, String filter) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(0);
        result.add(Float.valueOf(0.0f));
        result.add(0);
        result.add(new BigDecimal(0));
        result.add(new BigDecimal(0));
        Object whatSelect = null;
        boolean roundBeforeSumm = this.moduleSetup.getBoolean("report.round.before.sum", true);
        whatSelect = roundBeforeSumm ? " id, session_cost, session_time, ROUND(input_octets/" + this.unit + "," + this.unit_scale + "), ROUND(output_octets/" + this.unit + "," + this.unit_scale + ")" : " id, session_cost, session_time, input_octets, output_octets";
        PreparedStatement ps = this.selectSomethingFromSessions(lids, period, (String)whatSelect, filter, null, null, null);
        if (ps != null) {
            ResultSet rs = ps.executeQuery();
            int countId = 0;
            float costSum = 0.0f;
            int timeSum = 0;
            BigDecimal input = BigDecimal.ZERO;
            BigDecimal output = BigDecimal.ZERO;
            while (rs.next()) {
                ++countId;
                costSum += rs.getFloat(2);
                timeSum += rs.getInt(3);
                BigDecimal amount = rs.getBigDecimal(4);
                input = input.add(amount != null ? amount : BigDecimal.ZERO);
                amount = rs.getBigDecimal(5);
                output = output.add(amount != null ? amount : BigDecimal.ZERO);
            }
            rs.close();
            ps.close();
            result.set(0, countId);
            result.set(1, Float.valueOf(costSum));
            result.add(2, timeSum);
            if (!roundBeforeSumm) {
                BigDecimal divisor = new BigDecimal(this.unit);
                input = input.divide(divisor, this.unit_scale, RoundingMode.HALF_UP);
                output = output.divide(divisor, this.unit_scale, RoundingMode.HALF_UP);
            }
            result.add(3, input);
            result.add(4, output);
        }
        return result;
    }

    public void addSessions(Element sessions, List<Integer> lids, Period period, boolean break_on_pages, Page page, String columns, String filter) {
        if (lids.size() > 0) {
            PreparedStatement ps;
            StringBuilder limit = new StringBuilder();
            if (break_on_pages) {
                limit.append(Page.toSqlLimit((Page)page));
            }
            if ((ps = this.selectSomethingFromSessions(lids, period, columns, filter, null, " ORDER BY session_start ", limit.toString())) != null) {
                try {
                    this.addSessions(ps.executeQuery(), sessions);
                    ps.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public abstract void addLoginsAmounts(Period var1, int var2, Element var3, String var4, String var5) throws SQLException;

    public abstract int addSums(Element var1, List<Integer> var2, Period var3, String var4) throws SQLException;

    public void addSessions(ResultSet rs, Element data) {
    }

    public abstract void addLoginsAmounts(Period var1, int var2, Map<String, Object> var3, String var4, String var5) throws SQLException;
}

