/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.job.server;

import java.util.Calendar;
import java.util.List;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

class JobCalendar {
    private static final int FIRST_YEAR = 2000;
    private long year;
    private long month;
    private long dayOfMonth;
    private long dayOfWeek;
    private long hour;
    private long minute;
    private long second;
    private static final long FULL = -1L;

    JobCalendar() {
    }

    private boolean containsYear(int year) {
        return this.year == 0L || (this.year & 1L << year - 2000) != 0L;
    }

    private Calendar nextYear(Calendar calendar) {
        if (this.year == 0L) {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.add(1, 1);
            return calendar;
        }
        int year = calendar.get(1);
        for (int i = year - 2000 + 1; i < 80; ++i) {
            if ((this.year & 1L << i) == 0L) continue;
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, 2000 + i);
            return calendar;
        }
        return null;
    }

    private boolean containsMonth(int month) {
        return (this.month & 1L << month) != 0L;
    }

    private Calendar nextMonth(Calendar calendar) {
        int month = calendar.get(2);
        for (int i = month + 1; i < 12; ++i) {
            if ((this.month & 1L << i) == 0L) continue;
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
            calendar.set(5, 1);
            calendar.set(2, i);
            return calendar;
        }
        return null;
    }

    private boolean containsDay(int dayOfMonth, int dayOfWeek) {
        return (this.dayOfMonth & 1L << dayOfMonth) != 0L || (this.dayOfWeek & 1L << dayOfWeek) != 0L;
    }

    private Calendar nextDay(Calendar calendar) {
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        int day = calendar.get(5);
        int maxDay = calendar.getActualMaximum(5);
        for (int i = day + 1; i <= maxDay; ++i) {
            calendar.add(5, 1);
            int dayOfWeek = calendar.get(7);
            if ((this.dayOfWeek & 1L << dayOfWeek) != 0L) {
                return calendar;
            }
            if ((this.dayOfMonth & 1L << i) == 0L) continue;
            return calendar;
        }
        return null;
    }

    private boolean containsHour(int hour) {
        return (this.hour & 1L << hour) != 0L;
    }

    private Calendar nextHour(Calendar calendar) {
        int hour = calendar.get(11);
        int maxHour = calendar.getActualMaximum(11);
        for (int i = hour + 1; i <= maxHour; ++i) {
            if ((this.hour & 1L << i) == 0L) continue;
            TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
            calendar.set(11, i);
            return calendar;
        }
        return null;
    }

    private boolean containsMinute(int minute) {
        return (this.minute & 1L << minute) != 0L;
    }

    private Calendar nextMinute(Calendar calendar) {
        int minute = calendar.get(12);
        int maxMinute = calendar.getActualMaximum(12);
        for (int i = minute + 1; i <= maxMinute; ++i) {
            if ((this.minute & 1L << i) == 0L) continue;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, i);
            return calendar;
        }
        return null;
    }

    private boolean containsSecond(int second) {
        return (this.second & 1L << second) != 0L;
    }

    private Calendar nextSecond(Calendar calendar) {
        int second = calendar.get(13);
        int maxSecond = calendar.getActualMaximum(13);
        for (int i = second + 1; i <= maxSecond; ++i) {
            if ((this.second & 1L << i) == 0L) continue;
            calendar.set(14, 0);
            calendar.set(13, i);
            return calendar;
        }
        return null;
    }

    public Calendar next(Calendar calendar) {
        calendar.set(14, 0);
        calendar.add(13, 1);
        while (true) {
            if (!this.containsYear(calendar.get(1)) && this.nextYear(calendar) == null) {
                return null;
            }
            if (!this.containsMonth(calendar.get(2)) && this.nextMonth(calendar) == null) {
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.set(2, 0);
                calendar.add(1, 1);
            }
            if (!this.containsDay(calendar.get(5), calendar.get(7)) && this.nextDay(calendar) == null) {
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.add(2, 1);
            }
            if (!this.containsHour(calendar.get(11)) && this.nextHour(calendar) == null) {
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.add(5, 1);
            }
            if (!this.containsMinute(calendar.get(12)) && this.nextMinute(calendar) == null) {
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.add(11, 1);
                continue;
            }
            if (this.containsSecond(calendar.get(13)) || this.nextSecond(calendar) != null) break;
            calendar.set(13, 0);
            calendar.add(12, 1);
        }
        return calendar;
    }

    public void setYear(String year) {
        if ("*".equals(year.trim())) {
            this.year = -1L;
            return;
        }
        List result = Utils.toIntegerList((String)year);
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            result.set(i, (Integer)result.get(i) - 2000);
        }
        this.year = Utils.enumToMask((String)Utils.toString((Iterable)result));
    }

    public void setMonth(String month) {
        if ("*".equals(month.trim())) {
            this.month = -1L;
            return;
        }
        this.month = Utils.enumToMask((String)month);
    }

    public void setDayOfMonth(String dayOfMonth) {
        if ("*".equals(dayOfMonth.trim())) {
            this.dayOfMonth = -1L;
            return;
        }
        this.dayOfMonth = Utils.enumToMask((String)dayOfMonth);
    }

    public void setDayOfWeek(String dayOfWeek) {
        if ("*".equals(dayOfWeek.trim())) {
            this.dayOfWeek = -1L;
            return;
        }
        this.dayOfWeek = Utils.enumToMask((String)dayOfWeek);
    }

    public void setHour(String hour) {
        if ("*".equals(hour.trim())) {
            this.hour = -1L;
            return;
        }
        this.hour = Utils.enumToMask((String)hour);
    }

    public void setMinute(String minute) {
        if ("*".equals(minute.trim())) {
            this.minute = -1L;
            return;
        }
        this.minute = Utils.enumToMask((String)minute);
    }

    public void setSecond(String second) {
        if ("*".equals(second.trim())) {
            this.second = -1L;
            return;
        }
        this.second = Utils.enumToMask((String)second);
    }
}

