/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.XMLDatabaseElementSerializer;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.worker.Recyclable;

public class ServerUtils {
    private static final Logger logger = LogManager.getLogger();
    private static DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(){
        {
            this.setGroupingSeparator(' ');
        }
    };
    private static long tablesLastCheck = 0L;
    private static Map<String, Long> tables = new ConcurrentHashMap<String, Long>(64);
    private static Set<String> existColumns = Collections.newSetFromMap(new ConcurrentHashMap(32));
    private static Map<String, ParameterMap> _tableCreateOptions = new HashMap<String, ParameterMap>();

    public static boolean tableExists(Connection con, String table) {
        boolean result;
        block25: {
            if (Utils.isBlankString((String)table)) {
                return false;
            }
            String tableName = table.trim();
            result = false;
            long period = 3600000L;
            try {
                Map<String, Long> workTables = tables;
                Long time = workTables.get(tableName);
                if (time != null) {
                    result = true;
                    time = System.currentTimeMillis();
                    break block25;
                }
                if (con != null && tableName != null) {
                    String query = switch (Setup.getSetup().dbType()) {
                        case DefaultServerSetup.DatabaseType.POSTGRE -> "SELECT tablename FROM pg_tables WHERE schemaname='" + Setup.getSetup().dbSchema() + "'";
                        default -> "SHOW TABLES";
                    };
                    try (PreparedStatement ps = con.prepareStatement(query);
                         ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            if (!rs.getString(1).equals(tableName)) continue;
                            result = true;
                            break;
                        }
                    }
                }
                if (result) {
                    long now = System.currentTimeMillis();
                    ConcurrentHashMap<String, Long> newTables = new ConcurrentHashMap<String, Long>(workTables.size() + 1);
                    if (now - tablesLastCheck > 3600000L) {
                        for (Map.Entry<String, Long> entry : workTables.entrySet()) {
                            if (now - entry.getValue() >= 3600000L) continue;
                            newTables.put(entry.getKey(), entry.getValue());
                        }
                        tablesLastCheck = now;
                    } else {
                        newTables.putAll(workTables);
                    }
                    newTables.put(tableName, System.currentTimeMillis());
                    tables = newTables;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean columnExist(Connection con, String table, String column) {
        boolean result = false;
        String key = ServerUtils.getKey(table, column);
        result = existColumns.contains(key);
        if (!result) {
            String query = "SHOW COLUMNS FROM " + table;
            try (PreparedStatement ps = con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (!rs.getString(1).equals(column)) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
            if (result) {
                existColumns.add(key);
            }
        }
        return result;
    }

    private static String getKey(String table, String column) {
        return table + "." + column;
    }

    public static void dropExistColumn(Connection con, String table, String column) throws SQLException {
        try (Statement st = con.createStatement();){
            st.executeUpdate("ALTER TABLE " + table + " DROP COLUMN  " + column);
            existColumns.remove(ServerUtils.getKey(table, column));
        }
    }

    public static List<String> addItemsFromRS(Connection con, Element whereAdd, String table, String keyColumn, String keyValue, String retColumn, boolean dateFilter, String date1, String date2) throws SQLException, XMLStreamException {
        XMLDatabaseElementSerializer serilizer2 = new XMLDatabaseElementSerializer(whereAdd);
        return serilizer2.addItemsFromRS(con, table, keyColumn, keyValue, retColumn, dateFilter, date1, date2, "");
    }

    public static List<String> addItemsFromRS(Connection con, Element whereAdd, String table, String keyColumn, String keyValue, String retColumn, boolean dateFilter, String date1, String date2, String joins) throws SQLException, XMLStreamException {
        XMLDatabaseElementSerializer serilizer2 = new XMLDatabaseElementSerializer(whereAdd);
        return serilizer2.addItemsFromRS(con, table, keyColumn, keyValue, retColumn, dateFilter, date1, date2, joins);
    }

    public static List<String> addItemsFromRS(Connection con, XMLStreamWriter whereAdd, String table, String keyColumn, String keyValue, String retColumn, boolean dateFilter, String date1, String date2) throws SQLException, XMLStreamException {
        return ServerUtils.addItemsFromRS(con, whereAdd, table, keyColumn, keyValue, retColumn, dateFilter, date1, date2, "");
    }

    public static List<String> addItemsFromRS(Connection con, XMLStreamWriter whereAdd, String table, String keyColumn, String keyValue, String retColumn, boolean dateFilter, String date1, String date2, String joins) throws SQLException, XMLStreamException {
        XMLDatabaseSerializer serilizer = new XMLDatabaseSerializer(whereAdd);
        return serilizer.addItemsFromRS(con, table, keyColumn, keyValue, retColumn, dateFilter, date1, date2, joins);
    }

    public static List<String> deleteRowsFromTable(Connection con, String table, String keyColumn, String keyValue, String retColumn) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        if (ServerUtils.tableExists(con, table)) {
            String query = "SELECT * FROM " + table + " WHERE " + keyColumn + "='" + keyValue + "'";
            try (Statement st = con.createStatement();
                 ResultSet rs = st.executeQuery(query);){
                ResultSetMetaData md = rs.getMetaData();
                int columns = md.getColumnCount();
                while (rs.next()) {
                    for (int i = 1; i <= columns; ++i) {
                        String name = md.getColumnName(i);
                        if (retColumn == null || !name.equals(retColumn)) continue;
                        result.add(rs.getString(i));
                    }
                }
            }
            query = "DELETE FROM " + table + " WHERE " + keyColumn + "='" + keyValue + "'";
            st = con.createStatement();
            try {
                st.executeUpdate(query);
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        return result;
    }

    public static String getModuleMonthTableName(String name, LocalDate time, int moduleId) {
        return ServerUtils.getModuleMonthTableName(name, TimeUtils.convertLocalDateToDate((LocalDate)time), moduleId);
    }

    public static String getModuleMonthTableName(String name, Date time, int moduleId) {
        return name + '_' + moduleId + Optional.ofNullable(time).map(a -> new SimpleDateFormat("_yyyyMM").format((Date)a)).orElse("");
    }

    public static String getModuleMonthDayTableName(String name, Date time, int moduleId) {
        return name + '_' + moduleId + Optional.ofNullable(time).map(a -> new SimpleDateFormat("_yyyyMMdd").format(time)).orElse("");
    }

    public static String getModuleTableName(String name, int moduleId) {
        return name + "_" + moduleId;
    }

    public static String getMonthTableName(String name, Date time) {
        return name + TimeUtils.format((Date)time, (String)"_yyyyMM");
    }

    public static void prepareElementToSerialize(Node el) {
        StringBuilder buf = new StringBuilder(100);
        int size = 0;
        NamedNodeMap map = el.getAttributes();
        if (map != null) {
            size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = map.item(i);
                String nodeValue = node.getNodeValue();
                node.setNodeValue(ServerUtils.prepareString(buf, nodeValue));
            }
        }
        if (el.getNodeValue() != null) {
            el.setNodeValue(ServerUtils.prepareString(buf, el.getNodeValue()));
        }
        NodeList childs = el.getChildNodes();
        size = childs.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = childs.item(i);
            ServerUtils.prepareElementToSerialize(child);
        }
    }

    private static String prepareString(StringBuilder buf, String nodeValue) {
        buf.setLength(0);
        for (int j = 0; j < nodeValue.length(); ++j) {
            char ch = nodeValue.charAt(j);
            char ich = ch;
            if (ich == '\t' || ich == '\n' || ich == '\r' || ich >= ' ' && ich <= '\ud7ff' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                buf.append(ch);
                continue;
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        return buf.toString();
    }

    public static synchronized void checkTable(Connection con, String tableName, String createQuery) throws SQLException {
        if (!ServerUtils.tableExists(con, tableName)) {
            try (Statement stmt = con.createStatement();){
                stmt.executeUpdate(createQuery);
            }
        }
    }

    public static final String uptimeStatus(Date startTime) {
        long delta = (System.currentTimeMillis() - startTime.getTime()) / 1000L;
        int days = (int)(delta / 86400L);
        int hours = (int)((delta -= (long)(days * 86400)) / 3600L);
        int min = (int)((delta -= (long)(hours * 3600)) / 60L);
        int sec = (int)(delta -= (long)(min * 60));
        DecimalFormat dfTime = new DecimalFormat("00");
        return new StringBuilder(100).append("Started: ").append(TimeUtils.format((Date)startTime, (String)"dd.MM.yyyy HH:mm:ss")).append("\t").append("Uptime: ").append(days).append(" d ").append(dfTime.format(hours)).append(":").append(dfTime.format(min)).append(":").append(dfTime.format(sec)).toString();
    }

    public static String getSetupValue(Connection con, String name) {
        return ServerUtils.getSetupValue(con, name, null);
    }

    public static String getSetupValue(Connection con, String name, String defaultValue) {
        String value = defaultValue;
        if (name != null) {
            String query = "SELECT value FROM setup WHERE id=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, name);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        value = rs.getString(1);
                    }
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
        return value;
    }

    public static void setSetupValue(Connection con, String name, String value) {
        if (Utils.notBlankString((String)name) && Utils.notBlankString((String)value)) {
            try (PreparedStatement ps = con.prepareStatement("REPLACE INTO setup SET id=?, value=?");){
                ps.setString(1, name);
                ps.setString(2, value);
                ps.executeUpdate();
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
    }

    public static void removeSetupValue(Connection con, String name) {
        if (name != null) {
            String query = "DELETE FROM setup WHERE id=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, name);
                ps.executeUpdate();
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
    }

    public static Calendar getLastModificationTime(Connection con, String param) {
        return TimeUtils.parseCalendar((String)ServerUtils.getSetupValue(con, "lmt_" + param), (String)"dd.MM.yyyy HH:mm:ss");
    }

    public static int lastInsertId(Connection con) throws SQLException {
        int id = -1;
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT last_insert_id() AS id");){
            while (rs.next()) {
                id = rs.getInt(1);
            }
        }
        return id;
    }

    public static int lastInsertId(PreparedStatement ps) throws SQLException {
        int id = -1;
        try (ResultSet rs = ps.getGeneratedKeys();){
            if (rs.last()) {
                id = rs.getInt(1);
            }
        }
        return id;
    }

    public static long lastInsertLongId(PreparedStatement ps) throws SQLException {
        try (ResultSet rs = ps.getGeneratedKeys();){
            long l = rs.last() ? rs.getLong(1) : -1L;
            return l;
        }
    }

    public static int foundRows(Connection con) throws SQLException {
        int result = 0;
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT FOUND_ROWS()");){
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        return result;
    }

    public static void changeLastModificationTime(Connection con, String param) {
        String value = TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss");
        ServerUtils.setSetupValue(con, "lmt_" + param, value);
    }

    public static final void closeConnection(Connection ... con) {
        for (Connection c : con) {
            try {
                if (c.isClosed()) continue;
                c.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final void closeConnection(Connection con) {
        ServerUtils.closeConnection(con, null);
    }

    public static final void closeConnection(Connection con, Connection conSlave) {
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (conSlave != null && conSlave != con) {
            try {
                if (!conSlave.isClosed()) {
                    conSlave.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final void commitConnection(Connection con) {
        if (con != null) {
            try {
                if (!con.getAutoCommit()) {
                    con.commit();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static List<List<Integer>> getRanges(int gid, String range) {
        String[] parts = range.split(";");
        ArrayList<List<Integer>> rangeList = new ArrayList<List<Integer>>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            int pos = part.indexOf("-");
            if (pos >= 0) {
                if (pos == 0 || pos == part.length() - 1) continue;
                String rs1 = part.substring(0, pos);
                String rs2 = part.substring(pos + 1);
                int r1 = Utils.parseInt((String)rs1, (int)-1);
                int r2 = Utils.parseInt((String)rs2, (int)-1);
                if (r1 < 1 || r2 < 1 || r2 < r1) continue;
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(r1);
                list.add(r2);
                rangeList.add(list);
                continue;
            }
            int v = Utils.parseInt((String)part, (int)-1);
            if (v < 1) continue;
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(v);
            list.add(v);
            rangeList.add(list);
        }
        Collections.sort(rangeList, new Comparator<List<Integer>>(){

            @Override
            public int compare(List<Integer> list1, List<Integer> list2) {
                int v1 = list1.get(0);
                int v2 = list2.get(0);
                return v1 - v2;
            }
        });
        return rangeList;
    }

    public static Map<String, byte[]> getEntriesFromZip(ZipInputStream zis, String mask) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZipEntry ze = null;
        try {
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (mask != null && name.indexOf(mask) < 0) continue;
                byte[] data = Utils.readByBlock((InputStream)zis);
                result.put(name, data);
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void resultSetToXML(ResultSet rs, Element whereAdd, String table) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        while (rs.next()) {
            Element item = XMLUtils.createElement((Element)whereAdd, (String)table);
            for (int i = 1; i <= columns; ++i) {
                Element columnElement;
                String name = md.getColumnLabel(i);
                String val = rs.getString(i);
                try {
                    item.setAttribute(name, val == null ? "" : val);
                }
                catch (DOMException columnElement2) {
                    columnElement = XMLUtils.createElement((Element)item, (String)"column");
                    columnElement.setAttribute("name", name == null ? "" : name);
                    columnElement.setAttribute("value", val == null ? "" : val);
                    continue;
                    catch (Throwable throwable) {
                        Element columnElement3 = XMLUtils.createElement((Element)item, (String)"column");
                        columnElement3.setAttribute("name", name == null ? "" : name);
                        columnElement3.setAttribute("value", val == null ? "" : val);
                        throw throwable;
                    }
                }
                columnElement = XMLUtils.createElement((Element)item, (String)"column");
                columnElement.setAttribute("name", name == null ? "" : name);
                columnElement.setAttribute("value", val == null ? "" : val);
                continue;
            }
        }
    }

    public static Map<String, byte[]> getFileEntriesFromZipByPrefix(ZipInputStream zis, String prefix) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZipEntry ze = null;
        try {
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (name.endsWith("/") || !name.startsWith(prefix)) continue;
                byte[] data = Utils.readByBlock((InputStream)zis);
                result.put(name, data);
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return result;
    }

    public static PrintWriter getSocketOut(Socket socket) throws Exception {
        return new PrintWriter(socket.getOutputStream(), true);
    }

    public static BufferedReader getSocketIn(Socket socket) throws Exception {
        return new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    public static final void dropExistTable(Connection con, String tableName) throws SQLException {
        try (Statement st = con.createStatement();){
            st.executeUpdate("DROP TABLE IF EXISTS " + tableName);
        }
        tables.remove(tableName);
    }

    public static final void setAutoCommit(Connection con, boolean auto) {
        try {
            con.setAutoCommit(auto);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void resultSetToXML(ResultSet rs, XMLStreamWriter whereAdd, String table) throws SQLException, XMLStreamException {
        ResultSetMetaData md = rs.getMetaData();
        int columns = md.getColumnCount();
        while (rs.next()) {
            whereAdd.writeStartElement(table);
            for (int i = 1; i <= columns; ++i) {
                String name = md.getColumnLabel(i);
                String val = rs.getString(i);
                whereAdd.writeAttribute(name, val == null ? "" : val);
            }
            whereAdd.writeEndElement();
        }
    }

    public static String replace(String value, String from, String to) {
        return value.replace(from, to);
    }

    public static String urlencode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static String urldecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    public static String valueOrDefault(String value, String defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public static String formatNumber(Number value, String formatPattern) {
        return new DecimalFormat(formatPattern, decimalFormatSymbols).format(value);
    }

    public static String upd5(String doc1, String doc2, String date1, String date2) {
        Object result = null;
        if (doc1 != null && !doc1.isEmpty()) {
            result = doc1;
        } else if (doc2 != null && !doc2.isEmpty()) {
            result = doc2;
        }
        if (result != null) {
            result = (String)result + " \u043e\u0442 ";
            if (date1 != null && !date1.isEmpty()) {
                result = (String)result + date1;
            } else if (date2 != null && !date2.isEmpty()) {
                result = (String)result + date2;
            }
        }
        return result == null ? "-" : "\u2116 " + (String)result;
    }

    public static String dateToString(String source, String inPattern, String outPattern) {
        String result = "";
        SimpleDateFormat dateFormatIn = new SimpleDateFormat(inPattern);
        SimpleDateFormat dateFormatOut = new SimpleDateFormat(outPattern);
        Date date = null;
        try {
            date = dateFormatIn.parse(source);
            result = dateFormatOut.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void recycle(Object ... oo) {
        try {
            if (oo == null) {
                return;
            }
            for (Object o : oo) {
                if (o == null) continue;
                if (o instanceof Statement) {
                    Statement stmt = (Statement)o;
                    if (stmt.isClosed()) continue;
                    stmt.close();
                    continue;
                }
                if (o instanceof Recyclable) {
                    ((Recyclable)o).recycle();
                    continue;
                }
                if (o instanceof AutoCloseable) {
                    ((AutoCloseable)o).close();
                    continue;
                }
                logger.warn("Unknown type for recycle: " + String.valueOf(o.getClass()));
            }
        }
        catch (Exception ex) {
            logger.error("error recycle resources", (Throwable)ex);
        }
    }

    public static void addNoCache(HttpServletResponse response) {
        response.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
        response.setHeader("Last-Modified", "Thu, 01 Jan 1970 00:00:01 GMT");
        response.setHeader("Expires", "Thu, 01 Jan 1970 00:00:01 GMT");
    }

    public static void deleteDir(File dirPath) {
        if (dirPath != null && dirPath.isDirectory()) {
            for (String listItem : dirPath.list()) {
                ServerUtils.deleteDir(new File(dirPath, listItem));
            }
            dirPath.delete();
        } else {
            dirPath.delete();
        }
    }

    public static String getQuestions(int count) {
        StringBuffer result = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append("?");
        }
        return result.toString();
    }

    public static void createDirectoriesOnFTP(FTPClient ftpConnect, String pathOnFTP) throws IOException {
        String[] directories;
        ftpConnect.changeWorkingDirectory("/");
        for (String dir : directories = pathOnFTP.split("/")) {
            boolean dirExists;
            if (dir.isEmpty() || (dirExists = ftpConnect.changeWorkingDirectory(dir))) continue;
            ftpConnect.makeDirectory(dir);
            ftpConnect.changeWorkingDirectory(dir);
        }
    }

    public static void checkPeriod(Date date1, Date date2) throws BGException {
        boolean result;
        boolean bl = result = date1 == null || date2 == null || TimeUtils.dateBeforeOrEq((Date)date1, (Date)date2);
        if (!result) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
        }
    }

    public static String getServerHome() {
        String catalinaHome = new File("data").getAbsolutePath().replace('\\', '/');
        catalinaHome = catalinaHome.substring(0, catalinaHome.lastIndexOf(47));
        return catalinaHome;
    }

    private static Map<String, ParameterMap> getTableCreateOptions() {
        if (_tableCreateOptions == null) {
            _tableCreateOptions = Setup.getSetup().subKeyed("table.create.");
        }
        return _tableCreateOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndCreatePeriodicTableName(Connection con, String tableName, String createQuery) {
        Class<ServerUtils> clazz = ServerUtils.class;
        synchronized (ServerUtils.class) {
            try {
                ServerUtils.createPeriodicTable(con, tableName, createQuery);
            }
            catch (Exception e) {
                logger.error("error check and create periodic table name", (Throwable)e);
            }
            return;
        }
    }

    private static void createPeriodicTable(Connection con, String tableName, String createQuery) throws IOException, SQLException {
        try {
            if (!ServerUtils.tableExists(con, tableName)) {
                Object queryFull = createQuery;
                for (Map.Entry<String, ParameterMap> me : ServerUtils.getTableCreateOptions().entrySet()) {
                    String prefix = me.getKey();
                    ParameterMap options = me.getValue();
                    if (!tableName.startsWith(prefix)) continue;
                    String engine = options.get("engine");
                    String dataDirectory = options.get("data.directory");
                    String indexDirectory = options.get("index.directory");
                    if (Utils.notBlankString((String)dataDirectory)) {
                        queryFull = (String)queryFull + " DATA DIRECTORY = '" + dataDirectory + "'";
                    }
                    if (Utils.notBlankString((String)indexDirectory)) {
                        queryFull = (String)queryFull + " INDEX DIRECTORY = '" + indexDirectory + "'";
                    }
                    if (!Utils.notBlankString((String)engine)) break;
                    queryFull = (String)queryFull + " ENGINE = '" + engine + "'";
                    break;
                }
                Statement st = con.createStatement();
                st.executeUpdate((String)queryFull);
                st.close();
            }
        }
        catch (SQLException ex) {
            BGLogger.error(ex);
            String key = "server.check.table";
            AlarmSender.sendAlarm("server.check.table", 0L, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443", "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443 " + tableName + " \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438.\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0441\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0431\u0435\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f engine, data.directory \u0438 index.directory.", ex);
            logger.info("trying to create table whithout settings..");
            if (!ServerUtils.tableExists(con, tableName)) {
                Statement st = con.createStatement();
                st.executeUpdate(createQuery);
                st.close();
            }
            logger.info("ok");
        }
    }
}

