/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.security.PEMCertificate;

public class KeyStoreUtils {
    private static final Logger log = LogManager.getLogger();

    public static File getKeyStoreFile() {
        File oldKeystore = new File("data" + File.separatorChar + ".keystore");
        if (oldKeystore.exists()) {
            return oldKeystore;
        }
        return new File("data" + File.separatorChar + "keystore.p12");
    }

    public static boolean checkTrustStoreNotEmpty(String password) {
        char[] passw = password.toCharArray();
        try {
            KeyStore store = KeyStore.getInstance("PKCS12");
            store.load(new FileInputStream(KeyStoreUtils.getKeyStoreFile()), passw);
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isCertificateEntry(alias)) continue;
                return true;
            }
        }
        catch (FileNotFoundException store) {
        }
        catch (Exception e) {
            log.info("error with keystore", (Throwable)e);
        }
        return false;
    }

    public static PrivateKey getPrivateKey(Setup setup, String alias) {
        char[] passw;
        PrivateKey result;
        block13: {
            result = null;
            passw = setup.get("keystore.password", "bgbilling").toCharArray();
            try {
                KeyStore store = KeyStore.getInstance("PKCS12");
                store.load(new FileInputStream(KeyStoreUtils.getKeyStoreFile()), passw);
                if (alias != null) {
                    Key key = null;
                    try {
                        key = store.getKey(alias, passw);
                    }
                    catch (UnrecoverableKeyException e) {
                        key = store.getKey(alias, new char[0]);
                    }
                    if (key instanceof PrivateKey) {
                        log.debug("get private key with alias {}", (Object)alias);
                        result = (PrivateKey)key;
                    }
                    break block13;
                }
                Enumeration<String> aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                    try {
                        Key key = null;
                        try {
                            key = store.getKey(alias, passw);
                        }
                        catch (UnrecoverableKeyException e) {
                            key = store.getKey(alias, new char[0]);
                        }
                        if (!(key instanceof PrivateKey)) continue;
                        log.debug("get random private key with alias {}", (Object)alias);
                        result = (PrivateKey)key;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (FileNotFoundException e) {
                log.error("keystore error - not found " + String.valueOf(KeyStoreUtils.getKeyStoreFile()));
            }
            catch (UnrecoverableKeyException e) {
                log.error("keystore error - error get private key (alias " + alias + "), password?");
            }
            catch (Exception e) {
                log.error("keystore error (alias " + alias + ", keystore " + String.valueOf(KeyStoreUtils.getKeyStoreFile()) + ")", (Throwable)e);
            }
        }
        Arrays.fill(passw, '\u0000');
        return result;
    }

    public static SSLContext createSSLContext(File privateKey, String privateKeyPassword, X509Certificate[] chain, File ... hostCrts) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, new char[0]);
        keyStore.setKeyEntry("key", PEMCertificate.getPemPrivateKey((File)privateKey), privateKeyPassword.toCharArray(), chain);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, new char[0]);
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, new char[0]);
        int index = 0;
        for (File fileHostCrt : hostCrts) {
            trustStore.setCertificateEntry("host" + ++index, PEMCertificate.getPemCertificate((File)fileHostCrt));
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        tmf.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return sslContext;
    }
}

