/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLink;
import ru.bitel.bgbilling.kernel.script.common.service.GlobalScriptService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class GlobalScriptPanel
extends BGUPanel {
    private GlobalScriptLinkTableModel model = new GlobalScriptLinkTableModel(GlobalScriptPanel.class.getName());
    private GlobalScriptEditor scriptEditor = new GlobalScriptEditor();

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        BGEditor editor = new BGEditor();
        editor.addForm((JComponent)BGSwingUtilites.wrapBorder((JPanel)((Object)this.scriptEditor), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        editor.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.model.setData(((GlobalScriptService)((ClientContext)this.getContext()).getPort(GlobalScriptService.class)).getGlobalScriptLinkList());
            this.scriptEditor.performAction("refresh");
        });
    }

    private class GlobalScriptLinkTableModel
    extends BGTableModel<GlobalScriptLink> {
        public GlobalScriptLinkTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441", -1, -1, -1, "className", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    private class GlobalScriptEditor
    extends BGUPanel {
        private static final String EXECUTE = "execute";
        private GlobalScriptLink current;
        private BGTextField titleField = new BGTextField(50);
        private DynamicClassChooser chooser = new DynamicClassChooser(false, 1);
        private JButton execute = new JButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441");
        private JTextArea logArea = new JTextArea();
        private JScrollPane logAreaPane = new JScrollPane(this.logArea);

        private GlobalScriptEditor() {
        }

        protected void jbInit() {
            this.setLayout(new GridLayout(1, 2));
            this.add(this.getLeftPanel());
            this.add(this.getClassPanel());
            this.execute.addActionListener(e -> this.performAction(EXECUTE));
        }

        private JPanel getLeftPanel() {
            this.logArea.setEditable(false);
            this.logAreaPane.setPreferredSize(new Dimension(100, 200));
            this.logAreaPane.setMinimumSize(new Dimension(100, 200));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            panel.add((Component)this.execute, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 15, 5), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.logAreaPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getClassPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043b\u0430\u0441\u0441: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)((Object)this.chooser), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
                this.chooser.setIfaceName(((GlobalScriptService)((ClientContext)this.getContext()).getPort(GlobalScriptService.class)).getInterfaceName());
                this.chooser.setSuperclassName(((GlobalScriptService)((ClientContext)this.getContext()).getPort(GlobalScriptService.class)).getSuperclassName());
                this.chooser.performAction("refresh");
            });
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.current = new GlobalScriptLink();
                this.titleField.setText("");
                this.chooser.setSelectedIndex(0);
                this.logArea.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (GlobalScriptLink)((Object)((Object)GlobalScriptPanel.this.model.getSelectedRow()));
                if (this.current == null) {
                    throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043f\u0442!");
                }
                this.titleField.setText(this.current.getTitle());
                this.chooser.setSelectedItem(this.current.getClassName());
                this.logArea.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (GlobalScriptLink)((Object)((Object)GlobalScriptPanel.this.model.getSelectedRow()));
                if (this.current != null) {
                    ((GlobalScriptService)((ClientContext)this.getContext()).getPort(GlobalScriptService.class)).deleteGlobalScriptLink(this.current.getId());
                    GlobalScriptPanel.this.performAction("refresh");
                }
                this.performActionClose();
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (Utils.isBlankString((String)GlobalScriptEditor.this.chooser.getSelectedClass())) {
                        throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043a\u043b\u0430\u0441\u0441!");
                    }
                    GlobalScriptEditor.this.current.setTitle(GlobalScriptEditor.this.titleField.getText());
                    GlobalScriptEditor.this.current.setClassName(GlobalScriptEditor.this.chooser.getSelectedClass());
                    ((GlobalScriptService)((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class)).updateGlobalScriptLink(GlobalScriptEditor.this.current);
                    GlobalScriptEditor.this.performActionClose();
                    GlobalScriptPanel.this.performAction("refresh");
                }
            };
            new AbstractBGUPanel.DefaultAction(EXECUTE, "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                    if (GlobalScriptEditor.this.current.getId() <= 0) {
                        throw new BGMessageException("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0435 \u0441\u043a\u0440\u0438\u043f\u0442!");
                    }
                    GlobalScriptEditor.this.logArea.setText(((GlobalScriptService)((ClientContext)GlobalScriptEditor.this.getContext()).getPort(GlobalScriptService.class)).executeGlobalScript(GlobalScriptEditor.this.current.getId()));
                }
            };
        }
    }
}

