/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.flowtools;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.ReadableDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.channels.ZLIBReadableChannel;
import ru.bitel.bgbilling.kernel.network.datalog.flowtools.FlowToolsLogReader;

public class FlowToolsLog
extends DataLog<FlowToolsLog>
implements ReadableDataLog<FlowToolsLogReader> {
    public static final short magic = ByteBuffer.wrap(new byte[]{-49, 16}).getShort();
    public static final int FT_TLV_NULL = 0;
    public static final long FT_FIELD_VENDOR = 1L;
    public static final long FT_FIELD_EX_VER = 2L;
    public static final long FT_FIELD_AGG_VER = 4L;
    public static final long FT_FIELD_AGG_METHOD = 8L;
    public static final long FT_FIELD_EXPORTER_IP = 16L;
    public static final long FT_FIELD_CAP_START = 32L;
    public static final long FT_FIELD_CAP_END = 64L;
    public static final long FT_FIELD_HEADER_FLAGS = 128L;
    public static final long FT_FIELD_ROT_SCHEDULE = 256L;
    public static final long FT_FIELD_FLOW_COUNT = 512L;
    public static final long FT_FIELD_FLOW_LOST = 1024L;
    public static final long FT_FIELD_FLOW_MISORDERED = 2048L;
    public static final long FT_FIELD_PKT_CORRUPT = 4096L;
    public static final long FT_FIELD_CAP_HOSTNAME = 16384L;
    public static final long FT_FIELD_COMMENTS = 32768L;
    public static final int FT_TLV_VENDOR = 1;
    public static final DataLog.ParameterUByte VENDOR = new DataLog.ParameterUByte(1, "vendor");
    public static final int FT_TLV_EX_VER = 2;
    public static final DataLog.ParameterUShort VERSION = new DataLog.ParameterUShort(2, "exportVersion");
    public static final int FT_TLV_AGG_VER = 3;
    public static final DataLog.ParameterUByte AGG_VER = new DataLog.ParameterUByte(3, "aggregationVersion");
    public static final int FT_TLV_AGG_METHOD = 4;
    public static final DataLog.ParameterUByte AGG_METHOD = new DataLog.ParameterUByte(4, "aggregationMethod");
    public static final int FT_TLV_EXPORTER_IP = 5;
    public static final DataLog.ParameterUInt EXPORTER_IP = new DataLog.ParameterUInt(5, "exporterIp");
    public static final int FT_TLV_HEADER_FLAGS = 8;
    public static final DataLog.ParameterUInt HEADER_FLAGS = new DataLog.ParameterUInt(8, "headerFlags");
    public static final int FT_TLV_CAP_START = 6;
    public static final DataLog.Parameter<Date> CAP_START = new DataLog.Parameter<Date>(6, "captureStartTime", Date.class);
    public static final int FT_TLV_CAP_END = 7;
    public static final DataLog.Parameter<Date> CAP_END = new DataLog.Parameter<Date>(7, "captureEndTime", Date.class);
    public static final int FT_TLV_ROT_SCHEDULE = 9;
    public static final DataLog.ParameterUInt ROT_SCHEDULE = new DataLog.ParameterUInt(9, "rotationSchedule");
    public static final int FT_TLV_FLOW_COUNT = 10;
    public static final DataLog.ParameterUInt FLOW_COUNT = new DataLog.ParameterUInt(10, "flowCount");
    public static final int FT_TLV_FLOW_LOST = 11;
    public static final DataLog.ParameterUInt FLOW_LOST = new DataLog.ParameterUInt(11, "flowLost");
    public static final int FT_TLV_FLOW_MISORDERED = 12;
    public static final DataLog.ParameterUInt FLOW_MISORDERED = new DataLog.ParameterUInt(12, "flowMisordered");
    public static final int FT_TLV_PKT_CORRUPT = 13;
    public static final DataLog.ParameterUInt PKT_CORRUPT = new DataLog.ParameterUInt(13, "corruptPackets");
    public static final int FT_TLV_SEQ_RESET = 14;
    public static final DataLog.ParameterUInt SEQ_RESET = new DataLog.ParameterUInt(14, "seqReset");
    public static final int FT_TLV_CAP_HOSTNAME = 15;
    public static final DataLog.Parameter<String> CAP_HOSTNAME = new DataLog.Parameter<String>(15, "hostname", String.class);
    public static final int FT_TLV_COMMENTS = 16;
    public static final DataLog.Parameter<String> COMMENTS = new DataLog.Parameter<String>(16, "comments", String.class);
    protected int version;
    protected boolean compressed;
    protected byte order;
    protected int recordSize;

    public FlowToolsLog(File file, RandomAccessFile raf, FileChannel channel) {
        super(file, raf, channel);
    }

    @Override
    protected void asReaderImpl() throws IOException {
        this.readHeader();
        try {
            switch (this.version) {
                case 5: {
                    this.recordSize = 64;
                    break;
                }
                case 6: {
                    this.recordSize = 72;
                    break;
                }
                case 7: {
                    this.recordSize = 68;
                    break;
                }
                default: {
                    throw new IOException("Netflow version 5,6,7 expected, found: " + this.version);
                }
            }
            long flags = this.getParameter(HEADER_FLAGS);
            this.compressed = (flags & 2L) != 0L;
            this.readBufferSize = 524288;
            this.readBufferSize -= this.readBufferSize % this.recordSize;
            if (this.compressed) {
                ByteBuffer rawBuffer = ByteBuffer.allocate(this.readBufferSize);
                this.readableByteChannel = new ZLIBReadableChannel.ZLIBReadableChannelSync(this.fileChannel, rawBuffer);
            } else {
                this.readableByteChannel = this.fileChannel;
            }
            this.fileChannelPosition = this.fileChannel.position();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void readHeader() throws IOException {
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[4]);
        this.fileChannel.read(readBuffer);
        readBuffer.flip();
        if (magic != readBuffer.getShort()) {
            throw new IOException("Bad magic");
        }
        this.order = readBuffer.get();
        byte streamFormatVersion = readBuffer.get();
        switch (streamFormatVersion) {
            case 1: {
                this.headerByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 4L, 354L);
                if (this.order == 1) {
                    this.headerByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                this.readHeaderV1(this.headerByteBuffer);
                break;
            }
            case 3: {
                if (this.order == 1) {
                    readBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                readBuffer.clear();
                this.fileChannel.read(readBuffer);
                readBuffer.flip();
                int length = readBuffer.getInt() - 8;
                this.headerByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 8L, length);
                if (this.order == 1) {
                    this.headerByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                this.readHeaderTLV(this.headerByteBuffer);
                this.fileChannel.position(this.fileChannel.position() + (long)length);
                break;
            }
            default: {
                throw new IOException("Invalid flow stream format version (should be 1 or 3): " + streamFormatVersion);
            }
        }
    }

    protected void readHeaderV1(ByteBuffer bb) throws IOException {
        this.version = bb.getShort() & 0xFFFF;
        this.setParameter(VERSION, this.version);
        this.setParameter(CAP_START, new Date(((long)bb.getInt() & 0xFFFFFFFFL) * 1000L));
        this.setParameter(CAP_END, new Date(((long)bb.getInt() & 0xFFFFFFFFL) * 1000L));
        this.setParameter(HEADER_FLAGS, (long)bb.getInt() & 0xFFFFFFFFL);
        this.setParameter(ROT_SCHEDULE, (long)bb.getInt() & 0xFFFFFFFFL);
        this.setParameter(FLOW_COUNT, (long)bb.getInt() & 0xFFFFFFFFL);
        this.setParameter(FLOW_LOST, (long)bb.getInt() & 0xFFFFFFFFL);
        this.setParameter(FLOW_MISORDERED, (long)bb.getInt() & 0xFFFFFFFFL);
        Charset charset = Charset.forName("UTF-8");
        int limit = bb.limit();
        bb.limit(bb.position() + 68);
        String hostname = charset.decode(bb).toString();
        this.setParameter(CAP_HOSTNAME, hostname);
        bb.limit(limit);
        String comments = charset.decode(bb).toString();
        this.setParameter(COMMENTS, comments);
    }

    protected void readHeaderTLV(ByteBuffer readBuffer) throws IOException {
        while (readBuffer.remaining() > 4) {
            int type = readBuffer.getShort() & 0xFFFF;
            int length = readBuffer.getShort() & 0xFFFF;
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setParameter(VENDOR, this.readParameter(readBuffer, VENDOR, null, length));
                    break;
                }
                case 2: {
                    this.version = this.readParameter(readBuffer, VERSION, null, length);
                    this.setParameter(VERSION, this.version);
                    break;
                }
                case 4: {
                    readBuffer.get();
                    break;
                }
                case 5: {
                    this.setParameter(EXPORTER_IP, this.readParameter(readBuffer, EXPORTER_IP, null, length));
                    break;
                }
                case 6: {
                    this.setParameter(CAP_START, new Date(((long)readBuffer.getInt() & 0xFFFFFFFFL) * 1000L));
                    break;
                }
                case 7: {
                    this.setParameter(CAP_END, new Date(((long)readBuffer.getInt() & 0xFFFFFFFFL) * 1000L));
                    break;
                }
                case 8: {
                    this.setParameter(HEADER_FLAGS, this.readParameter(readBuffer, HEADER_FLAGS, null, length));
                    break;
                }
                case 9: {
                    this.setParameter(ROT_SCHEDULE, this.readParameter(readBuffer, ROT_SCHEDULE, null, length));
                    break;
                }
                case 10: {
                    this.setParameter(FLOW_COUNT, this.readParameter(readBuffer, FLOW_COUNT, null, length));
                    break;
                }
                case 11: {
                    this.setParameter(FLOW_LOST, this.readParameter(readBuffer, FLOW_LOST, null, length));
                    break;
                }
                case 12: {
                    this.setParameter(FLOW_MISORDERED, this.readParameter(readBuffer, FLOW_MISORDERED, null, length));
                    break;
                }
                case 13: {
                    this.setParameter(PKT_CORRUPT, this.readParameter(readBuffer, PKT_CORRUPT, null, length));
                    break;
                }
                case 14: {
                    this.setParameter(SEQ_RESET, this.readParameter(readBuffer, SEQ_RESET, null, length));
                    break;
                }
                case 15: {
                    Charset charset = Charset.forName("UTF-8");
                    readBuffer.limit(readBuffer.position() + length - 1);
                    String hostname = charset.decode(readBuffer).toString();
                    readBuffer.limit(readBuffer.capacity());
                    this.setParameter(CAP_HOSTNAME, hostname);
                    break;
                }
                case 16: {
                    Charset charset = Charset.forName("UTF-8");
                    readBuffer.limit(readBuffer.position() + length - 1);
                    String comments = charset.decode(readBuffer).toString();
                    readBuffer.limit(readBuffer.capacity());
                    this.setParameter(COMMENTS, comments);
                }
            }
        }
    }

    @Override
    public FlowToolsLogReader newReader(Map<String, Object> params) {
        if (!this.inited) {
            throw new IllegalStateException();
        }
        ByteBuffer buffer = this.compressed ? ByteBuffer.allocate(this.readBufferSize) : ByteBuffer.allocateDirect(this.readBufferSize);
        if (this.order == 1) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        return this.initReader(new FlowToolsLogReader(this, buffer));
    }
}

