/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class ContractLabelManager
extends AbstractIdDao<ContractLabelItem> {
    protected static final String TABLE_CONTRACT_LABEL = "contract_label";
    protected static final String TABLE_CONTRACT_LABEL_LINK = "contract_label_link";

    public ContractLabelManager(Connection con) {
        super(con, TABLE_CONTRACT_LABEL);
    }

    public List<ContractLabelItem> getContractLabelItemList(boolean calcCount) throws BGException {
        ArrayList<ContractLabelItem> result = new ArrayList<ContractLabelItem>();
        try {
            block24: {
                HashMap<Integer, ContractLabelItem> map = new HashMap<Integer, ContractLabelItem>();
                ContractLabelItem groups = this.getRootLabelItem(1, "\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ContractLabelType.GROUP);
                ContractLabelItem labels = this.getRootLabelItem(100, "\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ContractLabelType.LABEL);
                result.add(groups);
                result.add(labels);
                try (Statement st = this.con.createStatement();){
                    String query = "SELECT * FROM contract_label ORDER BY title";
                    try (ResultSet rs = st.executeQuery(query);){
                        while (rs.next()) {
                            groups = this.getFromRS(rs);
                            map.put(groups.getId(), groups);
                            result.add(groups);
                        }
                    }
                    if (!calcCount) break block24;
                    query = "SELECT label_id, count(*) FROM contract_label_link GROUP BY label_id";
                    rs = st.executeQuery(query);
                    try {
                        while (rs.next()) {
                            groups = (ContractLabelItem)map.get(rs.getInt(1));
                            if (groups == null) continue;
                            groups.setContractLinkCount(rs.getInt(2));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            }
            List<ContractLabelItem> onlyLabels = result.stream().filter(label -> label.getContractLabelType().equals((Object)ContractLabelType.LABEL_ITEM)).collect(Collectors.toList());
            if (!this.checkSorting(onlyLabels)) {
                this.toCorrectSortingValues(onlyLabels);
            }
            Collections.sort(result);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private boolean checkSorting(List<ContractLabelItem> labels) {
        return labels.stream().filter(item -> item.getSortPosition() == 0).count() == 1L;
    }

    private void toCorrectSortingValues(List<ContractLabelItem> labels) throws SQLException {
        String query = "UPDATE contract_label SET sort_position=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (int x = 0; x < labels.size(); ++x) {
                ps.setInt(1, x);
                ps.setInt(2, labels.get(x).getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public List<Integer> getContractLabelIds(int contractId) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String query = "SELECT label_id FROM contract_label_link WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt(1));
                }
            }
        }
        return result;
    }

    public void setContractLabelIds(int contractId, List<Integer> ids) throws SQLException {
        HashSet<Integer> labelIds = new HashSet<Integer>(ids);
        String query = "DELETE FROM contract_label_link WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
        query = "INSERT INTO contract_label_link SET contract_id=?, label_id=?";
        ps = this.con.prepareStatement(query);
        try {
            ps.setInt(1, contractId);
            for (Integer id : labelIds) {
                ps.setInt(2, id);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        ArrayList groupIds = new ArrayList();
        labelIds.forEach(i -> {
            if (i < 66) {
                groupIds.add(i - 2);
            }
        });
        long groups = Utils.enumToMask((String)Utils.toString(groupIds, (String)","));
        query = "UPDATE contract SET gr=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, groups);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
    }

    public void updateContractLabelTreeItem(ContractLabelItem contractLabelItem) throws SQLException {
        this.updateImpl(contractLabelItem);
    }

    private int getNextSortPosition() throws SQLException {
        int sortPosition = 0;
        String query = "SELECT if ( isnull( max(sort_position) ), 1, max(sort_position) + 1 ) FROM contract_label";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                sortPosition = rs.getInt(1);
            }
        }
        return sortPosition;
    }

    public void removeContractLabelItem(int contractLabelItemId) throws SQLException {
        int index;
        String query = "DELETE FROM contract_label_link WHERE label_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            ps.setInt(index++, contractLabelItemId);
            ps.executeUpdate();
        }
        query = "DELETE FROM contract_label WHERE id=?";
        ps = this.con.prepareStatement(query);
        try {
            index = 1;
            ps.setInt(index++, contractLabelItemId);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public ContractLabelItem getTree() throws SQLException {
        ContractLabelItem root = this.getRootLabelItem(1, "\u0413\u0440\u0443\u043f\u043f\u044b \u0438 \u043c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ContractLabelType.GROUP);
        ContractLabelItem labels = this.getRootLabelItem(100, "\u041c\u0435\u0442\u043a\u0438", ContractLabelType.LABEL);
        ArrayList<ContractLabelItem> contractLabelItems = new ArrayList<ContractLabelItem>();
        String query = "SELECT * FROM contract_label";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                contractLabelItems.add(this.getFromRS(rs));
            }
        }
        for (ContractLabelItem item : contractLabelItems) {
            if (item.getParentId() == root.getId()) {
                root.addChild(item);
                this.addChild(item.getId(), item, contractLabelItems);
                continue;
            }
            if (item.getParentId() != labels.getId()) continue;
            labels.addChild(item);
            this.addChild(item.getId(), item, contractLabelItems);
        }
        root.addChild(labels);
        return root;
    }

    public void syncLabelAndGroupDirectory() throws SQLException {
        String query = "DELETE FROM contract_label WHERE id < 66";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
        query = "INSERT INTO contract_label ( id, parent_id, type, title, comment, forbidden ) SELECT id+2, 1, 1, title, comment, if (editable, 0, 1) FROM contract_group WHERE enable=1";
        st = this.con.createStatement();
        try {
            st.executeUpdate(query);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public void syncLabelAndGroupContract(int contractId) throws BGException {
        block38: {
            boolean all = contractId < 1;
            String query = "DELETE FROM contract_label_link WHERE label_id < 66" + (all ? "" : " AND contract_id=?");
            try {
                try (PreparedStatement psDelete = this.con.prepareStatement(query);){
                    if (!all) {
                        psDelete.setInt(1, contractId);
                    }
                    psDelete.executeUpdate();
                }
                try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO contract_label_link ( contract_id, label_id ) SELECT id, ? FROM contract WHERE gr&(1<<?)>0");
                     PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO contract_label_link SET contract_id=?, label_id=?");
                     PreparedStatement psSelect = this.con.prepareStatement("SELECT id, gr FROM contract WHERE gr > 0 AND id=?");){
                    if (all) {
                        for (int i = 0; i < 64; ++i) {
                            ps.setInt(1, i + 2);
                            ps.setInt(2, i);
                            ps.executeUpdate();
                        }
                        break block38;
                    }
                    psSelect.setInt(1, contractId);
                    try (ResultSet rs = psSelect.executeQuery();){
                        while (rs.next()) {
                            psInsert.setInt(1, rs.getInt(1));
                            for (int pos = 0; pos < 64; ++pos) {
                                if ((rs.getLong(2) & 1L << pos) <= 0L) continue;
                                psInsert.setInt(2, pos + 2);
                                psInsert.executeUpdate();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected void addChild(int up, ContractLabelItem rootItem, List<ContractLabelItem> list) {
        for (ContractLabelItem listItem : list) {
            if (up != listItem.getParentId()) continue;
            rootItem.addChild(listItem);
            this.addChild(listItem.getId(), listItem, list);
        }
    }

    private ContractLabelItem getRootLabelItem(int id, String title, ContractLabelType type) {
        return ContractLabelItem.builder().setId(id).setTitle(title).setContractLabelType(type).setSelected(false).setParentId(0).setSortPosition(type.equals((Object)ContractLabelType.GROUP) ? 1 : 2).build();
    }

    public Map<Integer, List<Integer>> getContractListWithLabels() throws SQLException {
        HashMap<Integer, List<Integer>> contractLabels = new HashMap<Integer, List<Integer>>();
        String query = "SELECT c.id, label.label_id FROM contract as c LEFT JOIN contract_label_link as label ON c.id=label.contract_id WHERE label.label_id>0 ORDER BY c.id";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            int curContractId = 0;
            ArrayList<Integer> labelIds = new ArrayList<Integer>();
            while (rs.next()) {
                int contractId = rs.getInt("c.id");
                if (contractId != curContractId) {
                    curContractId = contractId;
                    labelIds = new ArrayList();
                    contractLabels.put(curContractId, labelIds);
                }
                labelIds.add(rs.getInt("label.label_id"));
            }
        }
        return contractLabels;
    }

    public int getContractCountByLabel(int labelId) throws SQLException {
        int contractCount = 0;
        String query = "select count(*) as count from contract_label_link where label_id=" + labelId;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                contractCount = rs.getInt("count");
            }
        }
        return contractCount;
    }

    protected ContractLabelItem getFromRS(ResultSet rs) throws SQLException {
        return ContractLabelItem.builder().setId(rs.getInt("id")).setParentId(rs.getInt("parent_id")).setTitle(rs.getString("title")).setContractLabelType(ContractLabelType.getType(rs.getInt("type"))).setSortPosition(rs.getInt("sort_position")).setComment(rs.getString("comment")).setForbiddenEdit(rs.getInt("forbidden") == 1).build();
    }

    protected void updateImpl(ContractLabelItem contractLabelItem) throws SQLException {
        Objects.requireNonNull(contractLabelItem);
        String maxIdQuery = "SELECT MAX(id) AS maxId FROM contract_label";
        int maxIdInTable = 0;
        try (Statement maxSt = this.con.createStatement();
             ResultSet maxRs = maxSt.executeQuery(maxIdQuery);){
            if (maxRs.next()) {
                maxIdInTable = maxRs.getInt("maxId");
            }
        }
        boolean update = contractLabelItem.getId() > 0;
        boolean addAfterGroups = contractLabelItem.getId() <= 0 && maxIdInTable < 100;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "contract_label SET parent_id=?, title=?, type=?, sort_position=?, comment=?, forbidden=?" + (update ? " WHERE id=?" : (addAfterGroups ? ", id=101" : ""));
        if (!update) {
            contractLabelItem.setSortPosition(this.getNextSortPosition());
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, contractLabelItem.getParentId());
            ps.setString(index++, contractLabelItem.getTitle());
            ps.setInt(index++, contractLabelItem.getContractLabelType().ordinal());
            ps.setInt(index++, contractLabelItem.getSortPosition());
            ps.setString(index++, contractLabelItem.getComment());
            ps.setInt(index++, contractLabelItem.isForbiddenEdit() ? 1 : 0);
            this.executeUpdate((Id)contractLabelItem, index, ps);
        }
    }
}

