/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ChargeDao
extends AbstractIdDao<Charge> {
    public ChargeDao(Connection con) {
        super(con, "contract_charge");
        this.fields = new HashMap();
        this.fields.put("date", "dt");
    }

    public SearchResult<Charge> getChargeList(int contractId, int chargeTypeId, Period period, int members) throws SQLException {
        return this.getList(contractId, chargeTypeId, period, members, false);
    }

    public SearchResult<Charge> getPaybackList(int contractId, int paybackTypeId, Period period, int members) throws SQLException {
        return this.getList(contractId, paybackTypeId, period, members, true);
    }

    private SearchResult<Charge> getList(int contractId, int type, Period period, int members, Boolean isPayback) throws SQLException {
        SearchResult searchResult = new SearchResult();
        List result = searchResult.getList();
        Date dateFrom = null;
        Date dateTo = null;
        if (period != null) {
            dateFrom = period.getDateFrom();
            dateTo = period.getDateTo();
        }
        try (PreparedStatement ps = this.getPS(contractId, dateFrom, dateTo, type, members, isPayback, true);){
            if (ps == null) {
                searchResult.setSum(BigDecimal.ZERO);
                SearchResult searchResult2 = searchResult;
                return searchResult2;
            }
            BigDecimal totalSum = BigDecimal.ZERO;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    totalSum = totalSum.add(rs.getBigDecimal("summa"));
                    result.add(this.getFromRS(rs));
                }
                searchResult.setSum(totalSum);
            }
        }
        return searchResult;
    }

    public SearchResult<Charge> getChargeList(List<Integer> contractIds, Period period) throws SQLException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPeriod(period);
        this.searchChargeList((SearchResult<Charge>)searchResult, contractIds);
        return searchResult;
    }

    public void searchChargeList(SearchResult<Charge> searchResult, List<Integer> contractIds) throws SQLException {
        String[] stringArray;
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        Period period = searchResult.getPeriod();
        if (searchResult.getSort() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "date";
        } else {
            stringArray = searchResult.getSort();
        }
        String[] sort = stringArray;
        List result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE cid IN (" + Utils.toString(contractIds) + ")").append(this.queryPeriod(period, "dt")).append(this.getSQLOrder(sort, this.fields));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            this.psSetPeriod(ps, 1, period);
            try (ResultSet rs = ps.executeQuery();){
                BigDecimal sumL = BigDecimal.ZERO;
                while (rs.next()) {
                    sumL = sumL.add(rs.getBigDecimal("summa"));
                    result.add(this.getFromRS(rs));
                }
                searchResult.setSum(sumL);
            }
        }
    }

    public void searchLastChargeList(SearchResult<Charge> searchResult, List<Integer> contractIds, int lastCharges) throws SQLException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        List result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT id, cid, comment, dt, pt, summa, uid, lm, payback FROM " + this.tableName + " WHERE cid IN (" + Utils.toString(contractIds) + ") ORDER BY dt DESC");
        if (lastCharges > 0) {
            query.append(" LIMIT ").append(lastCharges);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
    }

    public int deleteCharges(int contractId) throws SQLException {
        return this.delete("cid=?", new Object[]{contractId});
    }

    public BigDecimal getSum(int contractId, Date dateFrom, Date dateTo, int typeId, int members, Boolean isPayback) throws SQLException {
        BigDecimal result = BigDecimal.ZERO;
        try (PreparedStatement ps = this.getPS(contractId, dateFrom, dateTo, typeId, members, isPayback, false);){
            if (ps == null) {
                BigDecimal bigDecimal = result;
                return bigDecimal;
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getBigDecimal("sum");
                }
            }
        }
        return result;
    }

    private PreparedStatement getPS(int contractId, Date dateFrom, Date dateTo, int typeId, int members, Boolean isPayback, boolean isList) throws SQLException {
        String cids = ContractUtils.getCidsStringForQuery(contractId, members, this.con);
        if (cids == null) {
            return null;
        }
        StringBuilder query = new StringBuilder("SELECT " + (isList ? "*" : "if ( SUM(summa) IS NOT NULL, SUM(summa), 0 ) as sum") + " FROM " + this.tableName + " c WHERE c.cid IN(" + cids + ")");
        if (typeId > 0) {
            query.append(" AND c.pt=?");
        }
        if (dateFrom != null) {
            query.append(" AND c.dt >= ?");
        }
        if (dateTo != null) {
            query.append(" AND c.dt <= ?");
        }
        if (isPayback != null) {
            query.append(" AND payback = ?");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int index = 1;
        if (typeId > 0) {
            ps.setInt(index++, typeId);
        }
        if (dateFrom != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
        }
        if (dateTo != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateTo));
        }
        if (isPayback != null) {
            ps.setBoolean(index, isPayback);
        }
        return ps;
    }

    protected void updateImpl(Charge charge) throws SQLException {
        Objects.requireNonNull(charge);
        boolean update = charge.getId() > 0;
        String query = this.sqlCommandAndTable(update) + " SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?" + (update ? " WHERE id=?" : ", payback=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)charge.getDate()));
            ps.setInt(index++, charge.getContractId());
            ps.setInt(index++, charge.getTypeId());
            ps.setInt(index++, charge.getUserId());
            ps.setBigDecimal(index++, charge.getSum());
            ps.setString(index++, charge.getComment());
            if (!update) {
                ps.setBoolean(index, charge.isPayback());
            }
            this.executeUpdate(charge, index, ps);
        }
    }

    protected Charge getFromRS(ResultSet rs) throws SQLException {
        return Charge.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setComment(rs.getString("comment")).setDate(rs.getDate("dt")).setTypeId(rs.getInt("pt")).setSum(rs.getBigDecimal("summa")).setUserId(rs.getInt("uid")).setTimeChange(rs.getTimestamp("lm")).setPayback(rs.getBoolean("payback")).build();
    }
}

