/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.common.TimeUtils;

public class ContractTariffGroupDao
extends AbstractIdDao<ContractTariffGroup> {
    public ContractTariffGroupDao(Connection con) {
        super(con, "contract_tariff_group");
    }

    public List<ContractTariffGroup> list(int contractId, Date date) throws SQLException {
        if (date == null) {
            return super.list("cid=?", "date1", new Object[]{contractId});
        }
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
        return super.list("cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?)", "date1", new Object[]{contractId, sqlDate, sqlDate});
    }

    protected ContractTariffGroup getFromRS(ResultSet rs) throws SQLException {
        return ContractTariffGroup.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setTariffGroupId(rs.getInt("gid")).build();
    }

    protected void updateImpl(ContractTariffGroup contractTariffGroup) throws SQLException {
        Objects.requireNonNull(contractTariffGroup);
        this.deleteImpl(contractTariffGroup.getContractId());
        if (contractTariffGroup.getTariffGroupId() > 0) {
            try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET gid=?, cid=?");){
                psInsert.setInt(1, contractTariffGroup.getTariffGroupId());
                psInsert.setInt(2, contractTariffGroup.getContractId());
                psInsert.executeUpdate();
            }
        }
    }

    protected int deleteImpl(int contractId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cid=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            psDelete.setInt(1, contractId);
            int n = psDelete.executeUpdate();
            return n;
        }
    }

    protected ContractTariffGroup getImpl(int contractId) throws SQLException {
        ContractTariffGroup result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND ( date1 is null OR date1 <= curdate() ) AND ( date2 is null OR date2 >= curdate() )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }
}

