/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.common.Utils;

public class ConverterContractGroupsToLabelsByTariffOptions
extends AbstractBGConverter {
    @Override
    public void runConverter(Connection connection) {
        try {
            this.convertContractGroupsToContractLabels(connection);
            this.convertHideForWebContractGroupsToContractLabels(connection);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void convertContractGroupsToContractLabels(Connection connection) throws SQLException {
        HashMap<Integer, Long> tariffOptions = new HashMap<Integer, Long>();
        String query = "SELECT id, contract_groups FROM tariff_option WHERE contract_groups>0";
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                tariffOptions.put(rs.getInt("id"), rs.getLong("contract_groups"));
            }
        }
        if (tariffOptions.size() == 0) {
            return;
        }
        query = "UPDATE tariff_option SET contract_groups=0, contract_labels=? WHERE id=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            tariffOptions.forEach((id, contractGroups) -> {
                try {
                    List ids = Utils.toIntegerList((String)Utils.maskToEnum((long)contractGroups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ps.setString(1, Utils.toString(ids));
                    ps.setInt(2, (int)id);
                    ps.addBatch();
                }
                catch (SQLException ex) {
                    this.logError(ex);
                }
            });
            ps.executeBatch();
        }
    }

    private void convertHideForWebContractGroupsToContractLabels(Connection connection) throws SQLException {
        HashMap<Integer, Long> tariffOptions = new HashMap<Integer, Long>();
        String query = "SELECT id, hideForWebContractGroups FROM tariff_option WHERE hideForWebContractGroups>0";
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                tariffOptions.put(rs.getInt("id"), rs.getLong("hideForWebContractGroups"));
            }
        }
        if (tariffOptions.size() == 0) {
            return;
        }
        query = "UPDATE tariff_option SET hideForWebContractGroups=0, hide_for_web_contract_labels=? WHERE id=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            tariffOptions.forEach((id, contractGroups) -> {
                try {
                    List ids = Utils.toIntegerList((String)Utils.maskToEnum((long)contractGroups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ps.setString(1, Utils.toString(ids));
                    ps.setInt(2, (int)id);
                    ps.addBatch();
                }
                catch (SQLException ex) {
                    this.logError(ex);
                }
            });
            ps.executeBatch();
        }
    }
}

