/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import bitel.billing.server.ext.dhcp.DHCPPacket;
import bitel.billing.server.ext.dhcp.DHCPProcessor;
import bitel.billing.server.ext.dhcp.DHCPRelayProcessor;
import bitel.billing.server.ext.dhcp.DHCPSetup;
import java.nio.channels.DatagramChannel;
import java.util.HashMap;
import ru.bitel.common.Utils;

public class DHCPVlanRelayProcessor
extends DHCPRelayProcessor {
    @Override
    protected DHCPProcessor.DHCPIpAddress getIpAddress(DHCPRelayProcessor.DHCPGate gate, DHCPPacket request, DHCPProcessor.DHCPClientIdentifier client) {
        this.getLogger().debug("Getting ip info...");
        this.getLogger().debug("Trying to read postion = {}", (Object)this.position_82);
        byte byte1 = request.optionAgentInformation.getSubOption((byte)this.option_82).value[this.position_82];
        byte byte2 = request.optionAgentInformation.getSubOption((byte)this.option_82).value[this.position_82 + 1];
        this.getLogger().debug("Success!!");
        int vlan = Utils.unsignedByteToInt((byte)byte1) << 8 | Utils.unsignedByteToInt((byte)byte2);
        this.getLogger().debug("Vlan = {}", (Object)vlan);
        byte[] address = gate.clientIpMap.get(vlan);
        if (address != null) {
            this.getLogger().debug("Address by vlan = {}", (Object)address);
        } else {
            this.getLogger().debug("Address by vlan not found!!!");
            byte[] macb = new byte[6];
            System.arraycopy(request.chaddr, 0, macb, 0, 6);
            String macR = Utils.bytesToHexString((byte[])macb);
            this.getLogger().debug("MAC from request = {}", (Object)macR);
            Object mac = "";
            for (int i = 0; i < 6; ++i) {
                mac = (String)mac + macR.substring(i * 2, i * 2 + 2);
                if (i == 5) continue;
                mac = (String)mac + " ";
            }
            this.getLogger().debug("MAC after convert = {}", mac);
            HashMap map = (HashMap)gate.clientPortMacIpMap.get(vlan);
            if (map != null && map.get(mac) != null) {
                address = (byte[])map.get(mac);
                this.getLogger().debug("Address by MAC = {}", (Object)address);
            } else {
                this.getLogger().debug("Address by MAC was not found");
            }
        }
        return address != null ? new DHCPProcessor.DHCPIpAddress(address) : null;
    }

    public DHCPVlanRelayProcessor(DHCPSetup setup, DatagramChannel channel) {
        super(setup, channel);
    }
}

