/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.common.Utils;

@Deprecated
public class ActionGetContractDebtSums
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        boolean withSuper = this.getBooleanParameter("withsuper", true);
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);
             BalanceUtils bu = new BalanceUtils(this.con);){
            Contract contract = (Contract)contractDao.get(this.cid);
            if (contract == null) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + this.cid + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            }
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            if (withSuper) {
                this.addContract(bu, contract, data);
            }
            for (Contract subContract : contractDao.getSubContracts(this.cid, 1)) {
                this.addContract(bu, subContract, data);
            }
        }
    }

    private void addContract(BalanceUtils bu, Contract contract, Element data) throws Exception {
        Element row = this.createElement(data, "row");
        row.setAttribute("cid", String.valueOf(contract.getId()));
        row.setAttribute("title", contract.getTitle());
        row.setAttribute("comment", contract.getComment());
        boolean balanceForCredit = this.setup.getBoolean("payment.show.balance.for.credit.contract", false);
        if (contract.getBalanceMode() == 0 && !balanceForCredit) {
            row.setAttribute("debt", Utils.formatBigDecimalSumm((BigDecimal)bu.getSaldo(new Date(), contract.getId())));
        } else {
            row.setAttribute("debt", Utils.formatBigDecimalSumm((BigDecimal)bu.getBalance(LocalDate.now(), contract.getId())));
        }
    }
}

