/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.service.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFilterPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.systems.inventory.service.client.ServiceSpecFilter;
import ru.bitel.oss.systems.inventory.service.client.ServiceSpecForm;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;
import ru.bitel.oss.systems.inventory.service.common.service.ServiceService;

public class ServiceSpecPanel
extends BGUPanel {
    public static final int MODE_EDIT = 0;
    public static final int MODE_SELECT = 1;
    private int mode = 0;
    protected BGEditor editor;
    private BGUTreeTable table;
    private ServiceSpecFilter filter;
    private ServiceService serviceService;
    private ServiceSpecTreeTableModel model;

    public ServiceSpecPanel(ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            String title = this.filter.mainFilter.title.getText();
            Date dateFrom = this.filter.mainFilter.period.getDateFrom();
            Date dateTo = this.filter.mainFilter.period.getDateTo();
            this.getServiceSpecTreeTableModel().setData(this.getServiceService().serviceSpecTree(Integer.valueOf(((ClientContext)this.getContext()).getModuleId()), dateFrom, dateTo, title));
            this.table.expandAfterUpdate();
        });
    }

    @Override
    protected void jbInit() throws Exception {
        this.table = new BGUTreeTable(this.getServiceSpecTreeTableModel());
        JPanel rightPanel = new JPanel(new BorderLayout());
        BGFilterPane splitPane = new BGFilterPane(this.mode != 0);
        if (this.mode == 0) {
            this.editor = new BGEditor("table");
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.setName("table");
            tablePanel.add((Component)new JScrollPane(this.table), "Center");
            rightPanel.add((Component)this.editor, "Center");
            this.filter = this.createFilter();
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(tablePanel);
            this.editor.addForm(splitPane, "table");
            this.addForms();
            this.add((Component)this.editor, "Center");
            BGSwingUtilites.handleEdit(this.table, this);
        } else {
            rightPanel.add((Component)new JScrollPane(this.table), "Center");
            this.filter = this.createFilter();
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(rightPanel);
            this.add((Component)splitPane, "Center");
        }
    }

    protected void addForms() {
        this.editor.addForm(new ServiceSpecForm(this, (ClientContext)this.getContext()));
    }

    protected ServiceSpecFilter createFilter() {
        return new ServiceSpecFilter(this, (ClientContext)this.getContext());
    }

    ServiceSpecTreeTableModel getServiceSpecTreeTableModel() {
        if (this.model == null) {
            this.model = new ServiceSpecTreeTableModel(ServiceSpecTreeTableModel.class.getName());
        }
        return this.model;
    }

    ServiceService getServiceService() {
        if (this.serviceService == null) {
            this.serviceService = ((ClientContext)this.getContext()).getPort(ServiceService.class, 0);
        }
        return this.serviceService;
    }

    protected int getEntitySpecId() throws Exception {
        return 0;
    }

    class ServiceSpecTreeTableModel
    extends BGTreeTableModel<ServiceSpec> {
        private final Icon iconRoot;
        private final Icon iconNode;
        private final Icon iconLeaf;

        public ServiceSpecTreeTableModel(String name) {
            super(name);
            this.iconRoot = ClientUtils.getIcon("fugue/folder");
            this.iconNode = ClientUtils.getIcon("fugue/folder");
            this.iconLeaf = ClientUtils.getIcon("fugue/cake");
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", ServiceSpec.class, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 100, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", 100, 150, 200, "identifier", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        @Override
        public Object getValue(ServiceSpec val, int column) throws Exception {
            Object value = null;
            switch (column) {
                case 0: {
                    if (val == this.root) {
                        value = "\u0421\u0435\u0440\u0432\u0438\u0441\u044b";
                        break;
                    }
                    value = val.getTitle();
                    break;
                }
                default: {
                    value = super.getValue(val, column);
                }
            }
            return value;
        }

        @Override
        public Icon getIcon(ServiceSpec value) {
            if (value == this.root) {
                return this.iconRoot;
            }
            if (this.isLeaf(value)) {
                return this.iconLeaf;
            }
            return this.iconNode;
        }
    }
}

