/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;

public class EntityAttrDateCellEditor
extends AbstractCellEditor
implements TableCellEditor,
PropertyChangeListener {
    private BGCalendarButton calendarButton = new BGCalendarButton();
    private EntityAttrEntry value = null;
    private JTable table;

    public EntityAttrDateCellEditor() {
        this.calendarButton.setHorizontalAlignment(2);
        this.calendarButton.setFocusPainted(false);
        this.calendarButton.addPropertyChangeListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        Calendar calendar = this.calendarButton.getCalendar();
        return calendar != null ? calendar.getTime() : null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.value = (EntityAttrEntry)value;
        if (this.value.getAttr() != null) {
            this.calendarButton.setLocalDate(TimeUtils.convertDateToLocalDate(((EntityAttrDate)this.value.getAttr()).getValue()));
        }
        return this.calendarButton;
    }

    @Override
    public boolean stopCellEditing() {
        Date value = (Date)this.getCellEditorValue();
        if (value == null) {
            this.value.setAttr(null);
        } else {
            this.value.setAttr((EntityAttr)new EntityAttrDate(this.value.getEntity().getEntityId(), this.value.getSpecAttr().getId(), value));
        }
        return super.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("popupVisible".equals(propertyName)) {
            this.stopCellEditing();
            this.table.requestFocus();
        }
    }
}

