/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.xml;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.xml.MapAdapters;

public class XmlAdapters {

    @XmlType(name="localDate")
    static final class LocalDateWrapper {
        @XmlValue
        @XmlJavaTypeAdapter(value=LocalDateAdapter.class)
        public LocalDate item;

        public LocalDateWrapper(LocalDate item) {
            this.item = item;
        }

        public LocalDateWrapper() {
        }
    }

    public static final class DocumentAdapter
    extends XmlAdapter<String, Document> {
        public Document unmarshal(String v) throws Exception {
            return v.isEmpty() ? null : XMLUtils.parseDocument(new String(Base64.getDecoder().decode(v), "UTF-8"));
        }

        public String marshal(Document v) throws Exception {
            return Base64.getEncoder().encodeToString(XMLUtils.serializeToString(v, false).getBytes("UTF-8"));
        }
    }

    public static class LocalTimeAdapter
    extends XmlAdapter<String, LocalTime> {
        public LocalTime unmarshal(String v) throws Exception {
            return v.isEmpty() ? null : LocalTime.parse(v);
        }

        public String marshal(LocalTime v) throws Exception {
            return v == null ? "" : String.valueOf(v);
        }
    }

    public static class LocalDateTimeAdapter
    extends XmlAdapter<String, LocalDateTime> {
        public LocalDateTime unmarshal(String v) throws Exception {
            return v.isEmpty() ? null : LocalDateTime.parse(v);
        }

        public String marshal(LocalDateTime v) throws Exception {
            return v == null ? "" : String.valueOf(v);
        }
    }

    public static class JSONArrayAdapter
    extends XmlAdapter<String, JSONArray> {
        public JSONArray unmarshal(String v) throws Exception {
            return new JSONArray(v);
        }

        public String marshal(JSONArray v) throws Exception {
            return v.toString();
        }
    }

    public static class JSONAdapter
    extends XmlAdapter<String, JSONObject> {
        public JSONObject unmarshal(String v) throws Exception {
            return new JSONObject(v);
        }

        public String marshal(JSONObject v) throws Exception {
            return v.toString();
        }
    }

    public static class LocalDateAdapter
    extends XmlAdapter<String, LocalDate> {
        public LocalDate unmarshal(String v) throws Exception {
            return v.isEmpty() ? null : LocalDate.parse(v);
        }

        public String marshal(LocalDate v) throws Exception {
            return v == null ? "" : String.valueOf(v);
        }
    }

    public static class ZonedDateTimeAdapter
    extends XmlAdapter<String, ZonedDateTime> {
        public ZonedDateTime unmarshal(String v) throws Exception {
            return v.isEmpty() ? null : ZonedDateTime.parse(v);
        }

        public String marshal(ZonedDateTime v) throws Exception {
            return v == null ? "" : String.valueOf(v);
        }
    }

    public static class TemporalAdapter
    extends XmlAdapter<String, Temporal> {
        public Temporal unmarshal(String v) throws Exception {
            if (v.lastIndexOf(58) > 0) {
                if (v.lastIndexOf(43) > 0) {
                    return ZonedDateTime.parse(v);
                }
                return LocalDateTime.parse(v);
            }
            return v.isEmpty() ? null : LocalDate.parse(v);
        }

        public String marshal(Temporal v) throws Exception {
            return v == null ? "" : String.valueOf(v);
        }
    }

    @XmlType(name="list")
    @XmlSeeAlso(value={MapAdapters.MapEntry.class})
    public static final class ListWrapper<I>
    implements ListHolder<I> {
        public List<I> item;

        public ListWrapper(List<I> item) {
            this.item = item;
        }

        public ListWrapper() {
        }

        @Override
        @XmlTransient
        public List<I> getList() {
            return this.item;
        }
    }

    static interface ListHolder<I> {
        public List<I> getList();
    }

    @XmlType(name="collection")
    static final class CollectionWrapper {
        public Collection<Object> item;

        public CollectionWrapper(Collection<Object> item) {
            this.item = item;
        }

        public CollectionWrapper() {
        }
    }
}

