/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;

public abstract class AbstractPeriodItemSet<I extends PeriodItem>
extends BGLogger {
    private final Class<I> itemClass;
    protected final I[] entries;
    private static final Comparator<PeriodItem> timeFromComparator = new Comparator<PeriodItem>(){

        @Override
        public int compare(PeriodItem o1, PeriodItem o2) {
            long c = o1.timeFrom - o2.timeFrom;
            if (c > 0L) {
                return 1;
            }
            if (c < 0L) {
                return -1;
            }
            return 0;
        }
    };

    protected AbstractPeriodItemSet(Class<I> itemClass, List<I> entryList) {
        this.itemClass = itemClass;
        this.entries = entryList.toArray((PeriodItem[])Array.newInstance(itemClass, entryList.size()));
    }

    protected AbstractPeriodItemSet(Class<I> itemClass, I[] entries) {
        this.itemClass = itemClass;
        this.entries = entries;
    }

    protected boolean containsMillis(I item, long millis) {
        return !(((PeriodItem)item).timeFrom != 0L && ((PeriodItem)item).timeFrom > millis || ((PeriodItem)item).timeTo != 0L && millis > ((PeriodItem)item).timeTo);
    }

    protected boolean isCoincide(I item, I other) {
        return ((PeriodItem)other).id == ((PeriodItem)item).id && ((PeriodItem)other).timeFrom == ((PeriodItem)item).timeFrom && ((PeriodItem)other).timeTo == ((PeriodItem)item).timeTo;
    }

    protected I[] add(I newItem) {
        int index = Arrays.binarySearch(this.entries, newItem, timeFromComparator);
        index = index < 0 ? -index - 1 : ++index;
        PeriodItem[] newEntries = (PeriodItem[])Array.newInstance(this.itemClass, this.entries.length + 1);
        System.arraycopy(this.entries, 0, newEntries, 0, index);
        newEntries[index] = newItem;
        System.arraycopy(this.entries, index, newEntries, index + 1, this.entries.length - index);
        return newEntries;
    }

    protected I[] update(I newItem) {
        for (I item : this.entries) {
            if (!this.isCoincide(item, newItem)) continue;
            PeriodItem[] newEntries = (PeriodItem[])Array.newInstance(this.itemClass, this.entries.length);
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            newEntries[i] = newItem;
            return newEntries;
        }
        return this.add((PeriodItem)newItem);
    }

    protected I[] remove(I oldItem) {
        int size = this.entries.length;
        for (int i = 0; i < size; ++i) {
            I item = this.entries[i];
            if (!this.isCoincide(item, oldItem)) continue;
            PeriodItem[] newEntries = (PeriodItem[])Array.newInstance(this.itemClass, this.entries.length - 1);
            System.arraycopy(this.entries, 0, newEntries, 0, i);
            System.arraycopy(this.entries, i + 1, newEntries, i, this.entries.length - (i + 1));
            return newEntries;
        }
        return this.entries;
    }

    public boolean contains(Date time, Set<Integer> optionIds) {
        return this.contains(time.getTime(), optionIds);
    }

    public boolean contains(long millis, Set<Integer> optionIds) {
        for (I item : this.entries) {
            if (!optionIds.contains(((PeriodItem)item).id) || !this.containsMillis(item, millis)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Date time, Set<Integer> optionIds) {
        return this.containsAll(time.getTime(), optionIds);
    }

    public boolean containsAll(long millis, Set<Integer> optionIds) {
        HashSet<Integer> set = new HashSet<Integer>(optionIds);
        for (I item : this.entries) {
            if (!this.containsMillis(item, millis)) continue;
            set.remove(((PeriodItem)item).id);
        }
        return set.size() == 0;
    }

    public long count(int optionId, Date date1, Date date2) {
        return this.count(optionId, date1.getTime(), date2.getTime());
    }

    public long count(int optionId, long date1, long date2) {
        int result = 0;
        long[] intersection = new long[2];
        for (I item : this.entries) {
            long[] period;
            if (optionId != ((PeriodItem)item).id || (period = RangeUtils.intersectionAnd(intersection, ((PeriodItem)item).timeFrom, ((PeriodItem)item).timeTo, date1, date2)) == null) continue;
            ++result;
        }
        return result;
    }

    public long countMillis(int optionId, Date date1, Date date2) {
        return this.countMillis(optionId, date1.getTime(), date2.getTime());
    }

    public long countMillis(int optionId, long date1, long date2) {
        long result = 0L;
        long[] intersection = new long[2];
        for (I item : this.entries) {
            long[] period;
            if (optionId != ((PeriodItem)item).id || (period = RangeUtils.intersectionAnd(intersection, ((PeriodItem)item).timeFrom, ((PeriodItem)item).timeTo, date1, date2)) == null) continue;
            result += period[1] - period[0];
        }
        return result;
    }

    public Set<Integer> items(Date date1, Date date2) {
        return this.items(date1.getTime(), date2.getTime());
    }

    public Set<Integer> items(long date1, long date2) {
        if (this.entries.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> options = new HashSet<Integer>(4);
        long[] intersection = new long[2];
        for (I item : this.entries) {
            long[] period = RangeUtils.intersectionAnd(intersection, ((PeriodItem)item).timeFrom, ((PeriodItem)item).timeTo, date1, date2);
            if (period == null) continue;
            options.add(((PeriodItem)item).id);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptySet();
    }

    public Set<Integer> items(long millis) {
        if (this.entries.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> options = new HashSet<Integer>(4);
        for (I item : this.entries) {
            if (((PeriodItem)item).timeFrom > millis && ((PeriodItem)item).timeFrom != 0L || ((PeriodItem)item).timeTo < millis && ((PeriodItem)item).timeTo != 0L) continue;
            options.add(((PeriodItem)item).id);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptySet();
    }

    public I item(long millis) {
        for (I item : this.entries) {
            if (((PeriodItem)item).timeFrom > millis && ((PeriodItem)item).timeFrom != 0L || ((PeriodItem)item).timeTo < millis && ((PeriodItem)item).timeTo != 0L) continue;
            return item;
        }
        return null;
    }

    public Map<Integer, I> map(long date1, long date2) {
        if (this.entries.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, I> options = new HashMap<Integer, I>(4);
        long[] intersection = new long[2];
        for (I item : this.entries) {
            if (RangeUtils.intersectionAnd(intersection, ((PeriodItem)item).timeFrom, ((PeriodItem)item).timeTo, date1, date2) == null) continue;
            options.put(((PeriodItem)item).id, item);
        }
        return options.size() > 0 ? options : Collections.emptyMap();
    }

    public long nextActivateTime(long millis) {
        long result = Long.MAX_VALUE;
        for (I item : this.entries) {
            if (((PeriodItem)item).timeFrom > millis) {
                if (((PeriodItem)item).timeFrom >= result) continue;
                result = ((PeriodItem)item).timeFrom;
                continue;
            }
            if (((PeriodItem)item).timeTo + 1L <= millis || ((PeriodItem)item).timeTo >= result) continue;
            result = ((PeriodItem)item).timeTo + 1L;
        }
        return result != Long.MAX_VALUE ? result : 0L;
    }

    public int size() {
        return this.entries.length;
    }

    public I get(int i) {
        return this.entries[i];
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (I item : this.entries) {
            ((PeriodItem)item).toString(result).append('\n');
        }
        return result.toString();
    }

    public static class PeriodItem {
        public final int id;
        public final long timeFrom;
        public final long timeTo;

        public PeriodItem(int id, Date timeFrom, Date timeTo) {
            this.id = id;
            this.timeFrom = timeFrom != null ? timeFrom.getTime() : 0L;
            long l = this.timeTo = timeTo != null ? timeTo.getTime() - 1L : 0L;
            assert (this.timeFrom % 1000L == 0L);
            assert (this.timeTo == 0L || this.timeTo % 1000L == 999L);
        }

        public PeriodItem(int id, long timeFrom, long timeTo) {
            assert (timeFrom % 1000L == 0L);
            assert (timeTo == 0L || timeTo % 1000L == 999L);
            this.id = id;
            this.timeFrom = timeFrom;
            this.timeTo = timeTo;
        }

        public StringBuilder toString(StringBuilder sb) {
            return sb.append(this.id).append(": ").append(this.timeFrom == 0L ? "null" : TimeUtils.format(new Date(this.timeFrom), "dd.MM.yyyy HH:mm:ss.S")).append(" - ").append(this.timeTo == 0L ? "null" : TimeUtils.format(new Date(this.timeTo), "dd.MM.yyyy HH:mm:ss.S"));
        }
    }
}

