/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.RunningTask;
import ru.bitel.bgbilling.kernel.task.server.SchedulerUtils;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskData;
import ru.bitel.common.Utils;

public class RunTaskDataManager
extends BGLogger {
    private static final String QUEUE_TABLE = "scheduled_task_run";
    private static final String PERIODIC_RUN_TABLE = "scheduled_periodic_run";
    private Connection con;

    public RunTaskDataManager(Connection con) {
        this.con = con;
    }

    public void addTask(RunTask task) {
        String query = "INSERT INTO scheduled_task_run SET data=?, description=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Blob blob = this.con.createBlob();
            ObjectOutputStream oos = new ObjectOutputStream(blob.setBinaryStream(1L));
            oos.writeObject(task);
            oos.close();
            ps.setBlob(1, blob);
            String description = "";
            try {
                description = task.getDescription();
            }
            catch (Throwable t) {
                this.getLogger().error(t.getMessage(), t);
            }
            ps.setString(2, description);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    @Deprecated
    public void removeTask(int id) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM scheduled_task_run WHERE id=?");
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    @Deprecated
    public List<PeriodicTaskRun> getCurrentPeriodic() {
        ArrayList<PeriodicTaskRun> result = new ArrayList<PeriodicTaskRun>();
        String query = "SELECT id, description, amount FROM scheduled_periodic_run WHERE amount>0";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                PeriodicTaskRun ptr = new PeriodicTaskRun(this);
                ptr.id = rs.getInt(1);
                ptr.description = rs.getString(2);
                ptr.amount = rs.getInt(3);
                result.add(ptr);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public int getTaskCount() {
        int result = 0;
        String query = "SELECT COUNT(*) FROM scheduled_task_run";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    @Deprecated
    public List<RunningTask> getTasks() {
        ArrayList<RunningTask> result = new ArrayList<RunningTask>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id, description, executed, start_time FROM scheduled_task_run ORDER BY executed, id");){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RunningTask rtb = new RunningTask();
                rtb.setId(rs.getInt(1));
                rtb.setDescription(rs.getString(2));
                rtb.setExecuted("1".equals(rs.getString(3)));
                rtb.setStartTime(rs.getTimestamp(4));
                result.add(rtb);
            }
            rs.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    public RunTask getNextTask() throws Exception {
        RunTask result = null;
        int id = -1;
        String query = "SELECT * FROM scheduled_task_run WHERE executed=0 ORDER BY id DESC LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                id = rs.getInt("id");
                try {
                    ObjectInputStream inputStream = new ObjectInputStream(rs.getBinaryStream("data"));
                    result = (RunTask)inputStream.readObject();
                    result.setQueueId(id);
                }
                catch (Exception ex) {
                    this.getLogger().error("error read task id=" + id + " from DB", (Throwable)ex);
                }
            }
            rs.close();
        }
        if (result != null) {
            query = "UPDATE scheduled_task_run SET executed=1, start_time=NOW() WHERE id=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, result.getQueueId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        } else if (id > 0) {
            this.removeTask(id);
            return null;
        }
        return result;
    }

    public List<RunTask> getNextTasks() throws SQLException {
        ArrayList<RunTask> taskNew = new ArrayList<RunTask>();
        ArrayList<RunTask> taskActive = new ArrayList<RunTask>();
        ArrayList<Integer> taskQueueIdToDelete = new ArrayList<Integer>();
        ArrayList<RunTask> taskToExecute = new ArrayList<RunTask>();
        PreparedStatement ps = this.con.prepareStatement("SELECT * FROM scheduled_task_run ORDER BY id ASC");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int id = rs.getInt("id");
            RunTask result = null;
            try {
                ObjectInputStream inputStream = new ObjectInputStream(rs.getBinaryStream("data"));
                result = (RunTask)inputStream.readObject();
            }
            catch (Exception ex) {
                this.getLogger().error("get next tasks: error read task id=" + id + " from DB", (Throwable)ex);
                taskQueueIdToDelete.add(id);
                continue;
            }
            result.setQueueId(id);
            boolean executed = rs.getBoolean("executed");
            if (executed) {
                taskActive.add(result);
                continue;
            }
            taskNew.add(result);
        }
        rs.close();
        ps.close();
        block3: for (RunTask nextTask : taskNew) {
            String nextTaskUniqKeyQueue = nextTask.getUniqueKeyQueue();
            String nextTaskUniqKeyParallel = nextTask.getUniqueKeyParallel();
            this.getLogger().info("get next tasks: new task id=" + nextTask.getQueueId() + " " + nextTask.getDescription() + (String)(nextTaskUniqKeyQueue != null ? ", UniqKeyQueue: " + nextTaskUniqKeyQueue : "") + (String)(nextTaskUniqKeyParallel != null ? ", UniqKeyParallel: " + nextTaskUniqKeyParallel : ""));
            if (nextTaskUniqKeyQueue != null) {
                for (RunTask t : taskToExecute) {
                    if (!nextTaskUniqKeyQueue.equals(t.getUniqueKeyQueue())) continue;
                    this.getLogger().info("get next tasks: the task id=" + nextTask.getQueueId() + " is duplicated in the task queue (" + nextTaskUniqKeyQueue + "), a duplicate will be remove");
                    taskQueueIdToDelete.add(nextTask.getQueueId());
                    continue block3;
                }
            }
            if (nextTaskUniqKeyParallel != null) {
                for (RunTask t : taskActive) {
                    if (!nextTaskUniqKeyParallel.equals(t.getUniqueKeyParallel())) continue;
                    this.getLogger().info("get next tasks: the task id=" + nextTask.getQueueId() + " is already active/running (" + nextTaskUniqKeyParallel + "), a duplicate will be ignored");
                    continue block3;
                }
            }
            taskToExecute.add(nextTask);
        }
        for (RunTask result : taskToExecute) {
            ps = this.con.prepareStatement("UPDATE scheduled_task_run SET executed=1, start_time=NOW() WHERE id=?");
            ps.setInt(1, result.getQueueId());
            ps.executeUpdate();
            ps.close();
        }
        if (!taskQueueIdToDelete.isEmpty()) {
            this.getLogger().info("get next tasks: delete tasks id=" + Utils.toString(taskQueueIdToDelete));
            for (Integer id : taskQueueIdToDelete) {
                this.removeTask(id);
            }
        }
        return taskToExecute;
    }

    public void clearCurrentPeriodic() throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("DELETE FROM scheduled_periodic_run");
        ps.executeUpdate();
        ps.close();
    }

    public List<TaskData> getTaskDataForReload() throws Exception {
        ArrayList<TaskData> list = new ArrayList<TaskData>();
        java.util.Date now = new java.util.Date();
        String query = "SELECT st.*, sc.class FROM scheduled_tasks AS st LEFT JOIN scheduled_class AS sc ON st.class_id=sc.id WHERE ( date1 is null or date1 <= ? ) && ( date2 is null or date2 >= ? ) AND status=1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setDate(1, new Date(now.getTime()));
            ps.setDate(2, new Date(now.getTime()));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int id;
                    String className = rs.getString("st.class") != null ? rs.getString("st.class") : rs.getString("sc.class");
                    String moduleId = rs.getString("st.module_id");
                    String taskParams = rs.getString("st.params");
                    String dependentTasks = rs.getString("st.dependent_tasks");
                    boolean isPlugin = moduleId.startsWith("p");
                    if (!SchedulerUtils.checkExistModule(isPlugin, id = Utils.parseInt(isPlugin ? moduleId.substring(1) : moduleId, -1), className, taskParams)) continue;
                    TaskData td = new TaskData(rs.getInt("st.mm"), rs.getInt("st.dm"), rs.getInt("st.dw"), rs.getInt("st.hh"), rs.getLong("st.min"));
                    td.setClassName(className);
                    td.setPlugin(isPlugin);
                    td.setModuleId(id);
                    td.setPriority(rs.getInt("st.prior"));
                    td.setId(rs.getInt("st.id"));
                    td.setParams(taskParams);
                    if (Utils.notBlankString(dependentTasks)) {
                        td.setDependentTasks(DependentTask.fromJSONArray(new JSONArray(dependentTasks)));
                    }
                    list.add(td);
                }
            }
        }
        return list;
    }

    @Deprecated
    public class PeriodicTaskRun {
        public int id;
        public String description;
        public int amount;

        public PeriodicTaskRun(RunTaskDataManager this$0) {
        }
    }
}

