/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ServiceCostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("coin");
    private JLabel _view = new JLabel();
    private BGComboBox<ComboBoxItem> _type = new BGComboBox();
    private JPanel _edit;
    private BGFloatTextField _cost = new BGFloatTextField();
    private BGIntTextField _col = new BGIntTextField();
    private Directory costTypeDir;
    private BGComboBox<IdTitle> costTypeCB;

    public ServiceCostTariffTreeNode() {
        this._view.setIcon(icon);
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this._edit == null) {
            this._edit = new JPanel(new GridBagLayout());
            this._col.setColumns(4);
            this._cost.setColumns(10);
            this._edit.add((Component)this._cost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this._edit.add((Component)new JLabel(" \u0437\u0430 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
            this._edit.add((Component)this._col, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
            this._edit.add((Component)new JLabel(" "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
            this._edit.add(this._type, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
            if (this.costTypeCB != null) {
                this._edit.add(this.costTypeCB, new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            }
        }
        return this._edit;
    }

    @Override
    public Component getView() {
        return this._view;
    }

    @Override
    protected void loadData() {
        String col;
        Map<String, String> data = this.getDataInHash();
        String cost = data.get("cost");
        if (cost != null) {
            this._cost.setText(cost);
        }
        if ((col = data.get("col")) != null) {
            this._col.setText(col);
        }
        ClientUtils.setComboBoxSelection(this._type, data.get("type"));
        if (this.costTypeCB != null) {
            this.setDirectoryItemSelection(this.costTypeCB, Utils.parseInt(data.get("costType"), 0));
        }
    }

    @Override
    protected void serializeData() {
        IdTitle costTypeItem;
        HashMap<String, String> data = new HashMap<String, String>(3);
        data.put("cost", this._cost.getText());
        data.put("col", this._col.getText());
        ComboBoxItem typeItem = this._type.getSelectedItem();
        data.put("type", (String)typeItem.getObject());
        if (this.costTypeCB != null && (costTypeItem = this.costTypeCB.getSelectedItem()) != null) {
            data.put("costType", String.valueOf(costTypeItem.getId()));
        }
        this.setDataInHash(data);
        this.updateView();
    }

    private void updateView() {
        IdTitle costTypeItem;
        StringBuffer sb = new StringBuffer();
        sb.append(this._cost.getText());
        sb.append(" \u0437\u0430 ");
        sb.append(this._col.getText());
        sb.append(" ");
        ComboBoxItem item = this._type.getSelectedItem();
        sb.append(item.toString());
        if (this.costTypeCB != null && (costTypeItem = this.costTypeCB.getSelectedItem()).getId() > 0) {
            sb.append(" (").append(costTypeItem.getTitle()).append(')');
        }
        this._view.setText(sb.toString());
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.loadData();
        this.updateView();
    }

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        boolean costTypes;
        String mode;
        super.init(id, mtree, type, tree, config, parent, childsArray);
        Element ref = config.getTypeElement(this.getType());
        if (ref != null) {
            mode = ref.getAttribute("mode");
            costTypes = "1".equals(ref.getAttribute("costTypes"));
        } else {
            mode = null;
            costTypes = false;
        }
        if (!"2".equals(mode)) {
            this._type.addItem(new ComboBoxItem("0", "\u0431\u0430\u0439\u0442"));
            this._type.addItem(new ComboBoxItem("1", "KB"));
            this._type.addItem(new ComboBoxItem("2", "MB"));
            this._type.addItem(new ComboBoxItem("3", "GB"));
        }
        if (!"1".equals(mode)) {
            this._type.addItem(new ComboBoxItem("4", "\u0441\u0435\u043a\u0443\u043d\u0434"));
            this._type.addItem(new ComboBoxItem("5", "\u043c\u0438\u043d\u0443\u0442"));
            this._type.addItem(new ComboBoxItem("6", "\u0447\u0430\u0441\u043e\u0432"));
        }
        if (costTypes) {
            this.costTypeDir = this.getDirManager().getDirectory("tariff_detail_cost_type");
            this.costTypeCB = new BGComboBox();
            try {
                this.buildDirectoryCombo(this.costTypeDir, this.costTypeCB);
                this.costTypeCB.insertItemAt(IdTitle.NO_SELECT, 0);
                this.costTypeCB.setSelectedIndex(0);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }
}

