/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow.nat;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogExportParameters;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Record;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;
import ru.bitel.common.inet.IpAddress;

abstract class SimpleNatLogProcessor
implements Netflow9Processor {
    final long timeFromMillis;
    final long timeToMillis;
    final byte[] extAddress;
    final int[] extPorts;
    final NetFlow9Record record = new NetFlow9Record();

    public SimpleNatLogProcessor(long timeFromMillis, long timeToMillis, byte[] extAddress, Set<Integer> extPorts) {
        this.timeFromMillis = timeFromMillis;
        this.timeToMillis = timeToMillis;
        this.extAddress = extAddress;
        if (extPorts == null || extPorts.size() == 0) {
            this.extPorts = null;
        } else {
            this.extPorts = new int[extPorts.size()];
            int pos = 0;
            for (Integer port : extPorts) {
                this.extPorts[pos++] = port;
            }
        }
    }

    @Override
    public void process(ByteBuffer readBuffer, int offset, long millis, NetFlow9Template template) throws Exception {
        if (!template.natLog) {
            return;
        }
        readBuffer.position(offset);
        this.record.fillData(readBuffer, template);
        if ((this.timeFromMillis != 0L && this.timeFromMillis > millis || this.timeToMillis != 0L && this.timeToMillis < millis) && (this.timeFromMillis != 0L && this.timeFromMillis > this.record.milliseconds || this.timeToMillis != 0L && this.timeToMillis < this.record.milliseconds)) {
            return;
        }
        byte[] postNatSourceAddress = null;
        int postNatSourcePort = 0;
        if (template.hslNatLogFieldTranslatedSourceIpv4Addr.init) {
            readBuffer.position(offset + template.hslNatLogFieldTranslatedSourceIpv4Addr.offset);
            postNatSourceAddress = new byte[template.hslNatLogFieldTranslatedSourceIpv4Addr.length];
            readBuffer.get(postNatSourceAddress);
        }
        byte[] destAddress = null;
        int destPort = 0;
        byte[] postNatDestAddress = null;
        int postNatDestPort = 0;
        if (template.hslNatLogFieldTranslatedDestinationIPv4Addr.init) {
            readBuffer.position(offset + template.hslNatLogFieldTranslatedDestinationIPv4Addr.offset);
            postNatDestAddress = new byte[template.hslNatLogFieldTranslatedDestinationIPv4Addr.length];
            readBuffer.get(postNatDestAddress);
            if (template.ip4DstAddressItem.init) {
                readBuffer.position(offset + template.ip4DstAddressItem.offset);
                destAddress = new byte[template.ip4DstAddressItem.length];
                readBuffer.get(destAddress);
            } else {
                destAddress = postNatDestAddress;
            }
        } else {
            postNatDestAddress = destAddress = this.record.dstAddress.address;
        }
        if (this.extAddress != null && !IpAddress.equals(this.extAddress, postNatSourceAddress) && !IpAddress.equals(this.extAddress, destAddress)) {
            return;
        }
        if (template.hslNatLogFieldTranslatedSourcePort.init) {
            postNatSourcePort = readBuffer.getShort(offset + template.hslNatLogFieldTranslatedSourcePort.offset) & 0xFFFF;
        }
        if (template.hslNatLogFieldTranslatedDestinationPort != null && template.hslNatLogFieldTranslatedDestinationPort.init) {
            postNatDestPort = readBuffer.getShort(offset + template.hslNatLogFieldTranslatedDestinationPort.offset) & 0xFFFF;
            destPort = template.l4DstPortItem.init ? readBuffer.getShort(offset + template.l4DstPortItem.offset) & 0xFFFF : postNatDestPort;
        } else {
            postNatDestPort = destPort = this.record.dstPort;
        }
        if (this.extPorts != null) {
            boolean find = false;
            int size = this.extPorts.length;
            for (int i = 0; i < size; ++i) {
                if (this.extPorts[i] != postNatSourcePort && this.extPorts[i] != destPort) continue;
                find = true;
                break;
            }
            if (!find) {
                return;
            }
        }
        this.processFiltered(millis, this.record, destAddress, destPort, postNatSourceAddress, postNatSourcePort, postNatDestAddress, postNatDestPort);
    }

    protected abstract void processFiltered(long var1, NetFlow9Record var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9) throws IOException;

    public static class ExportSimpleNatLogProcessor
    extends SimpleNatLogProcessor {
        final Date utilDate = new Date();
        final Writer writer;
        final DateFormat format;

        public ExportSimpleNatLogProcessor(NatLogExportParameters exportParameters, Writer writer, DateFormat format) throws IOException {
            super(exportParameters.timeFromMillis, exportParameters.timeToMillis, exportParameters.address, exportParameters.ports);
            this.writer = writer;
            this.format = format;
            writer.write("Timestamp\tFromIp\tFromPort\tNATFromIp\tNATFromPort\tToIp\tToPort\tNATToIp\tNATToPort\tBytes\tFromIface\tToIface\tProtocol\n");
        }

        @Override
        protected void processFiltered(long millis, NetFlow9Record flow, byte[] destAddress, int destPort, byte[] postNatSourceAddress, int postNatSourcePort, byte[] postNatDestAddress, int postNatDestPort) throws IOException {
            if (this.format != null) {
                this.utilDate.setTime(millis);
                this.writer.write(this.format.format(this.utilDate));
            } else {
                this.writer.write(String.valueOf(millis));
            }
            this.writer.write(9);
            this.writer.write(String.valueOf(flow.getSrcIpAddress()));
            this.writer.write(9);
            this.writer.write(String.valueOf(flow.getSrcPort()));
            this.writer.write(9);
            if (postNatSourceAddress != null) {
                this.writer.write(IpAddress.toString(postNatSourceAddress));
            }
            this.writer.write(9);
            this.writer.write(String.valueOf(postNatSourcePort));
            this.writer.write(9);
            this.writer.write(IpAddress.toString(destAddress));
            this.writer.write(9);
            this.writer.write(String.valueOf(destPort));
            this.writer.write(9);
            if (postNatDestAddress != null) {
                this.writer.write(IpAddress.toString(postNatDestAddress));
            }
            this.writer.write(9);
            this.writer.write(String.valueOf(postNatDestPort));
            this.writer.write(9);
            this.writer.write(String.valueOf(flow.getOctets()));
            this.writer.write(9);
            this.writer.write(String.valueOf(flow.getInputInterface()));
            this.writer.write(9);
            this.writer.write(String.valueOf(flow.getOutputInterface()));
            this.writer.write(9);
            this.writer.write(String.valueOf(flow.getProtocol()));
            this.writer.write(10);
        }
    }
}

