/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.base.phone.client.RangeMapTreeEditor;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.GeographicCode;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMap;
import ru.bitel.bgbilling.kernel.base.phone.common.service.RangeMapService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ServiceConfigRangeMap
extends ServiceConfigTabbedPanel {
    RangeMapService rangeMapService = this.getContext().getPort(RangeMapService.class);
    private BGEditor bgEditor;
    RangeMapTable table;
    private RangeMapTreeEditor rangeMapTreeEditor;

    public ServiceConfigRangeMap() {
        this.jbInit();
    }

    protected void jbInit() {
        this.bgEditor = new BGEditor("table");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bgEditor, "Center");
        this.bgEditor.addPropertyChangeListener("edit", e -> {
            if (Boolean.FALSE.equals(e.getNewValue())) {
                this.setData();
            }
        });
        this.table = new RangeMapTable();
        this.bgEditor.addForm(this.table);
        this.rangeMapTreeEditor = new RangeMapTreeEditor(this);
        this.bgEditor.addForm(this.rangeMapTreeEditor);
    }

    @Override
    public void setData() {
        this.table.setData();
    }

    @Override
    public void deleteItem() {
        this.bgEditor.performAction("delete");
    }

    @Override
    public void editItem() {
        this.bgEditor.performAction("edit");
    }

    @Override
    public void newItem() {
        this.bgEditor.performAction("new");
    }

    class RangeMapTable
    extends BGUPanel {
        BGTableModel<RangeMap> model;
        private BGUTable table;
        private BGEditor bgEditor;
        private RangeMapEditor rangeMapEditor;

        public RangeMapTable() {
            super(new GridBagLayout());
            this.setName("table");
            this.build();
        }

        @Override
        protected void jbInit() {
            this.model = new BGTableModel<RangeMap>("rangeMap"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0413\u0440\u0443\u043f\u043f\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u0432", -1, 150, -1, "title", true);
                }
            };
            this.table = new BGUTable(this.model);
            this.table.setSelectionMode(0);
            this.rangeMapEditor = new RangeMapEditor();
            this.bgEditor = new BGEditor();
            this.bgEditor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
            this.bgEditor.addForm(this.rangeMapEditor, "editor");
            this.bgEditor.setVisible(false);
            this.bgEditor.addPropertyChangeListener("edit", e -> {
                this.table.setEnabled((Boolean)e.getOldValue());
                if (Boolean.FALSE.equals(e.getNewValue())) {
                    ServiceConfigRangeMap.this.setData();
                }
            });
            this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.bgEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ServiceConfigRangeMap.this.rangeMapTreeEditor.setData();
                    }
                }
            });
        }

        public void setData() {
            List<RangeMap> result = null;
            try {
                result = ServiceConfigRangeMap.this.rangeMapService.rangeMapList("id");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            if (result != null) {
                this.model.setData(result);
            }
        }
    }

    final class GeographicCodeParser
    extends DefaultHandler
    implements ContentHandler {
        private GeographicCode[] path = new GeographicCode[20];
        private int level = 0;

        public GeographicCodeParser(ServiceConfigRangeMap this$0, GeographicCode parent) {
            this.path[this.level] = parent;
        }

        @Override
        public void startElement(String namespace, String localname, String type, Attributes attributes) throws SAXException {
            if (type.equals("n")) {
                GeographicCode curr = new GeographicCode();
                curr.setCode(attributes.getValue("c"));
                curr.setDestination(attributes.getValue("t"));
                curr.setDestinationId(Utils.parseInt(attributes.getValue("d")));
                curr.setStartLevel(Utils.parseInt(attributes.getValue("sl")));
                curr.setEndLevel(Utils.parseInt(attributes.getValue("el")));
                this.path[this.level].addChild(curr);
                this.path[++this.level] = curr;
            }
        }

        @Override
        public void endElement(String namespace, String localname, String type) throws SAXException {
            if (type.equals("n")) {
                --this.level;
            }
        }
    }

    private class RangeMapEditor
    extends BGUPanel {
        private int currentId;
        private BGTextField title;

        private RangeMapEditor() {
        }

        @Override
        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.title = new BGTextField();
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 5), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 3), 0, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    RangeMap rangeMap = new RangeMap();
                    rangeMap.setId(RangeMapEditor.this.currentId);
                    rangeMap.setTitle(RangeMapEditor.this.title.getText());
                    ServiceConfigRangeMap.this.rangeMapService.rangeMapUpdate(rangeMap);
                    RangeMapEditor.this.performActionClose();
                }
            };
            new AbstractBGUPanel.BGActionNew(e -> {
                this.currentId = -1;
                this.title.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit(e -> {
                RangeMap rangeMap = ServiceConfigRangeMap.this.table.model.getSelectedRow();
                if (rangeMap != null) {
                    this.currentId = rangeMap.getId();
                    this.title.setText(rangeMap.getTitle());
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete(e -> {
                RangeMap rangeMap = ServiceConfigRangeMap.this.table.model.getSelectedRow();
                if (rangeMap != null && BGSwingUtilites.confirmDelete("\u0433\u0440\u0443\u043f\u043f\u0443 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u0432")) {
                    ServiceConfigRangeMap.this.rangeMapService.rangeMapDelete(rangeMap.getId());
                    ServiceConfigRangeMap.this.setData();
                }
            });
        }
    }
}

