/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.common.Utils;

public class BGUTableSearchPopupListener
extends KeyAdapter {
    private Popup popup;
    private final BGUTable table;
    private TableRowSorter<TableModel> tableRowSorter;
    private String pattern;

    public BGUTableSearchPopupListener(BGUTable table) {
        this.table = table;
        this.table.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BGUTableSearchPopupListener.this.showSearchField();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BGUTableSearchPopupListener.this.hideSearchField();
            }
        });
        this.tableRowSorter = new TableRowSorter<TableModel>(table.getModel());
        this.table.setRowSorter(this.tableRowSorter);
    }

    private void showSearchField() {
        this.hideSearchField();
        if (Utils.notBlankString(this.pattern)) {
            Point p = this.table.getParent().getLocationOnScreen();
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(this.pattern);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.popup = popupFactory.getPopup(this.table, toolTip, p.x, p.y - toolTip.getPreferredSize().height);
            this.popup.show();
        }
    }

    private void hideSearchField() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void keyTyped(KeyEvent e) {
        block5: {
            char ch;
            block7: {
                block6: {
                    ch = e.getKeyChar();
                    if (ch != '\u001b') break block6;
                    this.pattern = null;
                    this.hideSearchField();
                    break block5;
                }
                if (!Character.isDefined(ch)) {
                    this.hideSearchField();
                    return;
                }
                if (ch != '\b') break block7;
                if (this.pattern != null && this.pattern.length() > 1) {
                    this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                    this.showSearchField();
                    break block5;
                } else if (this.pattern != null && this.pattern.length() == 1) {
                    this.hideSearchField();
                    this.pattern = null;
                    break block5;
                } else {
                    this.hideSearchField();
                    return;
                }
            }
            this.pattern = this.pattern == null ? "" + ch : this.pattern + ch;
        }
        this.showSearchField();
        this.find();
    }

    private void find() {
        if (Utils.isEmptyString(this.pattern)) {
            this.tableRowSorter.setRowFilter(null);
        } else {
            this.tableRowSorter.setRowFilter(RowFilter.regexFilter("(?i)" + this.pattern, new int[0]));
        }
    }
}

