/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JTextPane;
import javax.swing.border.AbstractBorder;
import javax.swing.text.BoxView;
import javax.swing.text.View;

public class LineNumberedBorder
extends AbstractBorder {
    public static int LEFT_SIDE = -2;
    public static int RIGHT_SIDE = -1;
    public static int RIGHT_JUSTIFY = 0;
    public static int LEFT_JUSTIFY = 1;
    private int lineNumberJustification = RIGHT_JUSTIFY;
    private int location = LEFT_SIDE;
    private static final Color defaultTextColor = Color.green.darker().darker().darker();
    private static final Color defaultDrawColor = Color.lightGray;
    private final Color drawColor;
    private final Color textColor;

    public LineNumberedBorder(int location, int justify, Color drawColor, Color textColor) {
        this.setLocation(location);
        this.setLineNumberJustification(justify);
        this.drawColor = drawColor;
        this.textColor = textColor;
    }

    public LineNumberedBorder(int location, int justify) {
        this(location, justify, defaultDrawColor, defaultTextColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof JTextPane) {
            JTextPane jtp = (JTextPane)c;
            View view = jtp.getUI().getRootView(jtp);
            BoxView box = (BoxView)view.getView(0);
            int width = this.lineNumberWidth(jtp.getFontMetrics(jtp.getFont()), box.getViewCount()) + 2;
            if (this.location == LEFT_SIDE) {
                insets.left = width;
            } else {
                insets.right = width;
            }
        }
        return insets;
    }

    public int getLineNumberJustification() {
        return this.lineNumberJustification;
    }

    public void setLineNumberJustification(int justify) {
        if (justify == RIGHT_JUSTIFY || justify == LEFT_JUSTIFY) {
            this.lineNumberJustification = justify;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int loc) {
        if (loc == RIGHT_SIDE || loc == LEFT_SIDE) {
            this.location = loc;
        }
    }

    private int lineNumberWidth(FontMetrics fm, int lineCount) {
        if (lineCount < 10) {
            return fm.charWidth('9') * 3;
        }
        return fm.charWidth('9') * (String.valueOf(lineCount).length() + 1);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setFont(g.getFont().deriveFont(1, 9.0f));
        FontMetrics fm = g.getFontMetrics();
        JTextPane jta = (JTextPane)c;
        double ybaseline = y;
        double yend = y + height + fm.getDescent();
        View view = jta.getUI().getRootView(jta);
        BoxView box = (BoxView)view.getView(0);
        int count = box.getViewCount();
        int lineWidth = this.lineNumberWidth(fm, count) + 5;
        int lnxstart = x + 1;
        lnxstart = this.location == LEFT_SIDE ? (this.lineNumberJustification == LEFT_JUSTIFY ? x : x + lineWidth - 1) : (this.lineNumberJustification == LEFT_JUSTIFY ? y + width - lineWidth : y + width);
        int length = String.valueOf(count + 1).length();
        Graphics2D gfx = (Graphics2D)g;
        gfx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gfx.setColor(this.drawColor);
        gfx.drawRect(x + 2, y - 1, lineWidth - 4, height + 2);
        gfx.setColor(this.textColor);
        Rectangle rect = new Rectangle(0, 12, 0, 0);
        for (int i = 0; i < count; ++i) {
            Rectangle s = (Rectangle)box.getChildAllocation(i, rect);
            if ((double)s.y < ybaseline) continue;
            if ((double)s.y > yend) break;
            if (this.lineNumberJustification == LEFT_JUSTIFY) {
                g.drawString(i + 1 + " ", lnxstart, s.y);
                continue;
            }
            String label = LineNumberedBorder.padLabel(i + 1, length, true);
            g.drawString(label, lnxstart - fm.stringWidth(label), s.y);
        }
    }

    private static String padLabel(int lineNumber, int length, boolean addSpace) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(lineNumber);
        for (int count = length - buffer.length(); count > 0; --count) {
            buffer.insert(0, ' ');
        }
        if (addSpace) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

