/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import ru.bitel.common.Utils;

public class PKCS7 {
    public static byte[] decode(InputStream input, InputStream certificate) throws SignatureException, IOException {
        CMSSignedData cms = null;
        try {
            PemReader pr = new PemReader((Reader)new InputStreamReader(input));
            PemObject po = pr.readPemObject();
            cms = new CMSSignedData(po.getContent());
        }
        catch (CMSException e) {
            throw new IOException("error parse CMS signed data", e);
        }
        byte[] content = (byte[])cms.getSignedContent().getContent();
        try {
            Store messageCertificates = cms.getCertificates();
            for (SignerInformation signer : cms.getSignerInfos().getSigners()) {
                Collection signerCertificates = messageCertificates.getMatches((Selector)signer.getSID());
                Iterator certIt = signerCertificates.iterator();
                X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
                if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certHolder))) continue;
                throw new SignatureException("verification signature failed");
            }
        }
        catch (Exception e) {
            throw new SignatureException("error verification signature", e);
        }
        return content;
    }

    public static String _sun_decode(InputStream input, InputStream certificate) throws IOException, GeneralSecurityException {
        return null;
    }

    protected static String _openssl_decode(InputStream input, InputStream certificate) throws IOException, InterruptedException {
        File certFile = File.createTempFile("bgbilling", String.valueOf(System.currentTimeMillis()));
        FileOutputStream out = new FileOutputStream(certFile);
        Utils.flush(certificate, out);
        ((OutputStream)out).close();
        String cmdstring = "/usr/bin/openssl smime -verify -inform PEM -nointern -certfile " + certFile.getAbsolutePath() + " -CAfile " + certFile.getAbsolutePath();
        Process cmd = Runtime.getRuntime().exec(cmdstring);
        OutputStream outStream = cmd.getOutputStream();
        Utils.flush(input, outStream);
        outStream.close();
        cmd.waitFor();
        InputStream in = cmd.getInputStream();
        String str = new String(Utils.readByBlock(in));
        in.close();
        cmd.destroy();
        return str;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        System.out.println("sun:\t" + PKCS7._sun_decode(new FileInputStream("/home/dimon/projects/yandex/request4.txt"), new FileInputStream("/home/dimon/projects/yandex/payment_center_2014.pem")));
        System.out.println("opnssl:\t" + PKCS7._openssl_decode(new FileInputStream("/home/dimon/projects/yandex/request4.txt"), new FileInputStream("/home/dimon/projects/yandex/payment_center_2014.pem")));
        System.out.println("bc:\t" + new String(PKCS7.decode(new FileInputStream("/home/dimon/projects/yandex/request4.txt"), new FileInputStream("/home/dimon/projects/yandex/payment_center_2014.pem")), "UTF-8"));
    }
}

