/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.bean.customer;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import ru.bitel.common.model.PeriodWithTime;

public class CustomerLink {
    private int contractId = 0;
    private long customerAccount = 0L;
    private int customerId = 0;
    private PeriodWithTime period = null;

    public CustomerLink() {
    }

    private CustomerLink(int contractId, long customerAccount, int customerId, PeriodWithTime period) {
        this.contractId = contractId;
        this.customerAccount = customerAccount;
        this.customerId = customerId;
        this.period = period;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    @XmlAttribute
    public long getCustomerAccount() {
        return this.customerAccount;
    }

    @XmlAttribute
    public int getCustomerId() {
        return this.customerId;
    }

    @XmlElement
    public PeriodWithTime getPeriod() {
        return this.period;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public void setCustomerAccount(long customerAccount) {
        this.customerAccount = customerAccount;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public void setPeriod(PeriodWithTime period) {
        this.period = period;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CustomerLink link = new CustomerLink();

        private Builder() {
        }

        public Builder setContractId(int contractId) {
            this.link.contractId = contractId;
            return this;
        }

        public Builder setCustomerAccount(long customerAccount) {
            this.link.customerAccount = customerAccount;
            return this;
        }

        public Builder setCustomerId(int customerId) {
            this.link.customerId = customerId;
            return this;
        }

        public Builder setPeriod(PeriodWithTime period) {
            this.link.period = period;
            return this;
        }

        public CustomerLink build() {
            return new CustomerLink(this.link.contractId, this.link.customerAccount, this.link.customerId, this.link.period);
        }
    }
}

