/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.ButtonTableCellEditor;
import bitel.billing.module.contract.BGTableForwardedMouseListener;
import bitel.billing.module.contract.ContractParameterTableRow;
import bitel.billing.module.contract.HistoryColumnCellRenderer;
import bitel.billing.module.contract.MultiEditor;
import bitel.billing.module.contract.MultiRenderer;
import bitel.billing.module.contract.ParamNameRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamPanel;

public class TableContractParameters
extends BGTable {
    private ParamTableModel tableModel = new ParamTableModel();
    private ContractParamPanel parentContractParamPanel;

    public TableContractParameters(ContractParamPanel contractParamPanel) {
        this.parentContractParamPanel = contractParamPanel;
        this.setModel(this.tableModel);
        this.setSelectionMode(0);
        this.tableModel.setColumnCount(3);
        this.setColumnProperties(0, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, -1, -1);
        this.setColumnProperties(1, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 600, 600, -1);
        this.setColumnProperties(2, " ", 20, 20, 20);
        TableColumn column = this.getColumnModel().getColumn(0);
        column.setCellRenderer(new ParamNameRenderer());
        column = this.getColumnModel().getColumn(1);
        column.setCellRenderer(new MultiRenderer(this));
        column.setCellEditor(new MultiEditor());
        column = this.getColumnModel().getColumn(2);
        column.setCellEditor(new ButtonTableCellEditor());
        column.setCellRenderer(new HistoryColumnCellRenderer());
        this.addMouseListener(new BGTableForwardedMouseListener(this));
        this.addMouseMotionListener(new BGTableForwardedMouseListener(this));
    }

    public void setRowsData(Node parameters, String parameterType, boolean filled) {
        this.tableModel.removeAllRows();
        if (parameters != null && parameters.hasChildNodes()) {
            NodeList list = parameters.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Element node = (Element)list.item(i);
                ContractParameterTableRow row = new ContractParameterTableRow(node);
                if (parameterType != null && !node.getAttribute("pt").equals(parameterType)) continue;
                String value = node.getAttribute("value");
                if (!row.isAlwaysVisible() && filled && (value == null || value.isEmpty())) continue;
                this.tableModel.addRow(row);
            }
        }
    }

    public ContractParamPanel getParentContractParamPanel() {
        return this.parentContractParamPanel;
    }

    public class ParamTableModel
    extends DefaultTableModel {
        private List<ContractParameterTableRow> data = new ArrayList<ContractParameterTableRow>();

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            int pt = ((ContractParameterTableRow)TableContractParameters.this.tableModel.getValueAt(rowIndex, 0)).getParameterType();
            return columnIndex == 1 && pt == 1 || columnIndex == 2;
        }

        public void addRow(ContractParameterTableRow paramRowData) {
            this.data.add(paramRowData);
            super.addRow(new Vector());
        }

        @Override
        public void removeRow(int row) {
            this.data.remove(row);
            super.removeRow(row);
        }

        public void removeAllRows() {
            this.data.clear();
            super.setRowCount(0);
        }

        @Override
        public Object getValueAt(int row, int column) {
            ContractParameterTableRow paramRowData = this.data.get(row);
            switch (column) {
                case 0: {
                    return paramRowData;
                }
                case 1: {
                    return paramRowData.getValue();
                }
                case 2: {
                    return paramRowData.getHistoryValue();
                }
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            ContractParameterTableRow paramRowData = this.data.get(row);
            if (column == 1) {
                paramRowData.setValue(String.valueOf(aValue));
                this.fireTableCellUpdated(row, column);
            } else {
                super.setValueAt(aValue, row, column);
            }
        }
    }
}

