/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.table.TableModel;
import ru.bitel.bgbilling.kernel.contract.pattern.common.bean.RowData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.PatternData;
import ru.bitel.common.Utils;

public class PatternScriptTabPanel
extends PatternBaseTabPanel {
    private static final String SCRIPT = "script";
    private TableModel tableModel = new TableModel(TableModel.class.getName());
    private BGUTable table = new BGUTable((javax.swing.table.TableModel)((Object)this.tableModel));

    public PatternScriptTabPanel(Document moduleDoc) {
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setMouseListener(this.table, 0);
    }

    @Override
    public void setData(PatternData patternData) {
        this.tableModel.setData(patternData.getScriptList().stream().map(a -> new RowData().setId(a.getId()).setTitle(a.getTitle())).toList());
    }

    @Override
    public void setPatternData(ContractPattern contractPattern) {
        List<Integer> scriptList = contractPattern.getScriptList();
        this.tableModel.getRows().forEach(r -> r.setValue(scriptList.contains(r.getId())));
    }

    @Override
    public void resetData() {
        this.tableModel.getRows().forEach(e -> e.setValue(false));
    }

    @Override
    public boolean setRequestData(Request request) {
        ArrayList<Integer> scriptList = new ArrayList<Integer>();
        for (RowData rowData : this.tableModel.getRows()) {
            int id = rowData.getId();
            boolean value = rowData.getValue();
            if (!value) continue;
            scriptList.add(id);
        }
        request.setAttribute(SCRIPT, Utils.toString(scriptList));
        return true;
    }
}

