/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.contract.bean.ContractBalanceUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u0411\u0430\u043b\u0430\u043d\u0441")
public class ActionBalance
extends AbstractAction {
    public ActionBalance() {
        super("contract");
    }

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws Exception {
        this.setResultParam("pageTitle", this.getPageTitle(3, this.moduleName));
        this.setResultParam("jspPage", "contract/balance_body.jsp");
    }

    @WebOperation(title="\u0421\u0432\u043e\u0434\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f")
    public void balanceInfo() throws Exception {
        List<String> messages;
        LocalDate now = LocalDate.now();
        List<Integer> contractIds = Arrays.asList(this.contractId);
        ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.con, (Integer)this.contractId);
        ConvergenceBalance convergenceBalance = convergenceBalanceManager.getBalance(this.context.getConnectionSet(), this.contractId, System.currentTimeMillis());
        HashMap statusMap = new HashMap();
        Utils.stringToPairs(Setup.getSetup().get("contract.status.list", "0:\u0410\u043a\u0442\u0438\u0432\u0435\u043d;1:\u0412 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438;2:\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d;3:\u0417\u0430\u043a\u0440\u044b\u0442;4:\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d;5:\u0412 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438"), ";", ":").forEach(a -> statusMap.put(Utils.parseInt(a[0]), a[1]));
        this.setResultParam("balanceDatetime", new Date());
        this.setResultParam("balanceSum", convergenceBalance.getBalance());
        this.setResultParam("contractRuntime", contractRuntime);
        this.setResultParam("contractStatusMap", statusMap);
        Period period = new Period(now.withDayOfMonth(1).minusMonths(1L), now);
        ContractBalanceUtils.WebBalanceData webBalanceData = ContractBalanceUtils.getWebBalanceData((Connection)this.con, (int)this.contractId, (Period)period, (int)3);
        ArrayList<Object[]> accounts = new ArrayList<Object[]>();
        this.addAccountData(now, contractIds, accounts);
        this.addAccountData(now.minusMonths(1L), contractIds, accounts);
        this.setResultParam("balanceAccounts", accounts);
        this.setResultParam("webBalanceData", webBalanceData);
        if (webBalanceData.getIndependentSubContracts().size() > 0) {
            this.setResultParam("has_independent_subs", "1");
        }
        if ((messages = webBalanceData.getEvent().getMessages()).size() > 0) {
            this.setResultParam("messages", messages);
        }
        this.setResultParamReceiptLink();
        this.requestDispatcher(this.moduleName, "balance_data");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u0438")
    public void payments() throws Exception {
        int periodMonth = this.req.getInt("periodMonth", 6);
        try (PaymentTypeDao paymentTypeDao = new PaymentTypeDao(this.con);){
            LocalDate now = LocalDate.now();
            Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
            Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate(contractFromDate), now);
            SearchResult<Payment> searchResult = new SearchResult<Payment>(period, null);
            new PaymentDao(this.con).searchPaymentList(searchResult, Arrays.asList(this.contractId));
            List<Payment> payments = searchResult.getList();
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Payment payment : payments) {
                int typeId = payment.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.setResultParam("balancePeriod", period);
            this.setResultParam("balancePayments", payments);
            this.setResultParam("balancePaymentTypes", paymentTypeDao.getTypeMapByIds(typeIds));
        }
        this.setResultParamReceiptLink();
        this.requestDispatcher(this.moduleName, "balance_payments");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u044f")
    public void charges() throws Exception {
        int periodMonth = this.req.getInt("periodMonth", 6);
        try (ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.con);){
            LocalDate now = LocalDate.now();
            Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
            Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate(contractFromDate), now);
            SearchResult<Charge> searchResult = new SearchResult<Charge>(period, null);
            new ChargeDao(this.con).searchChargeList(searchResult, Arrays.asList(this.contractId));
            List<Charge> charges = searchResult.getList();
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Charge charge : charges) {
                int typeId = charge.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.setResultParam("balancePeriod", period);
            this.setResultParam("balanceCharges", charges);
            this.setResultParam("balanceChargeTypes", chargeTypeDao.getTypeMapByIds(typeIds));
        }
        this.setResultParamReceiptLink();
        this.requestDispatcher(this.moduleName, "balance_charges");
    }

    @WebOperation(title="\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430")
    public void accounts() throws Exception {
        LocalDate periodFrom;
        ArrayList<Object[]> accounts = new ArrayList<Object[]>();
        List<Integer> contractIds = Arrays.asList(this.contractId);
        int periodMonth = this.req.getInt("periodMonth", 6);
        LocalDate now = LocalDate.now();
        Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
        Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate(contractFromDate), now);
        LocalDate localDate = periodFrom = periodMonth == 0 ? period.getLocalDateFrom().withDayOfMonth(1).minusDays(1L) : period.getLocalDateFrom();
        while (now.isAfter(periodFrom)) {
            this.addAccountData(now, contractIds, accounts);
            now = now.minusMonths(1L);
        }
        this.setResultParam("balancePeriod", period);
        this.setResultParam("balanceAccounts", accounts);
        this.requestDispatcher(this.moduleName, "balance_accounts");
    }

    @WebOperation(title="\u0420\u0435\u0437\u0435\u0440\u0432\u044b")
    public void reserves() throws Exception {
        int periodMonth = this.req.getInt("periodMonth", 6);
        try (ReserveTypeDao reserveTypeDao = new ReserveTypeDao(this.con);){
            ReserveDao reserveDao = new ReserveDao(this.con);
            LocalDate now = LocalDate.now();
            Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
            Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate(contractFromDate), now);
            List<Reserve> reserves = reserveDao.getReserveList(this.contractId, period, 2);
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Reserve reserve : reserves) {
                int typeId = reserve.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.setResultParam("balancePeriod", period);
            this.setResultParam("balanceReserves", reserves);
            this.setResultParam("balanceReserveTypes", reserveTypeDao.getTypeMapByIds(typeIds));
        }
        this.requestDispatcher(this.moduleName, "balance_reserves");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebOperation(title="\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432")
    public void distributeBalance() throws Exception {
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);
             BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            Contract contract = (Contract)contractDao.get(this.contractId);
            if (contract == null) {
                this.setWebErrorMessage(new ActionMessage("balanceRoot", "close", "balanceQuery", "\u041e\u0428\u0418\u0411\u041a\u0410: \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + this.contractId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                return;
            }
            boolean creditMode = contract.getBalanceMode() == 0;
            BigDecimal debt = creditMode ? balanceUtils.getSaldo(new Date(), this.contractId) : balanceUtils.getBalance(LocalDate.now(), this.contractId);
            this.setResultParam("freeAmount", debt);
            int commit = this.req.getInt("commit", 0);
            if (commit > 0) {
                Date date = new Date();
                BigDecimal summa = BigDecimal.ZERO;
                ArrayList<Payment> payments = new ArrayList<Payment>();
                ArrayList<Charge> charges = new ArrayList<Charge>();
                int paymentTransferType = this.setup.getInt("transfer.payment.type", 0);
                int chargeTransferType = this.setup.getInt("transfer.charge.type", 0);
                if (paymentTransferType == 0 || chargeTransferType == 0) {
                    this.setWebErrorMessage(new ActionMessage("balanceRoot", "close", "balanceQuery", "\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430 \u0441\u0440\u0435\u0434\u0441\u0442\u0432. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438."));
                    return;
                }
                for (Contract contract2 : contractDao.getSubContracts(this.contractId, 1)) {
                    BigDecimal amount = this.req.getBigDecimal(String.valueOf(contract2.getId()), BigDecimal.ZERO);
                    if ((summa = summa.add(amount)).compareTo(debt) > 0) {
                        this.setWebErrorMessage(new ActionMessage("balanceRoot", "close", "balanceQuery", "\u041e\u0428\u0418\u0411\u041a\u0410: \u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0441\u0443\u043c\u043c\u044b \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u044e\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!"));
                        return;
                    }
                    if (amount.compareTo(BigDecimal.ZERO) < 0) {
                        this.setWebErrorMessage(new ActionMessage("balanceRoot", "close", "balanceQuery", "\u041e\u0428\u0418\u0411\u041a\u0410: \u0412\u0432\u0435\u0434\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 \u043d\u0443\u043b\u044f!"));
                        return;
                    }
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    payments.add(Payment.builder().setTypeId(paymentTransferType).setContractId(contract2.getId()).setDate(date).setSum(amount).setComment("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0441 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430").build());
                    charges.add(Charge.builder().setTypeId(chargeTransferType).setContractId(this.contractId).setDate(date).setSum(amount).setComment("\u041f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract2.getTitle() + " ( " + contract2.getComment() + " )").build());
                }
                ChargeDao chargeDao = new ChargeDao(this.con);
                for (Charge charge : charges) {
                    chargeDao.update(charge);
                    balanceUtils.updateBalance(date, this.contractId);
                    this.context.publishAfterCommit(new ChargeEvent(0, charge));
                    this.context.publishAfterCommit(new ContractBalanceChangedEvent(charge.getContractId(), 4, charge.getSum()));
                }
                ServerUtils.commitConnection((Connection)this.con);
                PaymentDao paymentDao = new PaymentDao(this.con);
                for (Payment payment : payments) {
                    paymentDao.update(payment);
                    balanceUtils.updateBalance(date, payment.getContractId());
                    this.context.publishAfterCommit(new PaymentEvent(0, payment));
                    this.context.publishAfterCommit(new ContractBalanceChangedEvent(payment.getContractId(), 3, payment.getSum()));
                }
                balanceUtils.updateBalance(date, this.contractId);
                debt = debt.subtract(summa);
            }
            this.setResultParam("freeAmount", debt);
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (Contract subContract : contractDao.getSubContracts(this.contractId, 1)) {
                boolean subCreditMode = subContract.getBalanceMode() == 0;
                Object[] str = new Object[]{subContract.getId(), subContract.getTitle(), subContract.getComment(), subCreditMode ? balanceUtils.getSaldo(new Date(), subContract.getId()) : balanceUtils.getBalance(new Date(), subContract.getId())};
                list.add(str);
            }
            this.setResultParam("subContracts", list);
        }
        this.requestDispatcher(this.moduleName, "balance_distribute");
    }

    private void setWebErrorMessage(ActionMessage message) {
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    private void addAccountData(LocalDate localDate, List<Integer> contractIds, List<Object[]> accounts) throws Exception {
        String query = "SELECT t2.title, t1.summa FROM contract_account AS t1 LEFT JOIN service AS t2 ON t1.sid=t2.id WHERE cid IN ( " + Utils.toString(contractIds) + " ) AND mm=? AND yy=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, localDate.getMonthValue());
            ps.setInt(2, localDate.getYear());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Object[] str = new Object[3];
                    BigDecimal value = rs.getBigDecimal(2);
                    String title = rs.getString(1);
                    str[0] = TimeUtils.convertLocalDateToDate(localDate);
                    str[1] = title == null ? "?" : title;
                    str[2] = String.valueOf(value);
                    accounts.add(str);
                }
            }
        }
    }

    private void setResultParamReceiptLink() {
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions("ru.bitel.bgbilling.kernel.contract.basic.server.action.web.ActionBalance.receipt_link", true)) {
            try {
                String className = XMLUtils.selectText(extension.getElement(), "//extension/instance/@class");
                Object cashcheckReceiptLinkSearch = Class.forName(className).getConstructor(Connection.class).newInstance(this.con);
                this.setResultParam("receipt_link", cashcheckReceiptLinkSearch);
            }
            catch (Exception e) {}
        }
    }
}

