/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.function;

import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGThrowingRunnable;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.common.function.ThrowingBiConsumer;
import ru.bitel.common.function.ThrowingConsumer;
import ru.bitel.common.function.ThrowingRunnable;
import ru.bitel.common.function.ThrowingSupplier;

public class Async<T>
implements Supplier<T> {
    private final CompletableFuture<T> delegate;
    private static final int parallelism = Math.min(Runtime.getRuntime().availableProcessors() * 16, 80);
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(4, parallelism, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), new ThreadPoolExecutor.CallerRunsPolicy());

    private Async(CompletableFuture<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() throws RuntimeException {
        try {
            return this.delegate.join();
        }
        catch (CompletionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new BGRuntimeException(ex);
        }
        catch (Exception ex) {
            throw new BGRuntimeException(ex);
        }
    }

    public CompletableFuture<T> getFuture() {
        return this.delegate;
    }

    public static <T> Async<T> of(ThrowingSupplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        return new Async<T>(CompletableFuture.supplyAsync(supplier, EXECUTOR));
    }

    public static Async<Void> of(ThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        return new Async<Void>(CompletableFuture.runAsync(runnable, EXECUTOR));
    }

    public static Async<Void> ofWithTry(BGThrowingRunnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        return new Async<Void>(CompletableFuture.runAsync((Runnable)runnable, EXECUTOR));
    }

    public static <T> Async<T> uncompleted() {
        return new Async(new CompletableFuture());
    }

    public static <T> Async<T> completed(T t) {
        return new Async<T>(CompletableFuture.completedFuture(t));
    }

    public Async<Void> thenAccept(ThrowingConsumer<? super T> action) {
        return new Async<Void>((CompletableFuture<Void>)this.delegate.thenAccept((Consumer)Objects.requireNonNull(action)));
    }

    public Async<Void> thenSwing(ThrowingConsumer<? super T> action) {
        return new Async<Void>((CompletableFuture<Void>)this.delegate.thenAccept(t -> SwingUtilities.invokeLater(() -> action.accept(Objects.requireNonNull(t)))));
    }

    public Async<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return new Async<T>(this.delegate.exceptionally(fn));
    }

    public <U> Async<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return new Async<T>(this.delegate.handle(fn));
    }

    public boolean complete(T value) {
        return this.delegate.complete(value);
    }

    public boolean completeExceptionally(Throwable ex) {
        return this.delegate.completeExceptionally(ex);
    }

    public <U> Async<Void> thenAcceptBoth(Async<U> async, ThrowingBiConsumer<T, U> c) {
        return new Async<Void>((CompletableFuture<Void>)this.delegate.thenAcceptBoth(async.delegate, (BiConsumer)c));
    }

    public <U> Async<Void> thenSwingBoth(Async<U> async, ThrowingBiConsumer<T, U> c) {
        return new Async<Void>((CompletableFuture<Void>)this.delegate.thenAcceptBoth(async.delegate, (t, u) -> SwingUtilities.invokeLater(() -> c.accept(Objects.requireNonNull(t), Objects.requireNonNull(u)))));
    }

    static {
        EXECUTOR.prestartCoreThread();
    }
}

