/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.WebRequestCounter;
import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.logon.ContractLogonLast;
import bitel.billing.server.contract.logon.LogonManager;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;

public class ActionWebRequestLimit
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        ContractLogonLast contractLogonLast;
        int lim;
        int mode;
        if (this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        WebRequestCounter counter = new WebRequestCounter(this.setup);
        if ("1".equals(this.getParameter("reset"))) {
            counter.unblock(this.cid);
        }
        if ((mode = this.getIntParameter("mode", 0)) > 0) {
            switch (mode) {
                case 2: {
                    counter.updateRequestCount(this.cid, 0);
                    break;
                }
                case 3: {
                    counter.updateRequestCount(this.cid, this.getIntParameter("limit", -1));
                    break;
                }
                default: {
                    counter.updateRequestCount(this.cid, -1);
                }
            }
        }
        int configLimit = counter.getRequestLimit();
        int limit = counter.getRequestLimit(this.cid);
        int count = counter.getRequestCount(this.cid);
        int n = lim = limit < 0 ? configLimit : limit;
        boolean status = lim == 0 ? true : count < lim;
        Element limitEl = this.createElement(this.rootNode, "web_limit");
        limitEl.setAttribute("configLimit", String.valueOf(configLimit));
        limitEl.setAttribute("limit", String.valueOf(limit));
        limitEl.setAttribute("count", String.valueOf(count));
        limitEl.setAttribute("status", status ? "0" : "1");
        LogonManager logonManager = new LogonManager(this.con);
        if ("1".equals(this.getParameter("unlock"))) {
            logonManager.deleteContractLogonLast(this.cid);
        }
        if ((contractLogonLast = logonManager.getContractLogonLast(this.cid)) != null) {
            Element lastLogonEl = this.createElement(this.rootNode, "lastLogon");
            lastLogonEl.setAttribute("ip", contractLogonLast.getRemoteIP());
            lastLogonEl.setAttribute("counter", String.valueOf(contractLogonLast.getCounter()));
            lastLogonEl.setAttribute("datetime", TimeUtils.format((Date)contractLogonLast.getDateTime(), (String)"dd.MM.yyyy HH:mm:ss"));
        }
    }
}

