/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractRemoveRule;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractRemoveRuleDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ConverterRemoveContractRules
extends AbstractBGConverter {
    @Override
    public void runConverter(Connection connection) {
        boolean needConvert = Utils.maskBlank(ServerUtils.getSetupValue((Connection)connection, (String)"contractAutoRemoveRules"), "0").equals("0");
        if (!needConvert) {
            return;
        }
        this.getLogger().info("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u0438\u043b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        try {
            ContractRemoveRuleDao removeRuleDao = new ContractRemoveRuleDao(connection);
            ArrayList<ContractRemoveRule> convertedFromOldRules = new ArrayList<ContractRemoveRule>(this.getRemoveRulesByTimeType(connection));
            convertedFromOldRules.addAll(this.getRemoveRulesByBalance(connection));
            this.getLogger().info("\u0412\u0441\u0435\u0433\u043e \u043f\u0440\u0430\u0432\u0438\u043b \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: {}", (Object)convertedFromOldRules.size());
            for (ContractRemoveRule convertedRule : convertedFromOldRules) {
                removeRuleDao.update(convertedRule);
            }
            ServerUtils.setSetupValue((Connection)connection, (String)"contractAutoRemoveRules", (String)"1");
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private List<ContractRemoveRule> getRemoveRulesByTimeType(Connection connection) throws SQLException {
        ArrayList<ContractRemoveRule> l = new ArrayList<ContractRemoveRule>();
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery("select * from contract_delete_time");){
            while (rs.next()) {
                l.add(this.createContractRemoveRuleByRS(rs, ContractRemoveRule.RemoveRuleType.TIME));
            }
        }
        this.getLogger().info("\u041f\u0440\u0430\u0432\u0438\u043b \u0434\u043b\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0441 \u0442\u0438\u043f\u043e\u043c \"\u041f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438\" ={}", (Object)l.size());
        return l;
    }

    private List<ContractRemoveRule> getRemoveRulesByBalance(Connection connection) throws SQLException {
        ArrayList<ContractRemoveRule> l = new ArrayList<ContractRemoveRule>();
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery("select * from contract_delete_money");){
            while (rs.next()) {
                l.add(this.createContractRemoveRuleByRS(rs, ContractRemoveRule.RemoveRuleType.BALANCE));
            }
        }
        this.getLogger().info("\u041f\u0440\u0430\u0432\u0438\u043b \u0434\u043b\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0441 \u0442\u0438\u043f\u043e\u043c \"\u041f\u043e \u0441\u0443\u043c\u043c\u0435\" ={}", (Object)l.size());
        return l;
    }

    private ContractRemoveRule createContractRemoveRuleByRS(ResultSet rs, ContractRemoveRule.RemoveRuleType type) throws SQLException {
        ContractRemoveRule removeRule = new ContractRemoveRule();
        removeRule.setRemoveRuleType(type);
        removeRule.setTitle(rs.getString("name"));
        removeRule.setComment(rs.getString("comment"));
        removeRule.setDateFrom(TimeUtils.convertDateToLocalDate(TimeUtils.convertSqlDateToDate(rs.getDate("date1"))));
        removeRule.setDateTo(TimeUtils.convertDateToLocalDate(TimeUtils.convertSqlDateToDate(rs.getDate("date2"))));
        removeRule.setTimeCount(rs.getInt("time"));
        List<Integer> groups = Utils.toIntegerList(Utils.maskToEnum(Long.parseLong(rs.getString("gr"))));
        removeRule.setLabels(groups.stream().mapToInt(gr -> gr + 2).boxed().toList());
        String params = rs.getString("params");
        Map<String, String> paramsMap = this.getParameters(params);
        removeRule.setStatuses(Utils.toIntegerList(Utils.maskNull(paramsMap.get("statuses"))));
        if (type.equals((Object)ContractRemoveRule.RemoveRuleType.BALANCE)) {
            removeRule.setBalance(BigDecimal.valueOf(rs.getInt("money")));
            removeRule.setTypeRuleRemoveByTime(ContractRemoveRule.TypeRuleRemoveByTime.getTypeRule(Utils.parseInt(paramsMap.get("typePeriod"), 0)));
        } else {
            removeRule.setTypeRuleRemoveByTime(ContractRemoveRule.TypeRuleRemoveByTime.MONTH);
        }
        return removeRule;
    }

    private Map<String, String> getParameters(String params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (Utils.notBlankString(params)) {
            StringTokenizer st = new StringTokenizer(params, "\r\n");
            while (st.hasMoreTokens()) {
                String keyValue = st.nextToken();
                if (!keyValue.contains("=")) continue;
                String[] values = keyValue.split("=");
                paramsMap.put(values[0], values[1]);
            }
        }
        return paramsMap;
    }
}

