/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import ru.bitel.common.Utils;

public class AddressUtil {
    public static String ADDRESS_HOUSE_ENTRANCE_RANGE = "entranceRange";
    public static String ADDRESS_HOUSE_ENTRANCE = "entrance";

    public static String getHouseFrac(String value) {
        String result = "";
        if (value != null && !value.isEmpty()) {
            for (int index = 0; index < value.length(); ++index) {
                if (Character.isDigit(value.charAt(index))) continue;
                result = value.substring(index);
                break;
            }
        }
        return result;
    }

    public static String getHouse(String value) {
        StringBuilder buf = new StringBuilder("");
        if (value != null && !value.isEmpty()) {
            char ch;
            for (int index = 0; index < value.length() && Character.isDigit(ch = value.charAt(index)); ++index) {
                buf.append(ch);
            }
        }
        return buf.toString();
    }

    public static String getHouse(String house, String frac) {
        StringBuilder houseBuf = new StringBuilder();
        if (house != null) {
            houseBuf.append(house.trim());
        }
        if (frac != null) {
            String fracValue = frac.trim();
            if (!fracValue.isEmpty() && Character.isDigit(fracValue.charAt(0))) {
                houseBuf.append("/");
            }
            houseBuf.append(fracValue);
        }
        return houseBuf.toString();
    }

    public static int getEntrance(String config, int apartment) {
        int entrance = -1;
        String[] params = config.split(";");
        for (int i = 0; i < params.length; ++i) {
            String[] param = params[i].split("/");
            String[] range = param[0].split("-");
            if (range.length <= 1) continue;
            int first = Utils.parseInt(range[0], -1);
            int end = Utils.parseInt(range[1], -1);
            if (apartment < first || apartment > end) continue;
            int firstEntrance = Utils.parseInt(param[2]);
            int apartmentInEntrance = Utils.parseInt(param[1]);
            int entranceCoiunt = end / apartmentInEntrance;
            for (int j = firstEntrance; j <= entranceCoiunt; ++j) {
                if (apartment >= first && apartment < first + apartmentInEntrance) {
                    entrance = j;
                    return entrance;
                }
                first += apartmentInEntrance;
            }
        }
        return entrance;
    }

    public static int getFloor(String config, int apartment) {
        int floor = -100;
        String[] params = config.split(";");
        for (int i = 0; i < params.length; ++i) {
            int j;
            String[] param = params[i].split("/");
            String[] range = param[0].split("-");
            if (range.length <= 1) continue;
            int first = Utils.parseInt(range[0], -1);
            int end = Utils.parseInt(range[1], -1);
            if (apartment < first || apartment > end) continue;
            int firstFloor = Integer.valueOf(param[2]);
            int endFloor = Integer.valueOf(param[3]);
            int apartmentInFloor = Integer.valueOf(param[1]);
            int apartmentInEntrance = endFloor * apartmentInFloor;
            int countEntrance = end / apartmentInEntrance;
            for (j = 1; j <= countEntrance; ++j) {
                first = j * apartmentInEntrance - apartmentInEntrance + 1;
                end = j * apartmentInEntrance;
                if (apartment >= first && apartment <= end) break;
            }
            for (j = firstFloor; j <= endFloor; ++j) {
                if (apartment >= first && apartment < first + apartmentInFloor) {
                    floor = j;
                    return floor;
                }
                first += apartmentInFloor;
            }
        }
        return floor;
    }
}

