/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGToggleButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.common.XMLUtils;

public class ContractAutopaymentEnabled
extends PatternModuleTabPanel.PatternModuleTabPanelItem {
    private String moduleName = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private Button onButton = new Button("\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d", "on", true, this.buttonGroup);
    private Button offButton = new Button("\u0417\u0410\u041f\u0420\u0415\u0429\u0415\u041d", "off", false, this.buttonGroup);

    public ContractAutopaymentEnabled(String moduleName, int moduleId) {
        super((LayoutManager)new GridBagLayout(), moduleId);
        this.moduleName = moduleName;
        this.add((Component)this.onButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.offButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean isItemEnabled() {
        return true;
    }

    @Override
    protected void setData(Element element) {
        try {
            Element paymasterElement = XMLUtils.selectElement(element, "data/modules/" + this.moduleName + "[@mid=" + this.getModuleId() + "]");
            String enabled = "off";
            if (paymasterElement != null) {
                enabled = paymasterElement.getAttribute("enabled");
            }
            this.onButton.setSelected("on".equals(enabled));
            this.offButton.setSelected("off".equals(enabled));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void serialise(Element element) {
        Element module = XMLUtils.createElement(element, this.moduleName);
        module.setAttribute("mid", String.valueOf(this.getModuleId()));
        module.setAttribute("enabled", String.valueOf(this.buttonGroup.getSelection().getActionCommand()));
    }

    @Override
    public String getTitle() {
        return "\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436";
    }

    class Button
    extends BGToggleButton {
        public Button(String text, String actionCommand, boolean selected, ButtonGroup buttonGroup) {
            this.setText(text);
            this.setActionCommand(actionCommand);
            this.setSelected(selected);
            buttonGroup.add(this);
        }
    }
}

