/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.server.service;

import jakarta.jws.WebService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.common.bean.BGWebLimitHandler;
import ru.bitel.bgbilling.kernel.admin.web.common.bean.WebMenuItem;
import ru.bitel.bgbilling.kernel.admin.web.common.bean.WebMenuModuleItem;
import ru.bitel.bgbilling.kernel.admin.web.common.service.BGWebService;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.BGWebLimitDefaultHandler;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebContractSearchModule;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebUtils;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.Module;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.BGHandlerParameter;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.web.common.service.BGWebService")
public class BGWebServiceImpl
extends AbstractService
implements BGWebService {
    @Override
    public List<WebMenuItem> webMenuList(boolean loadCount) throws BGException {
        return this.tryReturn(() -> {
            WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());
            Map<Integer, Integer> countMap = webMenuDao.getContractCount();
            List<WebMenuItem> list = webMenuDao.list();
            list.forEach(a -> a.setCount(Optional.ofNullable((Integer)countMap.get(a.getId())).map(b -> (int)b).orElse(0)));
            return list;
        });
    }

    @Override
    public List<WebMenuItem> webMenuContractList(int contractId) throws BGException {
        return this.tryReturn(() -> {
            ArrayList<WebMenuItem> list = new ArrayList<WebMenuItem>();
            WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());
            int webMenuId = webMenuDao.getWebMenuIdForContract(contractId);
            for (WebMenuItem webMenuItem : webMenuDao.list()) {
                webMenuItem.setSelected(webMenuId == webMenuItem.getId());
                list.add(webMenuItem);
            }
            WebMenuItem webMenuItem = WebMenuItem.builder().setId(-1).setSelected(webMenuId == -1).setTitle("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e").build();
            list.add(0, webMenuItem);
            return list;
        });
    }

    @Override
    public WebMenuItem webMenuInfoUpdate(WebMenuItem webMenuItem) throws BGException {
        return this.tryReturn(() -> new WebMenuDao(this.getConnection()).updateInfo(webMenuItem));
    }

    @Override
    public WebMenuItem webMenuInfoGet(int webMenuItemId) throws BGException {
        return this.tryReturn(() -> (WebMenuItem)new WebMenuDao(this.getConnection()).get(webMenuItemId));
    }

    @Override
    public void setWebMenuIdForContract(int webMenuItemId, int contractId) throws BGException {
        this.tryCall(() -> new WebMenuDao(this.getConnection()).setWebMenuIdForContract(webMenuItemId, contractId));
    }

    @Override
    public boolean setWebMenuIdForContracts(int webMenuItemId, List<Integer> contractIds) throws BGException {
        return this.tryReturn(() -> {
            WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());
            for (Integer contractId : contractIds) {
                webMenuDao.setWebMenuIdForContract(webMenuItemId, contractId);
            }
            return true;
        });
    }

    @Override
    public void webMenuDataUpdate(int webMenuItemId, String webMenuItemData) throws BGException {
        this.tryCall(() -> new WebMenuDao(this.getConnection()).updateData(webMenuItemId, webMenuItemData));
    }

    @Override
    public String webMenuDataGet(int webMenuItemId) throws BGException {
        return this.tryReturn(() -> new WebMenuDao(this.getConnection()).getData(webMenuItemId));
    }

    @Override
    public void webMenuDataDelete(int webMenuItemId) throws BGException {
        this.tryCall(() -> new WebMenuDao(this.getConnection()).deleteData(webMenuItemId));
    }

    @Override
    public WebMenuModuleItem[] webMenuModuleItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        Connection con = this.getConnection();
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            try {
                String packServer = module.getInstalledModule().getPackageServer();
                Class<?> result = Class.forName(packServer + ".Module");
                Class<WebMenuBase> menuBaseClass = result.asSubclass(WebMenuBase.class);
                WebMenuBase menuBase = menuBaseClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (MenuItem menuItem : menuBase.getWebMenuItems(con, module.getName(), module.getId(), true)) {
                    WebMenuModuleItem item = new WebMenuModuleItem().setModuleId(module.getId()).setModuleName(module.getName()).setModuleTitle(module.getTitle()).setAction(menuItem.getAction()).setTitle(menuItem.getTitle()).setIcon(menuItem.getIcon()).setCssClass(menuItem.getCssClass()).setDescription(menuItem.getDescription());
                    list.add(item);
                }
            }
            catch (Exception exception) {
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public WebMenuModuleItem[] webMenuKernelItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        BGInstalledModule kernel = new BGInstalledModule();
        kernel.setType(ComponentType.MODULE);
        kernel.setPackageServer(Module.class.getPackage().getName());
        kernel.setName("contract");
        Element extension = kernel.getServerExtensionMap().get(WebMenu.class.getName());
        if (extension != null) {
            for (Element itemElement : XMLUtils.selectElements(extension, "item")) {
                String moduleName = itemElement.getAttribute("module");
                WebMenuModuleItem item = new WebMenuModuleItem();
                item.setModuleId(0);
                item.setModuleName(moduleName.isEmpty() ? "contract" : moduleName);
                item.setModuleTitle("\u042f\u0434\u0440\u043e");
                item.setAction(itemElement.getAttribute("action"));
                item.setTitle(itemElement.getAttribute("titleDefault"));
                list.add(item);
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public WebMenuModuleItem[] webMenuPluginItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions(WebMenu.class.getName(), false)) {
            if (extension == null) continue;
            for (Element itemElement : XMLUtils.selectElements(extension.getElement(), "item")) {
                WebMenuModuleItem item = new WebMenuModuleItem().setModuleId(0).setModuleName(extension.getPlugin().getId()).setModuleTitle(extension.getPlugin().getName()).setAction(itemElement.getAttribute("action")).setTitle(itemElement.getAttribute("titleDefault"));
                list.add(item);
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public JSONObject webActionOperations() throws BGException {
        return WebUtils.getActionOperations();
    }

    @Override
    public List<KeyValue> getIconDirs() throws BGException {
        return this.tryReturn(() -> {
            ArrayList list = new ArrayList();
            Path webrootPath = Paths.get("webroot", "img");
            if (Files.exists(webrootPath, new LinkOption[0])) {
                Files.list(webrootPath).forEach(i -> {
                    if (Files.isDirectory(i, new LinkOption[0])) {
                        list.add(new KeyValue(i.getFileName().toString(), i.getFileName().toString()));
                    }
                });
            }
            return list;
        });
    }

    @Override
    public List<KeyValue> getIconFiles(String dirName) throws BGException {
        return this.tryReturn(() -> {
            ArrayList list = new ArrayList();
            Path webrootPath = Paths.get("webroot", "img", dirName);
            if (Files.exists(webrootPath, new LinkOption[0])) {
                Files.list(webrootPath).forEach(i -> {
                    if (Files.isRegularFile(i, new LinkOption[0])) {
                        list.add(new KeyValue(i.getFileName().toString(), i.getFileName().toString()));
                    }
                });
            }
            Collections.sort(list);
            return list;
        });
    }

    @Override
    public JSONArray getComponentList() throws BGException {
        return this.tryReturn(() -> {
            JSONArray array = new JSONArray();
            for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
                String packServer = bgModule.getInstalledModule().getPackageServer();
                Class<?> result = Class.forName(packServer + ".Module");
                Class<WebMenuBase> menuBaseClass = result.asSubclass(WebMenuBase.class);
                if (menuBaseClass == null) continue;
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(bgModule.getId()));
                Element extension = ModuleCache.getInstance().getInstalledModule(bgModule.getName()).getServerExtensionMap().get(WebMenu.class.getName());
                if (extension == null) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"module");
                jsonObject.put("moduleName", (Object)bgModule.getName());
                jsonObject.put("moduleTitle", (Object)bgModule.getTitle());
                jsonObject.put("moduleId", bgModule.getId());
                JSONArray itemArray = new JSONArray();
                jsonObject.put("items", (Object)itemArray);
                for (Element itemElement : XMLUtils.selectElements(extension, "item")) {
                    int id = Utils.parseInt(itemElement.getAttribute("id"));
                    String title = itemElement.getAttribute("titleDefault");
                    String webMenuItemTitle = moduleSetup.get("web.menuItem" + id, null);
                    if (webMenuItemTitle != null) {
                        if ("none".equals(webMenuItemTitle)) continue;
                        title = webMenuItemTitle;
                    } else if ("0".equals(itemElement.getAttribute("defaultVisible"))) continue;
                    JSONObject itemJsonObject = new JSONObject();
                    itemJsonObject.put("id", id);
                    itemJsonObject.put("title", (Object)title);
                    itemJsonObject.put("icon", (Object)itemElement.getAttribute("icon"));
                    itemJsonObject.put("description", (Object)itemElement.getAttribute("description"));
                    itemJsonObject.put("action", (Object)itemElement.getAttribute("action"));
                    itemArray.put((Object)itemJsonObject);
                }
                array.put((Object)jsonObject);
            }
            return array;
        });
    }

    @Override
    public JSONArray getContractSearchModuleList() throws BGException {
        JSONArray array = new JSONArray();
        DynamicCodeDao dynamicCodeDao = new DynamicCodeDao(this.getConnection());
        List<String> classesName = dynamicCodeDao.getActualClassesByInterface(WebContractSearchModule.class.getName());
        for (String className : classesName) {
            WebContractSearchModule webContractSearchModule = DynamicClassManager.getInstance().newInstance(WebContractSearchModule.class, className);
            webContractSearchModule.init(this.getConnection());
            JSONObject json = new JSONObject().put("className", (Object)className).put("title", (Object)webContractSearchModule.getTitle());
            JSONArray params = new JSONArray();
            webContractSearchModule.getParameters().forEach(a -> {
                JSONObject paramJson = new JSONObject().put("key", (Object)a.getKey()).put("type", (Object)a.getType().name()).put("value", (Object)a.getValue());
                params.put((Object)paramJson);
            });
            json.put("params", (Object)params);
            array.put((Object)json);
        }
        return array;
    }

    @Override
    public void updateContractSearchModuleParams(String className, JSONArray params) throws BGException {
        JSONObject jsonObject = new JSONObject();
        params.forEach(a -> jsonObject.put(((JSONObject)a).getString("key"), (Object)((JSONObject)a).getString("value")));
        ServerUtils.setSetupValue((Connection)this.getConnection(), (String)className, (String)jsonObject.toString());
    }

    @Override
    public List<KeyValue> webLimitHandlers() throws BGException {
        ArrayList<KeyValue> handlers = new ArrayList<KeyValue>();
        handlers.add(new KeyValue(BGWebLimitDefaultHandler.class.getName(), "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e (\u0432\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0439)"));
        return handlers;
    }

    @Override
    public List<BGHandlerParameter> webLimitHandlerGeneralParameters(String className) throws BGException {
        if (Utils.isBlankString(className)) {
            return Collections.emptyList();
        }
        BGWebLimitDefaultHandler webLimitHandler = null;
        if (BGWebLimitDefaultHandler.class.getName().equals(className)) {
            webLimitHandler = new BGWebLimitDefaultHandler();
        }
        if (webLimitHandler == null) {
            throw new BGException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a " + className + " \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
        }
        return webLimitHandler.getGeneralParameters();
    }

    @Override
    public List<BGHandlerParameter> webLimitHandlerGroupParameters(String handlerClassName, String groupKey) throws BGException {
        if (Utils.isBlankString(handlerClassName)) {
            return Collections.emptyList();
        }
        BGWebLimitHandler webLimitHandler = null;
        webLimitHandler = BGWebLimitDefaultHandler.class.getName().equals(handlerClassName) ? new BGWebLimitDefaultHandler() : DynamicClassManager.getInstance().newInstance(BGWebLimitHandler.class, handlerClassName);
        if (webLimitHandler == null) {
            throw new BGException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a " + handlerClassName + " \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
        }
        return webLimitHandler.getGroupParameters(groupKey);
    }

    @Override
    public List<String> webAuthModeList() throws BGException {
        return new ArrayList<String>();
    }
}

