/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext;

import java.nio.ByteBuffer;

public final class ByteBufferFactory {
    private static final int defaultCapacity = 4000000;
    private final int capacity;
    private ByteBuffer byteBuffer;

    public ByteBufferFactory(int capacity, boolean direct) {
        this.capacity = capacity;
        this.byteBuffer = direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public ByteBufferFactory(int capacity) {
        this(capacity, true);
    }

    public ByteBufferFactory() {
        this(4000000);
    }

    public ByteBuffer allocateView(int size) {
        if (this.byteBuffer.capacity() - this.byteBuffer.limit() < size) {
            this.byteBuffer = ByteBuffer.allocateDirect(this.capacity);
        }
        this.byteBuffer.limit(this.byteBuffer.position() + size);
        ByteBuffer view = this.byteBuffer.slice();
        this.byteBuffer.position(this.byteBuffer.limit());
        return view;
    }

    public synchronized ByteBuffer allocateViewSync(int size) {
        if (this.byteBuffer.capacity() - this.byteBuffer.limit() < size) {
            this.byteBuffer = ByteBuffer.allocateDirect(this.capacity);
        }
        this.byteBuffer.limit(this.byteBuffer.position() + size);
        ByteBuffer view = this.byteBuffer.slice();
        this.byteBuffer.position(this.byteBuffer.limit());
        return view;
    }
}

