/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class MacrosProcessor {
    private String macros;
    private Pattern pattern = Pattern.compile("\\$\\{([\\w]+)\\}");

    public MacrosProcessor(String macros) {
        this.macros = macros;
    }

    public String getProcessedString(Map<String, String> pairs) {
        StringBuilder result = new StringBuilder(100);
        int end = 0;
        Matcher m = this.pattern.matcher(this.macros);
        while (m.find()) {
            int start = m.start();
            String param = m.group(1);
            String value = Utils.maskNull(pairs.get(param));
            result.append(this.macros.substring(end, start));
            result.append(value);
            end = m.end();
        }
        result.append(this.macros.substring(end, this.macros.length()));
        return result.toString();
    }
}

