/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.task;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.AreaDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class TaskUpdateAddressDirectory
extends TaskBase {
    private static final String SETUP_KEY_TIME = "address.time";
    private static final String SETUP_KEY_DELETE_ROWS = "address.delete.rows";
    private static final String SETUP_KEY_FLAT_AMOUNT = "key.flat.amount";
    private static final String SETUP_KEY_BOX_INDEX = "key.box.index";
    private static final String DEFAULT_VALUE_FLAT_AMOUNT = ".i.flat.amount";
    private static final String DEFAULT_VALUE_BOX_INDEX = "s.box.index";
    private boolean addressDeleteRows = false;
    private String url = null;
    private String keyFlatAmount = null;
    private String keyBoxIndex = null;

    @Override
    protected boolean initTask() {
        this.url = this.taskSetup.get("url", null);
        this.keyBoxIndex = this.taskSetup.get(SETUP_KEY_BOX_INDEX, DEFAULT_VALUE_BOX_INDEX);
        this.keyFlatAmount = this.taskSetup.get(SETUP_KEY_FLAT_AMOUNT, DEFAULT_VALUE_FLAT_AMOUNT);
        this.addressDeleteRows = Utils.parseBoolean(this.taskSetup.get(SETUP_KEY_DELETE_ROWS, "false"));
        return this.url != null;
    }

    @Override
    protected void executeTask() {
        block48: {
            try (Connection con = this.setup.getDBConnectionFromPool();){
                StringBuffer buf = new StringBuffer();
                buf.append(this.url);
                if (this.url.indexOf("?") > -1) {
                    buf.append("&");
                } else {
                    buf.append("?");
                }
                buf.append("time=");
                if (this.addressDeleteRows) {
                    buf.append("0");
                } else {
                    buf.append(ServerUtils.getSetupValue((Connection)con, (String)SETUP_KEY_TIME, (String)"0"));
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("serverURL: {}", (Object)buf.toString());
                }
                URL serverURL = URI.create(buf.toString()).toURL();
                HttpURLConnection httpCon = (HttpURLConnection)serverURL.openConnection();
                httpCon.setRequestMethod("GET");
                httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                httpCon.setDoOutput(false);
                httpCon.setDoInput(true);
                if (httpCon.getResponseCode() == 200) {
                    Document doc = XMLUtils.parseDocument(new InputSource(httpCon.getInputStream()));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("data = {}", (Object)XMLUtils.serializeToString(doc, true));
                    }
                    Element rootElement = doc.getDocumentElement();
                    try (CountryDao countryDao = new CountryDao(con);
                         CityDao cityDao = new CityDao(con);
                         AreaDao areaDao = new AreaDao(con);
                         QuarterDao quarterDao = new QuarterDao(con);
                         StreetDao streetDao = new StreetDao(con);
                         HouseDao houseDao = new HouseDao(con);){
                        if (this.addressDeleteRows) {
                            this.deleteAddressRows(countryDao, cityDao, areaDao, quarterDao, streetDao, houseDao);
                        }
                        int bc = this.updateCountry(countryDao, XMLUtils.selectElement(rootElement, "//address_country"));
                        int cc = this.updateCity(cityDao, XMLUtils.selectElement(rootElement, "//address_city"));
                        int ac = this.updateArea(areaDao, XMLUtils.selectElement(rootElement, "//address_area"));
                        int qc = this.updateAddressQuarter(quarterDao, XMLUtils.selectElement(rootElement, "//address_quarter"));
                        int sc = this.updateAddressStreet(streetDao, XMLUtils.selectElement(rootElement, "//address_street"));
                        int hc = this.updateAddressHouse(houseDao, XMLUtils.selectElement(rootElement, "//address_house"));
                        ServerUtils.setSetupValue((Connection)con, (String)SETUP_KEY_TIME, (String)rootElement.getAttribute("time"));
                        this.getLogger().info("Records updated: county's = " + bc + "; city's = " + cc + "; areas = + " + ac + "; quarters = " + qc + "; streets = " + sc + "; houses = " + hc);
                        break block48;
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                    break block48;
                }
                this.getLogger().error("Request result: ResponseCode: {}, ResponseMessage: {}", (Object)httpCon.getResponseCode(), (Object)httpCon.getResponseMessage());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    private void deleteAddressRows(CountryDao countryDao, CityDao cityDao, AreaDao areaDao, QuarterDao quarterDao, StreetDao streetDao, HouseDao houseDao) throws BGException {
        countryDao.deleteRows();
        cityDao.deleteRows();
        areaDao.deleteRows();
        quarterDao.deleteRows();
        quarterDao.deleteRows();
        houseDao.deleteRows();
    }

    private int updateCountry(CountryDao countryDao, Element countryElement) throws Exception {
        int result = 0;
        if (countryElement != null) {
            for (Element recordElement : XMLUtils.selectElements(countryElement, "record")) {
                Country country = Country.builder().setId(Utils.parseInt(recordElement.getAttribute("id"), -1)).setTitle(XMLUtils.getAttribute(recordElement, "title", null)).build();
                if (country.getId() <= 0 || country.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressCountry id: {}, title: {}", (Object)country.getId(), (Object)country.getTitle());
                    countryDao.update((Object)country);
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateCity(CityDao cityDao, Element cityElement) throws Exception {
        int result = 0;
        if (cityElement != null) {
            for (Element recordElement : XMLUtils.selectElements(cityElement, "record")) {
                City city = City.builder().setId(Utils.parseInt(recordElement.getAttribute("id"), -1)).setCountryId(Utils.parseInt(recordElement.getAttribute("countryId"), -1)).setTitle(XMLUtils.getAttribute(recordElement, "title", null)).build();
                NodeList recordConfigNodeList = recordElement.getElementsByTagName("config");
                for (int configIndex = 0; configIndex < recordConfigNodeList.getLength(); ++configIndex) {
                    Element recordConfigElement = (Element)recordConfigNodeList.item(configIndex);
                    if (!"pos".equals(recordConfigElement.getAttribute("name"))) continue;
                    city.setPositionIndex(Utils.parseInt(recordConfigElement.getAttribute("value"), 0));
                    break;
                }
                if (city.getId() <= 0 || city.getCountryId() <= 0 || city.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressCity country_id: {}, city_id: {}", (Object)city.getCountryId(), (Object)city.getId());
                    cityDao.update((Object)city);
                    AddressUtils.onUpdateAddressCity((Setup)this.setup, (int)city.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateArea(AreaDao areaDao, Element areaElement) throws Exception {
        int result = 0;
        if (areaElement != null) {
            for (Element recordElement : XMLUtils.selectElements(areaElement, "record")) {
                City city = City.builder().setId(Utils.parseInt(recordElement.getAttribute("cityId"), -1)).build();
                Area area = Area.builder().setId(Utils.parseInt(recordElement.getAttribute("id"), -1)).setCity(city).setTitle(XMLUtils.getAttribute(recordElement, "title", null)).build();
                if (area.getId() <= 0 || area.getCity().getId() <= 0 || area.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressArea city_id: {}, area_id: ", (Object)area.getCity().getId(), (Object)area.getId());
                    areaDao.update((Object)area);
                    AddressUtils.onUpdateAddressArea((Setup)this.setup, (int)area.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressQuarter(QuarterDao quarterDao, Element quarterElement) throws Exception {
        int result = 0;
        if (quarterElement != null) {
            for (Element recordElement : XMLUtils.selectElements(quarterElement, "record")) {
                City city = City.builder().setId(Utils.parseInt(recordElement.getAttribute("cityId"), -1)).build();
                Quarter quarter = Quarter.builder().setId(Utils.parseInt(recordElement.getAttribute("id"), -1)).setCity(city).setTitle(XMLUtils.getAttribute(recordElement, "title", null)).build();
                if (quarter.getId() <= 0 || quarter.getCity().getId() <= 0 || quarter.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressQuarter city_id: {}, quarter_id: {}", (Object)quarter.getCity().getId(), (Object)quarter.getId());
                    quarterDao.update((Object)quarter);
                    AddressUtils.onUpdateAddressQuarter((Setup)this.setup, (int)quarter.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressStreet(StreetDao streetDao, Element streetElement) throws Exception {
        int result = 0;
        if (streetElement != null) {
            for (Element recordElement : XMLUtils.selectElements(streetElement, "record")) {
                City city = City.builder().setId(Utils.parseInt(recordElement.getAttribute("cityId"), -1)).build();
                Street street = Street.builder().setId(Utils.parseInt(recordElement.getAttribute("id"), -1)).setCity(city).setTitle(XMLUtils.getAttribute(recordElement, "title", null)).build();
                if (street.getId() <= 0 || street.getCity().getId() <= 0 || street.getTitle() == null) continue;
                this.getLogger().debug("updateAddressStreet city_id: {}, street_id: {}", (Object)street.getCity().getId(), (Object)street.getId());
                try {
                    streetDao.update((Object)street);
                    AddressUtils.onUpdateAddressStreet((Setup)this.setup, (int)street.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressHouse(HouseDao houseDao, Element houseElement) throws Exception {
        int result = 0;
        if (houseElement != null) {
            for (Element recordElement : XMLUtils.selectElements(houseElement, "record")) {
                House house = House.builder().setId(Utils.parseInt(recordElement.getAttribute("id"), -1)).setAreaId(Utils.parseInt(recordElement.getAttribute("areaId"), -1)).setStreetId(Utils.parseInt(recordElement.getAttribute("streetId"), -1)).setQuarterId(Utils.parseInt(recordElement.getAttribute("quarterId"), -1)).setHouse(Utils.parseInt(recordElement.getAttribute("house"), -1)).setFrac(XMLUtils.getAttribute(recordElement, "frac", null)).setComment(XMLUtils.getAttribute(recordElement, "comment", null)).build();
                NodeList recordConfigNodeList = recordElement.getElementsByTagName("config");
                for (int configIndex = 0; configIndex < recordConfigNodeList.getLength(); ++configIndex) {
                    Element recordConfigElement = (Element)recordConfigNodeList.item(configIndex);
                    String name = recordConfigElement.getAttribute("name");
                    String value = recordConfigElement.getAttribute("value");
                    if (this.keyBoxIndex.equals(name)) {
                        house.setPostIndex(value);
                        continue;
                    }
                    if (!this.keyFlatAmount.equals(name)) continue;
                    house.setAmount(Utils.parseInt(value, 0));
                }
                if (house.getId() <= 0 || house.getStreet().getId() <= 0 || house.getHouse() <= 0) continue;
                this.getLogger().debug("updateAddressHouse: street_id: {}, house_id: {}", (Object)house.getStreet().getId(), (Object)house.getId());
                try {
                    houseDao.update(house);
                    AddressUtils.onUpdateHouse((Setup)this.setup, (int)house.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }
}

