/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import jakarta.mail.internet.InternetAddress;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class LoaderImportContractParameterUtil
extends LoaderBase {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int parameterId = configJsonObject.optInt("parameterId", 0);
        int parameterType = configJsonObject.optInt("parameterType", 0);
        StringBuffer result = new StringBuffer();
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            switch (parameterType) {
                case 1: {
                    this.importTextParameter(parameterId, data, contractDao, result);
                    return result.toString();
                }
                case 3: {
                    this.importBooleanParameter(parameterId, data, contractDao, result);
                    return result.toString();
                }
                case 5: {
                    this.importDateParameter(parameterId, data, contractDao, result);
                    return result.toString();
                }
                case 9: {
                    this.importEmailParameter(parameterId, data, contractDao, result);
                    return result.toString();
                }
                default: {
                    result.append("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441 \u0442\u0438\u043f\u043e\u043c = " + parameterType + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
                    return result.toString();
                }
            }
        }
    }

    private void importTextParameter(int parameterId, String data, ContractDao contractDao, StringBuffer result) throws BGException {
        int count = 0;
        for (String line : data.split("\n")) {
            String[] lineData = line.split("\t");
            if (lineData.length != 2) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
                continue;
            }
            Contract contract = contractDao.getByTitle(lineData[0]);
            if (contract == null) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                continue;
            }
            contractDao.updateContractParameter(contract.getId(), (EntityAttr)new EntityAttrText(contract.getId(), parameterId, lineData[1]));
            ++count;
        }
        result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
    }

    private void importBooleanParameter(int parameterId, String data, ContractDao contractDao, StringBuffer result) throws BGException {
        int count = 0;
        for (String line : data.split("\n")) {
            String[] lineData = line.split("\t");
            if (lineData.length != 2) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
                continue;
            }
            Contract contract = contractDao.getByTitle(lineData[0]);
            if (contract == null) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                continue;
            }
            contractDao.updateContractParameter(contract.getId(), (EntityAttr)new EntityAttrBoolean(contract.getId(), parameterId, Boolean.valueOf(lineData[1]).booleanValue()));
            ++count;
        }
        result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
    }

    private void importDateParameter(int parameterId, String data, ContractDao contractDao, StringBuffer result) throws BGException {
        int count = 0;
        DateFormat dateFormat = TimeUtils.getDateFormat("dd.MM.yyyy");
        for (String line : data.split("\n")) {
            String[] lineData = line.split("\t");
            if (lineData.length != 2) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
                continue;
            }
            Contract contract = contractDao.getByTitle(lineData[0]);
            if (contract == null) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                continue;
            }
            try {
                Date date = dateFormat.parse(lineData[1]);
                contractDao.updateContractParameter(contract.getId(), (EntityAttr)new EntityAttrDate(contract.getId(), parameterId, date));
                ++count;
            }
            catch (ParseException ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0420\u0430\u0437\u0431\u043e\u0440 \u0434\u0430\u0442\u044b \"" + lineData[1] + "\"\n");
            }
        }
        result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
    }

    private void importEmailParameter(int parameterId, String data, ContractDao contractDao, StringBuffer result) throws BGException {
        int count = 0;
        for (String line : data.split("\n")) {
            String[] lineData = line.split("\t");
            if (lineData.length != 2) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
                continue;
            }
            Contract contract = contractDao.getByTitle(lineData[0]);
            if (contract == null) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                continue;
            }
            try {
                InternetAddress[] addresses = InternetAddress.parse((String)lineData[1]);
                EntityAttrEmail attrEmail = new EntityAttrEmail(contract.getId(), parameterId);
                for (InternetAddress internetAddress : addresses) {
                    attrEmail.addContact(internetAddress.getPersonal(), internetAddress.getAddress());
                }
                if (!attrEmail.getContactList().isEmpty()) {
                    contractDao.updateContractParameter(contract.getId(), (EntityAttr)attrEmail);
                }
                ++count;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0420\u0430\u0437\u0431\u043e\u0440 email \"" + lineData[1] + "\"\n");
            }
        }
        result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
    }
}

