/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.service.server;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.sql.ConnectionSet;

public abstract class AbstractService
extends BGLogger {
    protected ServerContext context;
    protected int moduleId;
    protected int userId;
    ConnectionSet connectionSet;
    Setup setup;
    ModuleSetup moduleSetup;
    private Preferences userConfig = null;

    protected Setup getSetup() {
        return this.setup;
    }

    protected ModuleSetup getModuleSetup() {
        if (this.moduleSetup == null && this.moduleId > 0) {
            this.moduleSetup = this.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        }
        return this.moduleSetup;
    }

    protected void resetModuleSetup() {
        this.moduleSetup = null;
    }

    protected Preferences getUserConfig() {
        if (this.userConfig == null) {
            User user = UserMap.getUser((Integer)this.userId);
            String user_config = user.getConfig();
            this.userConfig = new Preferences(user_config, "\r\n");
        }
        return this.userConfig;
    }

    protected Connection getConnection() {
        return this.connectionSet.getConnection();
    }

    protected Connection getSlaveConnection() {
        return this.connectionSet.getSlaveConnection();
    }

    protected Connection getTrashConnection(String tableName, int defaultType) {
        return this.connectionSet.getTrashConnection(tableName, defaultType);
    }

    protected ConnectionSet getConnectionSet() {
        return this.connectionSet;
    }

    protected Contract getContract(int contractId) throws BGException {
        return ContractDao.getContract(this.getConnection(), contractId);
    }
}

