/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.contract.ContractParameterTableRow;
import bitel.billing.module.contract.TableContractParameters;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterHistoryData;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractTabbedPane;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamAddressEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamDateEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEditorData;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamEmailEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamListEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamMultiListEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamPhoneEditorDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.ContractParamServiceEditorDialog;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.DialogContractSelect;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

public class ContractParamPanel
extends BGPanel {
    private static final String PARAM_KEY_CONTRACT_PARAMETERS_MODE = "contract.parameters.mode";
    private static final String PARAM_KEY_CONTRACT_PARAMETERS_FILLED = "contract.parameters.filled";
    private static final String PARAM_KEY_CONTRACT_PARAMETERS_FILTER = "contract.parameters.filter";
    private boolean isGet = false;
    private boolean initCopyPanle = false;
    private boolean initHistoryPanel = false;
    private JPanel tablePanel = null;
    private CardLayout tableLayout = new CardLayout();
    private BGUComboBox<KeyValue> groups = new BGUComboBox();
    private HistoryTableModel historyTableModel = new HistoryTableModel();
    private BGControlPanelListSelect paramList = null;
    private TableContractParameters tableContractParameters = new TableContractParameters(this);
    private TitleJList contractPanel = null;
    private TitleJList patternPanel = null;
    private JToggleButton filledButton = null;
    private JToggleButton typesButton = null;
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private ButtonGroup buttonGroup2 = new ButtonGroup();
    private ButtonGroup buttonGroupParam = null;
    private JPanel extPanel = new JPanel(new GridBagLayout());
    private int selectedPid = 0;
    private int selectedPt = 0;
    private Document parametersDocument = null;
    private ClientSetup clientSetup = ClientSetup.getInstance();
    private CustomerParamPanel customerParamPanel = new CustomerParamPanel();

    public ContractParamPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.tableContractParameters.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ContractParamPanel.this.tableContract_mouseClicked(e);
            }
        });
        this.tableContractParameters.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "doEnterEditing");
        this.tableContractParameters.getActionMap().put("doEnterEditing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractParamPanel.this.tableContract_enterPressed();
            }
        });
        this.tableContractParameters.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ContractParamPanel.this.fl && ContractParamPanel.this.tableContractParameters.getRowCount() > 0) {
                    int n = e.getFirstRow();
                    ContractParameterTableRow row = (ContractParameterTableRow)ContractParamPanel.this.tableContractParameters.getValueAt(n, 0);
                    String pt = String.valueOf(row.getParameterType());
                    try {
                        if ("1".equals(pt) || "5".equals(pt)) {
                            ContractService contractService = ContractParamPanel.this.getContext().getWebService(ContractService.class, 0);
                            Object value = ContractParamPanel.this.tableContractParameters.getValueAt(n, 1);
                            if ("1".equals(pt)) {
                                contractService.contractParameterTextUpdate(ContractParamPanel.this.getContractId(), new EntityAttrText(ContractParamPanel.this.getContractId(), row.getParameterId(), value != null ? value.toString() : null));
                            } else {
                                contractService.contractParameterBooleanUpdate(ContractParamPanel.this.getContractId(), new EntityAttrBoolean(ContractParamPanel.this.getContractId(), row.getParameterId(), ((Boolean)value).booleanValue()));
                            }
                            EventBus.publish((Object)new UpdateContractTreeEvent(ContractParamPanel.this.getModuleId(), ContractParamPanel.this.getContractId()));
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.tablePanel = new JPanel(this.tableLayout);
        this.tablePanel.add((Component)this.getParamPanel(), "param");
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.customerParamPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tablePanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getParamPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.tableContractParameters), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void initHistoryPanel() {
        BGButton deleteHistory = new BGButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e");
        deleteHistory.addActionListener(e -> this.clearContractHistory());
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(new BGUTable(this.historyTableModel)), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)deleteHistory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)returnButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tablePanel.add((Component)panel, "history");
        this.initHistoryPanel = true;
    }

    private JPanel getButtonPanel() {
        String contractParametersMode = this.clientSetup.getUserConfig().get(PARAM_KEY_CONTRACT_PARAMETERS_MODE, "group");
        boolean contractParametersFilled = this.clientSetup.getUserConfig().getBoolean(PARAM_KEY_CONTRACT_PARAMETERS_FILLED, false);
        String contractParametersFilter = this.clientSetup.getUserConfig().get(PARAM_KEY_CONTRACT_PARAMETERS_FILTER, "");
        ActionListener buttonActionListener = e -> {
            String actionCommand = e.getActionCommand();
            if ("all".equals(actionCommand) || "group".equals(actionCommand)) {
                this.clientSetup.getUserConfig().set(PARAM_KEY_CONTRACT_PARAMETERS_MODE, actionCommand);
            } else if ("filled".equals(actionCommand)) {
                this.clientSetup.getUserConfig().set(PARAM_KEY_CONTRACT_PARAMETERS_FILLED, String.valueOf(this.filledButton.isSelected()));
            } else if (this.typesButton.isSelected()) {
                this.clientSetup.getUserConfig().set(PARAM_KEY_CONTRACT_PARAMETERS_FILTER, actionCommand);
            }
            this.clientSetup.saveUserConfig();
            if (this.parametersDocument == null || "all".equals(actionCommand) || "group".equals(actionCommand)) {
                this.trySetData();
            } else {
                this.trySetDocument(this.parametersDocument);
            }
        };
        JToggleButton allParamsButton = new JToggleButton("\u0432\u0441\u0435");
        allParamsButton.setActionCommand("all");
        allParamsButton.addActionListener(buttonActionListener);
        allParamsButton.setSelected(allParamsButton.getActionCommand().equals(contractParametersMode));
        this.buttonGroup2.add(allParamsButton);
        JToggleButton groupParamsButton = new JToggleButton("\u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b", true);
        groupParamsButton.setActionCommand("group");
        groupParamsButton.addActionListener(buttonActionListener);
        groupParamsButton.setSelected(groupParamsButton.getActionCommand().equals(contractParametersMode));
        this.buttonGroup2.add(groupParamsButton);
        this.filledButton = new JToggleButton("\u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u0435");
        this.filledButton.setActionCommand("filled");
        this.filledButton.addActionListener(buttonActionListener);
        this.filledButton.setSelected(contractParametersFilled);
        this.typesButton = new JToggleButton("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0442\u0438\u043f\u0430\u043c");
        this.typesButton.addActionListener(e -> {
            this.clientSetup.getUserConfig().set(PARAM_KEY_CONTRACT_PARAMETERS_FILTER, "");
            this.clientSetup.saveUserConfig();
            this.extPanel.setVisible(((JToggleButton)e.getSource()).isSelected());
            this.trySetDocument(this.parametersDocument);
        });
        this.typesButton.setSelected(!contractParametersFilter.isEmpty());
        this.extPanel.setVisible(!contractParametersFilter.isEmpty());
        this.groups.addItemListener(e -> this.groups_itemStateChanged(e));
        TypeToggleButton textButton = new TypeToggleButton("\u0442\u0435\u043a\u0441\u0442", "\u041f\u0430\u043f\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0442\u0435\u043a\u0441\u0442", "1", contractParametersFilter, buttonActionListener);
        textButton.setSelected(true);
        TypeToggleButton phoneButton = new TypeToggleButton("\u0442\u0435\u043b\u0435\u0444\u043e\u043d", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d", "9", contractParametersFilter, buttonActionListener);
        TypeToggleButton addressButton = new TypeToggleButton("\u0430\u0434\u0440\u0435\u0441", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0430\u0434\u0440\u0435\u0441", "2", contractParametersFilter, buttonActionListener);
        TypeToggleButton emailButton = new TypeToggleButton("e-mail", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 e-mail", "3", contractParametersFilter, buttonActionListener);
        TypeToggleButton dateButton = new TypeToggleButton("\u0434\u0430\u0442\u0430", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0434\u0430\u0442\u0430", "6", contractParametersFilter, buttonActionListener);
        TypeToggleButton flagButton = new TypeToggleButton("\u0444\u043b\u0430\u0433", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0444\u043b\u0430\u0433", "5", contractParametersFilter, buttonActionListener);
        TypeToggleButton servContractButton = new TypeToggleButton("\u043e\u0431\u0441\u043b. \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "4", contractParametersFilter, buttonActionListener);
        TypeToggleButton listButton = new TypeToggleButton("\u0441\u043f\u0438\u0441\u043e\u043a", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0441\u043f\u0438\u0441\u043e\u043a", "7", contractParametersFilter, buttonActionListener);
        TypeToggleButton multiListButton = new TypeToggleButton("\u043c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u043c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a", "11", contractParametersFilter, buttonActionListener);
        TypeToggleButton contractButton = new TypeToggleButton("\u0434\u043e\u0433\u043e\u0432\u043e\u0440", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440", "8", contractParametersFilter, buttonActionListener);
        this.extPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.extPanel.add((Component)textButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)addressButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)phoneButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)emailButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)flagButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)dateButton, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)listButton, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)multiListButton, new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)contractButton, new GridBagConstraints(9, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)servContractButton, new GridBagConstraints(10, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        BGButton copyButton = new BGButton("\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437...");
        copyButton.addActionListener(e -> {
            if (!this.initCopyPanle) {
                this.initCopyPanel();
            }
            this.tableLayout.show(this.tablePanel, "copy");
            ArrayList<BGUListItem> model = new ArrayList<BGUListItem>();
            ContractTabbedPane pane = BGClientBase.getFrame().getTabbedPane();
            for (int index = 0; index < pane.getTabCount(); ++index) {
                String id;
                Component comp = pane.getComponentAt(index);
                if (comp == null || !(comp instanceof BGTabPanel)) continue;
                BGTabPanel panel = (BGTabPanel)comp;
                String panelId = panel.getTabId();
                String title = panel.getTabTitle() + " [ " + String.valueOf(panel.getAttribute("contractComment")) + " ]";
                if (!panelId.startsWith("contract_") || (id = panelId.substring(9)).equals(String.valueOf(this.getContractId()))) continue;
                model.add(new BGUListItem(id, title));
            }
            this.contractPanel.getList().setData(model);
            this.paramList.getList().setModel(new DefaultListModel());
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        panel.add((Component)groupParamsButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)allParamsButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.filledButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)this.typesButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)copyButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430: "), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 5, 5), 0, 0));
        panel.add(this.groups, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.extPanel, new GridBagConstraints(0, 1, 7, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void initCopyPanel() {
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        JButton copyReplaceButton = new JButton(" \u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c (\u0441 \u0437\u0430\u043c\u0435\u043d\u043e\u0439) ");
        copyReplaceButton.addActionListener(e -> this.copyParameters("replace"));
        JButton copyAddButton = new JButton(" \u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c (\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0435) ");
        copyAddButton.addActionListener(e -> this.copyParameters("add"));
        this.contractPanel = new TitleJList("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        this.contractPanel.getList().addListSelectionListener(event -> {
            if (!event.getValueIsAdjusting()) {
                this.getParameterList();
            }
        });
        this.patternPanel = new TitleJList("\u0428\u0430\u0431\u043b\u043e\u043d\u044b");
        this.patternPanel.getList().addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                BGUListItem listItem = (BGUListItem)this.patternPanel.getList().getSelectedValue();
                this.setSelectedParameterList(Utils.toIntegerSet((String)listItem.getAttribute("pids")));
            }
        });
        ActionListener filterActionListener = e -> this.getParameterList();
        ParamRadioButton allButton = new ParamRadioButton("\u0432\u0441\u0435", "all", false, filterActionListener);
        ParamRadioButton filledButton = new ParamRadioButton("\u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0435", "filled", true, filterActionListener);
        this.buttonGroupParam = new ButtonGroup();
        this.buttonGroupParam.add(allButton);
        this.buttonGroupParam.add(filledButton);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)allButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        filterPanel.add((Component)filledButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.paramList = new BGControlPanelListSelect(false);
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setBorder(new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        paramPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.paramList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)copyReplaceButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)copyAddButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)returnButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.contractPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)paramPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.patternPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tablePanel.add((Component)panel, "copy");
        this.getContractParameterCopyPatternList();
        this.initCopyPanle = true;
    }

    protected void copyParameters(String mode) {
        BGUListItem item = (BGUListItem)this.contractPanel.getList().getSelectedValue();
        if (item == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
            return;
        }
        this.tryCall(() -> {
            List<Integer> pids = this.contractPanel.getList().getSelectedValuesList().stream().map(a -> a.getId()).toList();
            this.getContext().getWebService(ContractService.class, 0).contractParametersCopy(item.getId(), this.getContractId(), pids, mode);
            this.tableLayout.show(this.tablePanel, "param");
            this.trySetData();
        });
    }

    protected void clearContractHistory() {
        Request request;
        Document doc;
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0 && ClientUtils.checkStatus(doc = TransferManager.getDocument(request = new Request().setModule("contract").setAction("ClearParameterHistory").setAttribute("cid", this.getContractId()).setAttribute("pid", this.selectedPid).setAttribute("pt", this.selectedPt)))) {
            this.renewHistoryTable(this.selectedPid, this.selectedPt);
        }
    }

    protected void getContractParameterCopyPatternList() {
        Request request = new Request().setModule("contract").setAction("GetContractParameterCopyPatternList");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tryCall(() -> {
                ArrayList<BGUListItem> items = new ArrayList<BGUListItem>();
                items.add(new BGUListItem(0, "\u0411\u0435\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430").setAttribute("pids", "0"));
                XMLUtils.selectElements(doc, "//data/list/item").forEach(itemElement -> {
                    String value = itemElement.getAttribute("value");
                    if (Utils.isBlankString(value)) {
                        value = "\u043d/\u0437";
                    }
                    items.add(new BGUListItem(0, itemElement.getAttribute("title")).setAttribute("pids", itemElement.getAttribute("pids")));
                });
                this.patternPanel.getList().setData(items);
            });
        }
    }

    protected void getParameterList() {
        BGUListItem listItem = (BGUListItem)this.contractPanel.getList().getSelectedValue();
        if (listItem != null) {
            int contractId = listItem.getId();
            try {
                DefaultListModel<BGUListItem> model = this.paramList.getListModel();
                model.removeAllElements();
                String actionCommand = this.buttonGroupParam.getSelection().getActionCommand();
                this.getContext().getWebService(ContractService.class, 0).contractParameterList(contractId).forEach(a -> {
                    String value = a.getValue();
                    if (Utils.isBlankString(value)) {
                        value = "\u043d/\u0437";
                    }
                    if (actionCommand.equals("all") || !value.equals("\u043d/\u0437")) {
                        model.addElement(new BGUListItem(a.getId(), "<html>" + a.getTitle() + ":  <i>" + value + "</i></html>"));
                    }
                });
                this.patternPanel.getList().setSelectedIndex(0);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    protected void setSelectedParameterList(Set<Integer> pids) {
        BGUListItem patternItem = (BGUListItem)this.patternPanel.getList().getSelectedValue();
        if (patternItem != null) {
            DefaultListModel<BGUListItem> model = this.paramList.getListModel();
            for (int index = 0; index < model.getSize(); ++index) {
                BGUListItem item = model.get(index);
                item.setSelected(pids.contains(item.getId()));
            }
            this.paramList.getList().repaint();
        }
    }

    @Override
    public void setData() throws Exception {
        this.customerParamPanel.performAction("refresh");
        Request request = new Request().setModule(this.module).setAction("ContractParameters").setContractId(this.getContractId());
        if ("all".equals(this.buttonGroup2.getSelection().getActionCommand())) {
            request.setAttribute("all", "1");
        }
        if (!this.isGet) {
            request.setAttribute("list", "1");
        }
        this.parametersDocument = TransferManager.getDocument(request);
        this.setDocument(this.parametersDocument);
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus(doc)) {
            this.fl = false;
            Element condel = XMLUtils.selectElement(doc, "//condel");
            String pgid = XMLUtils.getAttribute(condel, "pgid", "0");
            if (!this.isGet) {
                ArrayList<KeyValue> groupItems = new ArrayList<KeyValue>();
                for (Element itemElement : XMLUtils.selectElements(doc, "//groups/item")) {
                    groupItems.add(new KeyValue(itemElement.getAttribute("id"), itemElement.getAttribute("title")));
                }
                this.groups.setData(groupItems);
                this.isGet = true;
            }
            this.groups.setSelectedItem(this.groups.getData().stream().filter(a -> a.getKey().equals(pgid)).findFirst().orElse(this.groups.getData().get(0)));
            String button = null;
            if (this.typesButton.isSelected()) {
                button = this.buttonGroup1.getSelection().getActionCommand();
            }
            this.tableContractParameters.setRowsData(XMLUtils.selectNode(doc, "//parameters"), button, this.filledButton.isSelected());
            this.fl = true;
        }
    }

    private void groups_itemStateChanged(ItemEvent e) {
        if (this.fl && e.getStateChange() == 1) {
            KeyValue item = (KeyValue)this.groups.getSelectedItem();
            try {
                this.getContext().getWebService(ContractService.class, 0).contractParameterGroupSet(this.getContractId(), Utils.parseInt(item.getKey()));
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private void renewHistoryTable(int parameterId, int parameterType) {
        Async.ofWithTry(() -> {
            this.historyTableModel.setData(this.getContext().getWebService(ContractService.class, 0).contractParameterHistoryList(this.getContractId(), parameterId, parameterType));
            this.selectedPid = parameterId;
            this.selectedPt = parameterType;
        });
    }

    private void tableContract_enterPressed() {
        int row = this.tableContractParameters.getSelectedRow();
        if (row > -1) {
            this.openEditor(row);
        }
    }

    private void tableContract_mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        int row = this.tableContractParameters.getSelectedRow();
        if (e.getClickCount() == 1 && row > -1) {
            ContractParameterTableRow tr = (ContractParameterTableRow)this.tableContractParameters.getValueAt(row, 0);
            int col = this.tableContractParameters.getSelectedColumn();
            if (col == 2 && tr.getParameterType() != 10) {
                if (!this.initHistoryPanel) {
                    this.initHistoryPanel();
                }
                this.tableLayout.show(this.tablePanel, "history");
                this.renewHistoryTable(tr.getParameterId(), tr.getParameterType());
            }
        } else if (e.getClickCount() == 2 && row > -1) {
            this.openEditor(row);
        }
    }

    private void openEditor(int row) {
        ContractParameterTableRow tableRow = (ContractParameterTableRow)this.tableContractParameters.getValueAt(row, 0);
        int parameterId = tableRow.getParameterId();
        ContractParamEditorData data = new ContractParamEditorData().setClientContext(this.getContext()).setContractId(this.getContractId()).setParameterId(tableRow.getParameterId()).setParameterTitle(tableRow.getTitle()).setEntityType(EntityType.CONTRACT_PARAMETER);
        switch (tableRow.getParameterType()) {
            case 1: {
                this.tableContractParameters.editCellAt(row, 1);
                break;
            }
            case 2: {
                new ContractParamAddressEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0410\u0434\u0440\u0435\u0441\"", data).open();
                break;
            }
            case 3: {
                new ContractParamEmailEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"E-mail\"", data).open();
                break;
            }
            case 4: {
                new ContractParamServiceEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\"", data).open();
                break;
            }
            case 5: {
                this.tableContractParameters.setValueAt((Boolean)this.tableContractParameters.getValueAt(row, 1) != false ? Boolean.FALSE : Boolean.TRUE, row, 1);
                break;
            }
            case 6: {
                data.value = new EntityAttrDate(this.getContractId(), tableRow.getParameterId(), TimeUtils.parseDate((String)tableRow.getValue(), "dd.MM.yyyy"));
                new ContractParamDateEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0414\u0430\u0442\u0430\"", data).open();
                break;
            }
            case 7: {
                new ContractParamListEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0421\u043f\u0438\u0441\u043e\u043a\"", data).open();
                break;
            }
            case 8: {
                String[] selected;
                DialogContractSelect dialog = new DialogContractSelect(true, true, 0);
                if ("ok".equals(dialog.showDialog()) && (selected = dialog.getSelected()) != null && selected.length > 0) {
                    try {
                        this.getContext().getWebService(ContractService.class, 0).contractParameterContractUpdate(this.getContractId(), new EntityAttrContract(this.getContractId(), parameterId, Utils.parseInt(selected[0]), ""));
                        this.setData();
                    }
                    catch (Exception e) {
                        ClientUtils.showErrorMessageDialog(e);
                    }
                }
                dialog.dispose();
                break;
            }
            case 9: {
                try {
                    String formats = this.getContext().getWebService(ContractParameterService.class, 0).paramPhoneFormats();
                    new ContractParamPhoneEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u0422\u0435\u043b\u0435\u0444\u043e\u043d\"", data, formats).open();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                break;
            }
            case 11: {
                new ContractParamMultiListEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0442\u0438\u043f\u0430 \"\u041c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a\"", data).open();
            }
        }
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    @Override
    @Deprecated
    public void init(String module, int mid) {
        throw new UnsupportedOperationException("Use init( JFrame frame, final String module, final int mid, final int cid )");
    }

    public void init(String module, int moduleId, int contractId) {
        super.init(module, moduleId);
        super.setContractId(contractId);
    }

    @Override
    public void setContractId(int id) {
        super.setContractId(id);
    }

    class HistoryTableModel
    extends BGTableModel<ContractParameterHistoryData> {
        public HistoryTableModel() {
            super(HistoryTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 180, 180, 180, "when", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b", 200, 200, 200, "who", true, HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    private class TitleJList
    extends JPanel {
        private BGUList<BGUListItem> list = new BGUList();

        public TitleJList(String title) {
            this.setBorder(new BGTitleBorder(title));
            this.setLayout(new GridBagLayout());
            this.setMinimumSize(new Dimension(200, 100));
            this.setPreferredSize(new Dimension(350, 200));
            this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.list.setSelectionMode(0);
            this.list.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public BGUList<BGUListItem> getList() {
            return this.list;
        }
    }

    private class TypeToggleButton
    extends JToggleButton {
        public TypeToggleButton(String text, String toolTipText, String actionCommand, String contractParametersFilter, ActionListener actionListener) {
            super(text);
            this.setToolTipText(toolTipText);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
            ContractParamPanel.this.buttonGroup1.add(this);
            this.setSelected(actionCommand.equals(contractParametersFilter));
        }
    }

    private class ParamRadioButton
    extends JRadioButton {
        public ParamRadioButton(String text, String actionCommand, boolean selected, ActionListener actionListener) {
            super(text);
            this.setSelected(selected);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }
}

