/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopayment;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ContractAutopaymentManager
extends AbstarctDaoConstant
implements AutoCloseable {
    private int moduleId = 0;
    private final String tableName = "contract_autopayment";
    private Connection con = null;
    private Map<String, String> fields;

    public ContractAutopaymentManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
        this.fields = new HashMap<String, String>();
        this.fields.put("id", "id");
        this.fields.put("dateFrom", "date_from");
        this.fields.put("dateTo", "date_to");
    }

    public boolean isEnabled(int contractId) throws BGException {
        return this.isEnabled(contractId, new Date());
    }

    public boolean isEnabled(int contractId, Date onDate) throws BGException {
        boolean result = false;
        try {
            String sql = "SELECT " + "COUNT(*)" + " FROM " + "contract_autopayment" + " WHERE " + "contract_id=? AND module_id=? AND ( ISNULL(date_from) OR date_from<=? ) AND ( ISNULL(date_to) OR date_to>=? )";
            int parameterIndex = 1;
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(parameterIndex++, contractId);
            ps.setInt(parameterIndex++, this.moduleId);
            ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)onDate));
            ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)onDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public boolean setEnabled(int contractId, boolean enabled, int userId) throws BGException {
        boolean result = false;
        try {
            int id = -1;
            Date dateNow = new Date();
            Timestamp dateFrom = null;
            Timestamp dateTo = null;
            String sql = "SELECT " + "id, date_from, date_to" + " FROM " + "contract_autopayment" + " WHERE " + "contract_id=? AND module_id=?" + " ORDER BY " + "date_from DESC" + " LIMIT " + "1";
            int parameterIndex = 1;
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setInt(parameterIndex++, contractId);
            ps.setInt(parameterIndex++, this.moduleId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                id = rs.getInt(1);
                dateFrom = rs.getTimestamp(2);
                dateTo = rs.getTimestamp(3);
            }
            rs.close();
            ps.close();
            if (dateFrom == null && dateTo == null || dateFrom != null && dateTo != null) {
                if (enabled) {
                    sql = "INSERT INTO " + "contract_autopayment" + " SET " + "contract_id=?, module_id=?, date_from=?, user_from=?";
                    parameterIndex = 1;
                    PreparedStatement psInsert = this.con.prepareStatement(sql);
                    psInsert.setInt(parameterIndex++, contractId);
                    psInsert.setInt(parameterIndex++, this.moduleId);
                    psInsert.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)dateNow));
                    psInsert.setInt(parameterIndex++, userId);
                    psInsert.executeUpdate();
                    psInsert.close();
                    result = true;
                }
            } else if (dateFrom != null && dateTo == null && !enabled) {
                sql = "UPDATE " + "contract_autopayment" + " SET " + "date_to=?, user_to=?" + " WHERE " + "id=?";
                parameterIndex = 1;
                PreparedStatement psUpdate = this.con.prepareStatement(sql);
                psUpdate.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((Date)dateNow));
                psUpdate.setInt(parameterIndex++, userId);
                psUpdate.setInt(parameterIndex++, id);
                psUpdate.executeUpdate();
                psUpdate.close();
                result = true;
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void searchContractAutopayment(SearchResult<ContractAutopayment> searchResult, int contractId) throws BGException {
        if (searchResult != null) {
            try {
                Page page = searchResult.getPage();
                String[] sort = searchResult.getSort();
                List list = searchResult.getList();
                String sqlWhere = " WHERE contract_id = ? AND module_id=?";
                String sql = "SELECT * FROM contract_autopayment" + sqlWhere + this.getSQLOrder(sort, this.fields) + this.sqlLimit(page);
                int parameterIndex = 1;
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setInt(parameterIndex++, contractId);
                ps.setInt(parameterIndex++, this.moduleId);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromResultSet(rs));
                }
                rs.close();
                ps.close();
                parameterIndex = 1;
                ps = this.con.prepareStatement("SELECT COUNT(*) FROM contract_autopayment" + sqlWhere);
                ps.setInt(parameterIndex++, contractId);
                ps.setInt(parameterIndex++, this.moduleId);
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (page == null) continue;
                    page.setRecordCount(rs.getInt(1));
                }
                rs.close();
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void cleanForContract(int contractId) throws SQLException {
        String query = "DELETE FROM contract_autopayment WHERE contract_id=? AND module_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, this.moduleId);
            ps.executeUpdate();
        }
    }

    protected ContractAutopayment getFromResultSet(ResultSet resultSet) throws SQLException {
        int userFromId = resultSet.getInt("user_from");
        int userToId = resultSet.getInt("user_to");
        return new ContractAutopayment(resultSet.getInt("id")).setContractId(resultSet.getInt("contract_id")).setModuleId(resultSet.getInt("module_id")).setPeriod(new PeriodWithTime((Date)resultSet.getTimestamp("date_from"), (Date)resultSet.getTimestamp("date_to"))).setUserFromId(userFromId).setUserFromName(Optional.ofNullable(UserMap.getUser(userFromId)).filter(a -> a.getId() > -2).map(a -> a.getName()).orElse("")).setUserToId(userToId).setUserToName(Optional.ofNullable(UserMap.getUser(userToId)).filter(a -> a.getId() > -2).map(a -> a.getName()).orElse(""));
    }

    @Override
    public void close() throws BGException {
    }

    public static boolean isContractAutopaymentEnabled(Connection con, int moduleId, int contractId) throws BGException {
        try (ContractAutopaymentManager contractAutopaymentManager = new ContractAutopaymentManager(con, moduleId);){
            boolean bl = contractAutopaymentManager.isEnabled(contractId);
            return bl;
        }
    }
}

