/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.tariff.TariffTreeBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.common.TimeUtils;

public class ContractManager
extends BGLogger {
    private Connection con;

    public ContractManager(Connection con) {
        this.con = con;
    }

    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Date date, String module, int mid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, date, module, mid, 0, 0, useChache);
    }

    @Deprecated
    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Calendar time, String module, int mid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, time.getTime(), module, mid, 0, 0, useChache);
    }

    @Deprecated
    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Calendar time, String module, int mid, int emid, int eid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, time.getTime(), module, mid, emid, eid, useChache);
    }

    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Date time, String module, int mid, int emid, int eid, boolean useChache) {
        TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
        TariffTreeSet result = new TariffTreeSet(module, mid, ttb, cid, useChache);
        String query = "SELECT tree_id, date1, date2, emid, eid, 1, pos FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) UNION SELECT tree_id, date1, date2, emid, eid, 0, pos FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND (date2 IS NULL OR date2>=?) ORDER BY 4 DESC, 5 DESC, 6 ASC, 7 ASC";
        java.sql.Date dt = TimeUtils.convertDateToSqlDate((Date)time);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cid);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, dt);
            ps.setInt(5, cid);
            ps.setInt(6, emid);
            ps.setInt(7, eid);
            ps.setDate(8, dt);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int treeId = rs.getInt(1);
                    java.sql.Date dateFrom = rs.getDate(2);
                    java.sql.Date dateTo = rs.getDate(3);
                    int _emid = rs.getInt(4);
                    int _eid = rs.getInt(5);
                    result.addTariffTree(treeId, _emid, _eid, dateFrom, dateTo);
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    @Deprecated
    public TariffTreeSet getTariffTreeSetForDay(int contractId, Calendar time, String module, int moduleId, boolean useChache) {
        TariffTreeSet tariffTreeSet = null;
        try {
            LocalDate localDate = LocalDateTime.ofInstant(time.toInstant(), time.getTimeZone().toZoneId()).toLocalDate();
            tariffTreeSet = this.getTariffTreeSetForDay(contractId, localDate, module, moduleId, useChache);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return tariffTreeSet;
    }

    public TariffTreeSet getTariffTreeSetForDay(int contractId, LocalDate time, String module, int moduleId, boolean useChache) throws Exception {
        TariffTreeSet result = null;
        TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
        result = new TariffTreeSet(module, moduleId, ttb, contractId, useChache);
        String query = "SELECT tree_id, date1, date2, emid, eid, 1, pos FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ( isNull(date1) OR date1='0000-00-00' OR date1<=? ) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) UNION SELECT tree_id, date1, date2, emid, eid, 0, pos FROM contract_tree_link WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY 4 DESC, 5 DESC, 6 ASC, 7 ASC";
        java.sql.Date day = TimeUtils.convertLocalDateToSqlDate((LocalDate)time);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, day);
            ps.setDate(3, day);
            ps.setInt(4, contractId);
            ps.setDate(5, day);
            ps.setDate(6, day);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int treeId = rs.getInt(1);
                    java.sql.Date dateFrom = rs.getDate(2);
                    java.sql.Date dateTo = rs.getDate(3);
                    int emid = rs.getInt(4);
                    int eid = rs.getInt(5);
                    result.addTariffTree(treeId, emid, eid, dateFrom, dateTo);
                }
            }
        }
        return result;
    }

    public boolean isSubContract(int cid, int subcid) throws SQLException {
        boolean result = false;
        String query = "SELECT * FROM contract WHERE id=? AND scid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, subcid);
            ps.setInt(2, cid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = true;
                }
            }
        }
        return result;
    }

    @Deprecated
    public void updateLastTariffChange(int contractId) {
        String query = "UPDATE contract SET last_tariff_change=NOW() WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void addContractGroup(int contractId, int groupId) throws BGException {
        String query = "UPDATE contract SET gr=gr|(1<<?) WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, groupId);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException("error add contract group", (Throwable)ex);
        }
    }

    public void deleteContractGroup(int contractId, long groupId) throws BGException {
        String query = "UPDATE contract SET gr=gr&~(1<<?) WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, groupId);
            ps.setInt(2, contractId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException("error delete contract group", (Throwable)ex);
        }
    }

    public Map<Integer, Integer> getContractParameterGroupCountMap() throws BGException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String query = "SELECT pgid, COUNT(*) FROM contract GROUP BY pgid";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return map;
    }

    public boolean checkContractService(int contractId, int serviceId, Date date) throws BGException {
        boolean result = false;
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
        String query = "SELECT count(*) FROM contract_service WHERE cid=? AND sid=? AND date1<=? AND ( isNull( date2 ) || date2 >=? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, serviceId);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getInt(1) > 0;
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

