/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.server.bean;

import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@Deprecated
public class ContractParameterPrefDao
extends AbstractIdDao<ContractParameterPref> {
    public ContractParameterPrefDao(Connection con) {
        super(con, "contract_parameters_pref");
    }

    public List<ContractParameterPref> getContractParameterPrefList(ContractParameterPrefType prefEnum) throws SQLException {
        return this.list(prefEnum != null && prefEnum != ContractParameterPrefType.TYPE_UNKNOWN ? "pt=" + prefEnum.getId() : null, "sort", new Object[0]);
    }

    public List<ContractParameterPref> getContractParameterPrefList(Set<Integer> ids) throws SQLException {
        if (ids != null && !ids.isEmpty()) {
            return this.list("id IN ( " + Utils.toString(ids) + " )", "sort", new Object[0]);
        }
        return this.list(null, "sort", new Object[0]);
    }

    public List<IdTitle> getContractParameterPrefIdTitleList(int paramTypeId) throws SQLException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        for (ContractParameterPref pref : this.getContractParameterPrefList(ContractParameterPrefType.getType(paramTypeId))) {
            list.add(new IdTitle(pref.getId(), pref.getTitle()));
        }
        return list;
    }

    public void moveParam(int id, boolean up) throws Exception {
        try {
            ContractParameterPref pref = (ContractParameterPref)this.get(id);
            if (pref == null) {
                throw new BGIllegalArgumentException();
            }
            int currentPos = pref.getSort();
            int anotherId = 0;
            int anotherPos = 0;
            String query = null;
            query = up ? "SELECT id, sort FROM " + this.tableName + " WHERE sort<? AND id!=? ORDER BY sort DESC LIMIT 1" : "SELECT id, sort FROM " + this.tableName + " WHERE sort>? AND id!=? ORDER BY sort LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, currentPos);
            ps.setInt(2, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                anotherId = rs.getInt(1);
                anotherPos = rs.getInt(2);
            }
            rs.close();
            ps.close();
            if (anotherId != 0 && anotherPos != 0) {
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET sort=? WHERE id=?");
                ps.setInt(1, anotherPos);
                ps.setInt(2, id);
                ps.executeUpdate();
                ps.setInt(1, currentPos);
                ps.setInt(2, anotherId);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void updateSortPosition(List<ContractParameterPref> list) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET sort=? WHERE id=?");){
            for (ContractParameterPref contract : list) {
                ps.setInt(1, contract.getSort());
                ps.setInt(2, contract.getId());
                ps.executeUpdate();
            }
        }
    }

    @Override
    protected ContractParameterPref getFromRS(ResultSet rs) throws SQLException {
        ContractParameterPref pref = new ContractParameterPref();
        pref.setId(rs.getInt("id"));
        pref.setType(ContractParameterPrefType.getType(rs.getInt("pt")));
        pref.setSort(rs.getInt("sort"));
        pref.setTitle(rs.getString("title"));
        byte flags = rs.getByte("flags");
        pref.setHistory((flags & 1) > 0);
        pref.setWrite((flags & 2) > 0);
        pref.setRead((flags & 4) > 0);
        pref.setAlwaysVisible((flags & 8) > 0);
        return pref;
    }

    @Override
    protected void updateImpl(ContractParameterPref pref) throws SQLException {
        String query = null;
        PreparedStatement ps = null;
        int flags = pref.isHistory() ? 1 : 0;
        flags |= pref.isWrite() ? 2 : 0;
        flags |= pref.isRead() ? 4 : 0;
        flags |= pref.isAlwaysVisible() ? 8 : 0;
        if (pref.getId() <= 0) {
            query = "SELECT if( isnull( max(sort) ), 1, max(sort) + 1 ) FROM " + this.tableName;
            ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                pref.setSort(rs.getInt(1));
            }
            ps.close();
            query = "INSERT INTO " + this.tableName + " SET title=?, sort=?, flags=?, pt=?";
            ps = this.con.prepareStatement(query, 1);
            ps.setInt(4, pref.getType().getId());
        } else {
            query = "UPDATE " + this.tableName + " SET title=?, sort=?, flags=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(4, pref.getId());
        }
        ps.setString(1, pref.getTitle());
        ps.setInt(2, pref.getSort());
        ps.setByte(3, (byte)flags);
        ps.executeUpdate();
        if (pref.getId() <= 0) {
            pref.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
        ContractParameterManager.resetParametersHistoryMap();
    }
}

