/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.service;

import jakarta.jws.WebService;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.integration.common.bean.Register;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.common.service.IntegrationService;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterHandler;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterLoadData;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterLoadPattern;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterLoadPatternManager;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.integration.common.service.IntegrationService")
public class IntegrationServiceImpl
extends AbstractService
implements IntegrationService {
    @Override
    public List<KeyValue> getLoadPatternList(int registerType) throws Exception {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        for (RegisterLoadPattern pattern : this.getLoadPatterns(registerType)) {
            list.add(new KeyValue(pattern.getKey() + ":enc", pattern.getTitle()));
        }
        return list;
    }

    protected List<RegisterLoadPattern> getLoadPatterns(int regtype) throws BGMessageException {
        return new RegisterLoadPatternManager(Setup.getSetup()).getLoadPatterns(regtype);
    }

    @Override
    public SearchResult<Register> searchRegistersRowList(int registerType, Period period) throws Exception {
        SearchResult searchResult = new SearchResult(period, null);
        List list = searchResult.getList();
        RegisterManager registerManager = new RegisterManager(this.getConnection());
        list.addAll(registerManager.getRegisterList(period, 1000000, registerType));
        return searchResult;
    }

    @Override
    public int loadRegister(String patternId, int registerType, String file, Date date, String title) throws Exception {
        RegisterLoadPattern pattern = new RegisterLoadPatternManager(Setup.getSetup()).getLoadPatternByKey(patternId, registerType);
        byte[] bytes = Base64.decode((byte[])file.getBytes());
        if (pattern.getHandlerClassName() != null) {
            RegisterHandler registerHandler = DynamicClassManager.getInstance().newInstance(RegisterHandler.class, pattern.getHandlerClassName());
            bytes = registerHandler.preload(new ByteArrayInputStream(bytes));
        }
        RegisterLoadData data = new RegisterLoadData();
        data.date = date;
        data.title = title;
        data.file = bytes;
        if (pattern != null && data.file != null && data.date != null) {
            return pattern.loadRegister(this.getConnection(), data).getId();
        }
        throw new BGIllegalArgumentException();
    }

    @Override
    public Result<RegisterItem> registerItems(int registerId) throws Exception {
        Result result = new Result();
        ArrayList<RegisterItem> list = new ArrayList<RegisterItem>();
        RegisterManager registerManager = new RegisterManager(this.getConnection());
        RegisterItemManager prim = new RegisterItemManager(this.getConnection());
        Directory<PaymentType> paymentTDirectory = this.context.getDirectory(PaymentType.class, 0);
        Directory<ChargeType> chargeTDirectory = this.context.getDirectory(ChargeType.class, 0);
        Register register = registerManager.getRegisterById(registerId);
        if (register == null) {
            throw new BGMessageException("\u0420\u0435\u0435\u0441\u0442\u0440 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        Contract contract = null;
        for (RegisterItem item : prim.getRegisterItems(register)) {
            contract = ContractDao.getContract(this.getConnection(), item.getContractId());
            if (contract != null) {
                item.setContract(contract.getTitle() + " (" + contract.getComment() + ")");
            }
            if (register.getRegisterType() == 1) {
                ChargeType chargeType = chargeTDirectory.get(item.getBalanceItemTypeId());
                item.setOperationTypeTitle((String)(chargeType != null ? String.valueOf((Object)chargeType) : "???id=" + item.getBalanceItemTypeId()));
            } else {
                PaymentType paymentType = paymentTDirectory.get(item.getBalanceItemTypeId());
                item.setOperationTypeTitle((String)(paymentType != null ? String.valueOf((Object)paymentType) : "???id=" + item.getBalanceItemTypeId()));
            }
            list.add(item);
        }
        result.setList(list);
        if (register.getLoadLog() != null) {
            String log = register.getLoadLog().replaceAll("[^\\P{Cc}\\t\\r\\n]", "?");
            result.setAttribute("load_log", (Object)log);
        }
        return result;
    }

    @Override
    public void deleteRegister(int registerType, int registerId) throws Exception {
        RegisterManager registerManager = new RegisterManager(this.getConnection());
        Register register = registerManager.getRegisterById(registerId);
        if (register != null) {
            if (register.isProcessed()) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u0440\u0435\u0435\u0441\u0442\u0440!");
            }
            RegisterItemManager registerItemManager = new RegisterItemManager(this.getConnection());
            registerItemManager.deleteRegisterItems(register);
            registerManager.deleteRegister(registerId);
        }
    }

    @Override
    public void rollbackRegister(int registerType, int registerId) throws Exception {
        Connection con = this.getConnection();
        RegisterManager registerManager = new RegisterManager(con);
        Register register = registerManager.getRegisterById(registerId);
        if (register == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0435\u0441\u0442\u0440!");
        }
        if (!register.isProcessed()) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0430\u0442\u0438\u0442\u044c \u043d\u0435\u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u0440\u0435\u0435\u0441\u0442\u0440!");
        }
        ArrayList<Integer> paymentIds = new ArrayList<Integer>();
        try (BalanceUtils balanceUtils = new BalanceUtils(con);){
            ChargeDao chargeDao = new ChargeDao(con);
            RegisterItemManager registerItemManager = new RegisterItemManager(con);
            for (RegisterItem item : registerItemManager.getRegisterItems(register)) {
                if (register.getRegisterType() == 1) {
                    chargeDao.delete(item.getBalanceItemId());
                } else {
                    paymentIds.add(item.getBalanceItemId());
                }
                item.setBalanceItemId(0);
                registerItemManager.updateRegisterItem(register, item);
                if (register.getRegisterType() != 1) continue;
                con.commit();
                Date date = item.getDate();
                balanceUtils.updateBalance(date != null ? date : register.getDate(), item.getContractId());
                EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(item.getContractId(), 4, item.getSumma().negate()));
            }
        }
        if (register.getRegisterType() == 0) {
            balanceUtils = new BalanceUtils(con);
            try (ContractDao contractManager = new ContractDao(con, this.userId);){
                PaymentDao paymentDao = new PaymentDao(con);
                List<Payment> payments = paymentDao.getPaymentsById(paymentIds);
                paymentDao.deletePaymentsById(paymentIds);
                con.commit();
                for (Payment payment : payments) {
                    Contract contract = (Contract)contractManager.get(payment.getContractId());
                    balanceUtils.updateBalance(payment.getDate(), contract);
                    con.commit();
                    EventProcessor.getInstance().publish(new PaymentDeletedEvent(0, payment));
                    EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum().negate()));
                }
            }
            finally {
                balanceUtils.close();
            }
        }
        register.setProcessed(false);
        registerManager.updateRegister(register);
    }

    @Override
    public void processRegister(int registerType, int registerId) throws Exception {
        RegisterManager registerManager = new RegisterManager(this.getConnection());
        Register register = registerManager.getRegisterById(registerId);
        if (register != null) {
            if (register.isProcessed()) {
                throw new BGMessageException("\u0420\u0435\u0435\u0441\u0442\u0440 \u0443\u0436\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d!");
            }
            registerManager.processRegister(this.userId, register);
        }
    }
}

