/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCard;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractCardService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractCardsListEvent;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractCardService")
public class ContractCardServiceImpl
extends AbstractService
implements ContractCardService {
    @Override
    public List<ContractCard> contractCardList(int contractId) throws Exception {
        ArrayList<ContractCard> cards = new ArrayList<ContractCard>();
        String card = "";
        Contract contract = contractId > 0 ? ContractDao.getContract(this.getConnection(), contractId) : null;
        int i = 1;
        while (card != null) {
            String[] arr;
            card = this.getSetup().get("contractcard." + i, null);
            if (card != null && (arr = card.split(":", 3)).length > 1 && (contract == null || arr.length <= 2 || (contract.getGroups() & Utils.enumToMask((String)arr[2])) != 0L)) {
                ContractCard contractCard = new ContractCard();
                contractCard.setId(arr[0].trim());
                contractCard.setTitle(arr[1]);
                cards.add(contractCard);
            }
            ++i;
        }
        GetContractCardsListEvent event = new GetContractCardsListEvent(this.userId, contractId, cards);
        event = EventProcessor.getInstance().request(event);
        return new ArrayList<ContractCard>(cards);
    }

    @Override
    public FileDto contractCardExport(int contractId, String contractCardId) throws Exception {
        List<ContractCard> contractCardList = this.contractCardList(contractId);
        boolean exists = false;
        for (ContractCard contractCard : contractCardList) {
            if (!contractCard.getId().equals(contractCardId)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            throw new BGIllegalArgumentException();
        }
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element card = document.createElement("card");
        Element user = XMLUtils.createElement((Element)card, (String)"user");
        user.setAttribute("id", String.valueOf(this.userId));
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter w = factory.createXMLStreamWriter(new DOMResult(card));
        new ContractUtils(this.getConnection()).addContractXML(contractId, w, true);
        document.appendChild(card);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
        XSLManager.getInstance().transform((Source)new DOMSource(document), contractCardId, FOUtils.renderSAXResult((OutputStream)baos, (String)"application/pdf"));
        baos.flush();
        FileDto contractCardDto = new FileDto();
        contractCardDto.setContentType("text/csv");
        contractCardDto.setFileName("export.csv");
        contractCardDto.setData(Base64.getEncoder().encodeToString(baos.toByteArray()));
        return contractCardDto;
    }
}

